/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogStatementGuardedByLogConditionInspection
extends BaseInspection {
    public String loggerClassName = "java.util.logging.Logger";
    public String loggerMethodAndconditionMethodNames = "fine,isLoggable(java.util.logging.Level.FINE),finer,isLoggable(java.util.logging.Level.FINER),finest,isLoggable(java.util.logging.Level.FINEST)";
    private final List<String> logMethodNameList = new ArrayList<String>();
    private final List<String> logConditionMethodNameList = new ArrayList<String>();

    public LogStatementGuardedByLogConditionInspection() {
        LogStatementGuardedByLogConditionInspection.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new Form().getContentPanel();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LogStatementGuardedByLogConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LogStatementGuardedByLogConditionVisitor();
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        LogStatementGuardedByLogConditionInspection.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.loggerMethodAndconditionMethodNames = LogStatementGuardedByLogConditionInspection.formatString(this.logMethodNameList, this.logConditionMethodNameList);
        super.writeSettings(element);
    }

    class Form {
        private JPanel contentPanel;
        private JTextField loggerClassNameTextField;
        private IGTable table;
        private JButton addButton;
        private JButton removeButton;

        Form() {
            this.$$$setupUI$$$();
            this.loggerClassNameTextField.setText(LogStatementGuardedByLogConditionInspection.this.loggerClassName);
            DocumentListener listener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                private void textChanged() {
                    LogStatementGuardedByLogConditionInspection.this.loggerClassName = Form.this.loggerClassNameTextField.getText();
                }
            };
            Document document = this.loggerClassNameTextField.getDocument();
            document.addDocumentListener(listener);
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
        }

        public JPanel getContentPanel() {
            return this.contentPanel;
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(Arrays.asList(LogStatementGuardedByLogConditionInspection.this.logMethodNameList, LogStatementGuardedByLogConditionInspection.this.logConditionMethodNameList), "log method name", "log condition text"));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JTextField jTextField;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("logger.name.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.loggerClassNameTextField = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, new Dimension(150, -1), null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 3, 2, 0, 3, 7, 7, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            jButton2.setText("Button");
            jButton2.setMargin(new Insets(2, 8, 2, 8));
            jPanel.add((Component)jButton2, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            jButton.setText("Button");
            jButton.setMargin(new Insets(2, 8, 2, 8));
            jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 2, 1, 1, 0, 2, 1, 6, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class LogStatementGuardedByLogConditionVisitor
    extends BaseInspectionVisitor {
        private LogStatementGuardedByLogConditionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LogStatementGuardedByLogConditionInspection.this.logMethodNameList.contains(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            if (!type.equalsToText(LogStatementGuardedByLogConditionInspection.this.loggerClassName)) {
                return;
            }
            if (this.isSurroundedByLogGuard(expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            if (PsiUtil.isConstantExpression((PsiExpression)firstArgument)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isSurroundedByLogGuard(PsiMethodCallExpression expression) {
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            return qualifierType != null && qualifierType.equalsToText(LogStatementGuardedByLogConditionInspection.this.loggerClassName);
        }
    }

    private class LogStatementGuardedByLogConditionFix
    extends InspectionGadgetsFix {
        private LogStatementGuardedByLogConditionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspection$LogStatementGuardedByLogConditionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element.getParent().getParent();
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            ArrayList<PsiStatement> logStatements = new ArrayList<PsiStatement>();
            logStatements.add(statement);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (previousStatement != null && this.isSameLogMethodCall(previousStatement, referenceName)) {
                logStatements.add(0, previousStatement);
                previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)previousStatement, PsiStatement.class);
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (nextStatement != null && this.isSameLogMethodCall(nextStatement, referenceName)) {
                logStatements.add(nextStatement);
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuilder ifStatementText = new StringBuilder("if (");
            ifStatementText.append(qualifier.getText());
            ifStatementText.append('.');
            int index = LogStatementGuardedByLogConditionInspection.this.logMethodNameList.indexOf(referenceName);
            String conditionMethodText = (String)LogStatementGuardedByLogConditionInspection.this.logConditionMethodNameList.get(index);
            ifStatementText.append(conditionMethodText);
            ifStatementText.append(") {}");
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifStatementText.toString(), (PsiElement)statement);
            PsiBlockStatement blockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (blockStatement == null) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement logStatement : logStatements) {
                codeBlock.add((PsiElement)logStatement);
            }
            PsiStatement firstStatement = (PsiStatement)logStatements.get(0);
            PsiElement parent = firstStatement.getParent();
            PsiElement result = parent.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences(result);
            for (PsiStatement logStatement : logStatements) {
                logStatement.delete();
            }
        }

        private boolean isSameLogMethodCall(PsiStatement statement, @NotNull String methodName) {
            if (methodName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspection$LogStatementGuardedByLogConditionFix.isSameLogMethodCall must not be null");
            }
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!methodName.equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = qualifier.getType();
            return type != null && type.equalsToText(LogStatementGuardedByLogConditionInspection.this.loggerClassName);
        }
    }
}

