/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceVariableUninitializedUseInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        if ("InstanceVariableUsedBeforeInitialized" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection.getID must not return null");
        }
        return "InstanceVariableUsedBeforeInitialized";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiExpression[] badReads;
            PsiType fieldType;
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection$InstanceVariableInitializationVisitor.visitField must not be null");
            }
            if (field.hasModifierProperty("static")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            if (InstanceVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (ImplicitUsageProvider provider : (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                if (!provider.isImplicitWrite((PsiElement)field)) continue;
                return;
            }
            UninitializedReadCollector uninitializedReadsCollector = new UninitializedReadCollector();
            if (!this.isInitializedInInitializer(field, uninitializedReadsCollector)) {
                PsiMethod[] constructors;
                PsiMethod[] arr$ = constructors = aClass.getConstructors();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    PsiMethod constructor = arr$[i$];
                    PsiCodeBlock body = constructor.getBody();
                    uninitializedReadsCollector.blockAssignsVariable(body, (PsiVariable)field);
                }
            }
            for (PsiExpression expression : badReads = uninitializedReadsCollector.getUninitializedReads()) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field, UninitializedReadCollector uninitializedReadsCollector) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspection$InstanceVariableInitializationVisitor.isInitializedInInitializer must not be null");
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body;
                if (initializer.hasModifierProperty("static") || !uninitializedReadsCollector.blockAssignsVariable(body = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }
    }
}

