/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ImportsAreUsedVisitor
extends JavaRecursiveElementVisitor {
    private final List<PsiImportStatement> importStatements;

    ImportsAreUsedVisitor(PsiImportStatement[] importStatements) {
        this.importStatements = new ArrayList<PsiImportStatement>(Arrays.asList(importStatements));
        Collections.reverse(this.importStatements);
    }

    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/ImportsAreUsedVisitor.visitReferenceElement must not be null");
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiClass)) {
            return;
        }
        PsiClass referencedClass = (PsiClass)element;
        String qualifiedName = referencedClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        ArrayList<PsiImportStatement> importStatementsCopy = new ArrayList<PsiImportStatement>(this.importStatements);
        for (PsiImportStatement importStatement : importStatementsCopy) {
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return;
            }
            if (importStatement.isOnDemand()) {
                String packageName;
                int lastComponentIndex = qualifiedName.lastIndexOf(46);
                if (lastComponentIndex <= 0 || !importName.equals(packageName = qualifiedName.substring(0, lastComponentIndex))) continue;
                this.removeAll(importStatement);
                break;
            }
            if (!importName.equals(qualifiedName)) continue;
            this.removeAll(importStatement);
            break;
        }
    }

    private void removeAll(@NotNull PsiImportStatement importStatement) {
        if (importStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/ImportsAreUsedVisitor.removeAll must not be null");
        }
        for (int i = this.importStatements.size() - 1; i >= 0; --i) {
            PsiImportStatement statement = this.importStatements.get(i);
            String statementText = statement.getText();
            String importText = importStatement.getText();
            if (!importText.equals(statementText)) continue;
            this.importStatements.remove(i);
        }
    }

    public PsiImportStatement[] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            return PsiImportStatement.EMPTY_ARRAY;
        }
        return this.importStatements.toArray(new PsiImportStatement[this.importStatements.size()]);
    }
}

