/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ReturnFromFinallyBlockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ReturnInsideFinallyBlock" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection.getID must not return null");
        }
        return "ReturnInsideFinallyBlock";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.from.finally.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.from.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnFromFinallyBlockVisitor();
    }

    private static class ReturnFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ReturnFromFinallyBlockVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection$ReturnFromFinallyBlockVisitor.visitReturnStatement must not be null");
            }
            super.visitReturnStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

