/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyCatchBlockInspection
extends BaseInspection {
    public boolean m_includeComments = true;
    public boolean m_ignoreTestCases = true;
    public boolean m_ignoreIgnoreParameter = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.catch.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyCatchBlockInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.catch.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyCatchBlockInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "m_includeComments");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.ignore.option", new Object[0]), "m_ignoreTestCases");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.ignore.ignore.option", new Object[0]), "m_ignoreIgnoreParameter");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyCatchBlockFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/EmptyCatchBlockInspection$EmptyCatchBlockVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            if (EmptyCatchBlockInspection.this.m_ignoreTestCases && TestUtils.isPartOfJUnitTestMethod((PsiElement)statement)) {
                return;
            }
            for (PsiCatchSection section : catchSections = statement.getCatchSections()) {
                this.checkCatchSection(section);
            }
        }

        private void checkCatchSection(PsiCatchSection section) {
            PsiCodeBlock block = section.getCatchBlock();
            if (block == null || !this.catchBlockIsEmpty(block)) {
                return;
            }
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            String parameterName = parameter.getName();
            if (EmptyCatchBlockInspection.this.m_ignoreIgnoreParameter && ("ignore".equals(parameterName) || "ignored".equals(parameterName))) {
                return;
            }
            PsiElement catchToken = section.getFirstChild();
            if (catchToken == null) {
                return;
            }
            this.registerError(catchToken, new Object[0]);
        }

        private boolean catchBlockIsEmpty(PsiCodeBlock block) {
            if (EmptyCatchBlockInspection.this.m_includeComments) {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (!(child instanceof PsiComment) && !(child instanceof PsiStatement)) continue;
                    return false;
                }
                return true;
            }
            PsiStatement[] statements = block.getStatements();
            return statements.length == 0;
        }
    }

    private static class EmptyCatchBlockFix
    extends InspectionGadgetsFix {
        private EmptyCatchBlockFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/EmptyCatchBlockInspection$EmptyCatchBlockFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent;
            PsiParameter parameter = catchSection.getParameter();
            if (parameter == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiManager manager = element.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier("ignored");
            identifier.replace((PsiElement)newIdentifier);
        }
    }
}

