/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseOfLocalVariableInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("reuse.of.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReuseOfLocalVariableFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReuseOfLocalVariableVisitor();
    }

    private static class ReuseOfLocalVariableVisitor
    extends BaseInspectionVisitor {
        private ReuseOfLocalVariableVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            int i;
            if (assignment == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(assignment);
            PsiElement assignmentParent = assignment.getParent();
            if (!(assignmentParent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiLocalVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)referent;
            if (variable.getInitializer() == null) {
                return;
            }
            PsiJavaToken sign = assignment.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs != null && VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                return;
            }
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (variableBlock == null) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.loopExistsBetween(assignment, variableBlock)) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.tryExistsBetween(assignment, variableBlock)) {
                return;
            }
            PsiElement assignmentBlock = assignmentParent.getParent();
            if (assignmentBlock == null) {
                return;
            }
            if (variableBlock.equals(assignmentBlock)) {
                this.registerError((PsiElement)lhs, new Object[0]);
            }
            PsiStatement[] statements = variableBlock.getStatements();
            PsiElement containingStatement = ReuseOfLocalVariableVisitor.getChildWhichContainsElement(variableBlock, (PsiElement)assignment);
            int statementPosition = -1;
            for (i = 0; i < statements.length; ++i) {
                if (!statements[i].equals(containingStatement)) continue;
                statementPosition = i;
                break;
            }
            if (statementPosition == -1) {
                return;
            }
            for (i = statementPosition + 1; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return;
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        private static boolean loopExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiWhileStatement) && !(elementToTest instanceof PsiForeachStatement) && !(elementToTest instanceof PsiForStatement) && !(elementToTest instanceof PsiDoWhileStatement)) continue;
                return true;
            }
            return false;
        }

        private static boolean tryExistsBetween(PsiAssignmentExpression assignment, PsiCodeBlock block) {
            for (PsiAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof PsiTryStatement)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static PsiElement getChildWhichContainsElement(@NotNull PsiCodeBlock ancestor, @NotNull PsiElement descendant) {
            if (ancestor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableVisitor.getChildWhichContainsElement must not be null");
            }
            if (descendant == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableVisitor.getChildWhichContainsElement must not be null");
            }
            PsiElement element = descendant;
            while (!element.equals(ancestor)) {
                descendant = element;
                if ((element = descendant.getParent()) != null) continue;
                return null;
            }
            return descendant;
        }
    }

    private static class ReuseOfLocalVariableFix
    extends InspectionGadgetsFix {
        private ReuseOfLocalVariableFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("reuse.of.local.variable.split.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/ReuseOfLocalVariableInspection$ReuseOfLocalVariableFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiLocalVariable variable = (PsiLocalVariable)referenceExpression.resolve();
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)referenceExpression.getParent();
            assert (assignment != null);
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)assignment.getParent();
            PsiExpression lExpression = assignment.getLExpression();
            String originalVariableName = lExpression.getText();
            assert (variable != null);
            PsiType type = variable.getType();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            PsiCodeBlock variableBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            String newVariableName = codeStyleManager.suggestUniqueVariableName(originalVariableName, (PsiElement)variableBlock, false);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)assignmentStatement, PsiCodeBlock.class);
            Object scope = codeBlock != null ? new LocalSearchScope((PsiElement)codeBlock) : variable.getUseScope();
            Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)false);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            ArrayList<PsiReferenceExpression> collectedReferences = new ArrayList<PsiReferenceExpression>();
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                if (referenceElement == null) continue;
                TextRange textRange = assignmentStatement.getTextRange();
                if (referenceElement.getTextOffset() <= textRange.getEndOffset()) continue;
                PsiExpression newExpression = factory.createExpressionFromText(newVariableName, referenceElement);
                PsiReferenceExpression replacementExpression = (PsiReferenceExpression)referenceElement.replace((PsiElement)newExpression);
                collectedReferences.add(replacementExpression);
            }
            PsiExpression rhs = assignment.getRExpression();
            String rhsText = rhs == null ? "" : rhs.getText();
            String newStatementText = type.getCanonicalText() + ' ' + newVariableName + " =  " + rhsText + ';';
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)assignmentStatement);
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)assignmentStatement.replace((PsiElement)newStatement);
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            PsiLocalVariable newVariable = (PsiLocalVariable)elements[0];
            PsiElement context = declarationStatement.getParent();
            HighlightUtils.showRenameTemplate(context, (PsiNameIdentifierOwner)newVariable, (PsiReference[])collectedReferences.toArray(new PsiReferenceExpression[collectedReferences.size()]));
        }
    }
}

