/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrredNotEqualExpressionInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("orred.not.equal.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/OrredNotEqualExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("orred.not.equal.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/OrredNotEqualExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new OrredNotEqualExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OrredNotEqualExpressionVisitor();
    }

    private static class OrredNotEqualExpressionVisitor
    extends BaseInspectionVisitor {
        private OrredNotEqualExpressionVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            Pair<PsiReferenceExpression, PsiExpression> pair1 = OrredNotEqualExpressionVisitor.getReferenceExpressionPair(lhs);
            Pair<PsiReferenceExpression, PsiExpression> pair2 = OrredNotEqualExpressionVisitor.getReferenceExpressionPair(rhs);
            if (pair1 == null || pair2 == null) {
                return;
            }
            PsiExpression expression1 = (PsiExpression)pair1.getSecond();
            PsiExpression expression2 = (PsiExpression)pair2.getSecond();
            if (expression1 == null || expression2 == null) {
                return;
            }
            Project project = expression1.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
            Object constant1 = constantEvaluationHelper.computeConstantExpression((PsiElement)expression1);
            Object constant2 = constantEvaluationHelper.computeConstantExpression((PsiElement)expression2);
            if (constant1 == null || constant2 == null || constant1 == constant2) {
                return;
            }
            PsiReferenceExpression referenceExpression1 = (PsiReferenceExpression)pair1.getFirst();
            PsiReferenceExpression referenceExpression2 = (PsiReferenceExpression)pair2.getFirst();
            if (referenceExpression1.resolve() == referenceExpression2.resolve()) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        @Nullable
        private static Pair<PsiReferenceExpression, PsiExpression> getReferenceExpressionPair(PsiExpression expression) {
            if (!(expression instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.NE != tokenType) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (lhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lref = (PsiReferenceExpression)lhs;
                return new Pair((Object)lref, (Object)rhs);
            }
            if (rhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression rref = (PsiReferenceExpression)rhs;
                return new Pair((Object)rref, (Object)lhs);
            }
            return null;
        }
    }

    private static class OrredNotEqualExpressionFix
    extends InspectionGadgetsFix {
        private OrredNotEqualExpressionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("orred.not.equal.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/OrredNotEqualExpressionInspection$OrredNotEqualExpressionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lhs = binaryExpression.getLOperand();
            String lhsText = lhs.getText();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            String rhsText = rhs.getText();
            OrredNotEqualExpressionFix.replaceExpression((PsiExpression)binaryExpression, lhsText + "&&" + rhsText);
        }
    }
}

