/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryContinueInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryContinueInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.continue.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/UnnecessaryContinueInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryContinueVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("continue");
    }

    private static class UnnecessaryContinueVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryContinueVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/UnnecessaryContinueInspection$UnnecessaryContinueVisitor.visitContinueStatement must not be null");
            }
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement continuedStatement = statement.findContinuedStatement();
            PsiStatement body = null;
            if (continuedStatement instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)continuedStatement;
                body = foreachStatement.getBody();
            } else if (continuedStatement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)continuedStatement;
                body = forStatement.getBody();
            } else if (continuedStatement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)continuedStatement;
                body = doWhileStatement.getBody();
            } else if (continuedStatement instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)continuedStatement;
                body = whileStatement.getBody();
            }
            if (body == null) {
                return;
            }
            if (body instanceof PsiBlockStatement) {
                PsiCodeBlock block = ((PsiBlockStatement)body).getCodeBlock();
                if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)statement)) {
                    this.registerStatementError((PsiStatement)statement, new Object[0]);
                }
            } else if (ControlFlowUtils.statementCompletesWithStatement(body, (PsiStatement)statement)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }
    }
}

