/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessBooleanExpressionInspection
extends BaseInspection {
    private static final Set<String> booleanTokens = new HashSet<String>(7);
    public boolean m_ignoreExpressionsContainingConstants = false;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        if (infos[0] instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)infos[0];
            string = InspectionGadgetsBundle.message("string.can.be.simplified.problem.descriptor", this.calculateSimplifiedBinaryExpression(expression));
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection.buildErrorString must not return null");
            return string;
        }
        PsiPrefixExpression expression = (PsiPrefixExpression)infos[0];
        string = InspectionGadgetsBundle.message("string.can.be.simplified.problem.descriptor", this.calculateSimplifiedPrefixExpression(expression));
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Nullable
    private String calculateSimplifiedBinaryExpression(PsiBinaryExpression expression) {
        PsiJavaToken sign = expression.getOperationSign();
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return null;
        }
        IElementType tokenType = sign.getTokenType();
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.AND)) {
            if (this.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.OR)) {
            if (this.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (tokenType.equals(JavaTokenType.XOR) || tokenType.equals(JavaTokenType.NE)) {
            if (this.isFalse(lhs)) {
                return rhsText;
            }
            if (this.isFalse(rhs)) {
                return lhsText;
            }
            if (this.isTrue(lhs)) {
                return PointlessBooleanExpressionInspection.createStringForNegatedExpression(rhs);
            }
            return PointlessBooleanExpressionInspection.createStringForNegatedExpression(lhs);
        }
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            if (this.isTrue(lhs)) {
                return rhsText;
            }
            if (this.isTrue(rhs)) {
                return lhsText;
            }
            if (this.isFalse(lhs)) {
                return PointlessBooleanExpressionInspection.createStringForNegatedExpression(rhs);
            }
            return PointlessBooleanExpressionInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(PsiExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)exp;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(exp) > 3) {
            return "!(" + exp.getText() + ')';
        }
        return '!' + exp.getText();
    }

    private String calculateSimplifiedPrefixExpression(PsiPrefixExpression expression) {
        PsiExpression operand = expression.getOperand();
        if (this.isTrue(operand)) {
            return "false";
        }
        return "true";
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanLiteralComparisonFix();
    }

    private boolean isTrue(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        if (expression == null) {
            return false;
        }
        Boolean value = (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.BOOLEAN);
        return value != null && value != false;
    }

    private boolean isFalse(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        if (expression == null) {
            return false;
        }
        Boolean value = (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.BOOLEAN);
        return value != null && value == false;
    }

    static {
        booleanTokens.add("&&");
        booleanTokens.add("&");
        booleanTokens.add("||");
        booleanTokens.add("|");
        booleanTokens.add("^");
        booleanTokens.add("==");
        booleanTokens.add("!=");
    }

    private class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private PointlessBooleanExpressionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionVisitor.visitClass must not be null");
            }
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            String tokenText = sign.getText();
            if (!booleanTokens.contains(tokenText)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return;
            }
            if (!rhsType.equals(PsiType.BOOLEAN) && !rhsType.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return;
            }
            if (!lhsType.equals(PsiType.BOOLEAN) && !lhsType.equalsToText("java.lang.Boolean")) {
                return;
            }
            IElementType tokenType = sign.getTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE) ? this.equalityExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.AND) ? this.andExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.OR) ? this.orExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.XOR) ? this.xorExpressionIsPointless(lhs, rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$PointlessBooleanExpressionVisitor.visitPrefixExpression must not be null");
            }
            super.visitPrefixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            PsiExpression operand = expression.getOperand();
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.EXCL) && this.notExpressionIsPointless(operand)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private boolean equalityExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBooleanExpressionInspection.this.isTrue(lhs) || PointlessBooleanExpressionInspection.this.isTrue(rhs) || PointlessBooleanExpressionInspection.this.isFalse(lhs) || PointlessBooleanExpressionInspection.this.isFalse(rhs);
        }

        private boolean andExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBooleanExpressionInspection.this.isTrue(lhs) || PointlessBooleanExpressionInspection.this.isTrue(rhs);
        }

        private boolean orExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBooleanExpressionInspection.this.isFalse(lhs) || PointlessBooleanExpressionInspection.this.isFalse(rhs);
        }

        private boolean xorExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBooleanExpressionInspection.this.isTrue(lhs) || PointlessBooleanExpressionInspection.this.isTrue(rhs) || PointlessBooleanExpressionInspection.this.isFalse(lhs) || PointlessBooleanExpressionInspection.this.isFalse(rhs);
        }

        private boolean notExpressionIsPointless(PsiExpression arg) {
            return PointlessBooleanExpressionInspection.this.isFalse(arg) || PointlessBooleanExpressionInspection.this.isTrue(arg);
        }
    }

    private class BooleanLiteralComparisonFix
    extends InspectionGadgetsFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/PointlessBooleanExpressionInspection$BooleanLiteralComparisonFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiBinaryExpression) {
                PsiBinaryExpression expression = (PsiBinaryExpression)element;
                String newExpression = PointlessBooleanExpressionInspection.this.calculateSimplifiedBinaryExpression(expression);
                if (newExpression == null) {
                    return;
                }
                BooleanLiteralComparisonFix.replaceExpression((PsiExpression)expression, newExpression);
            } else {
                PsiPrefixExpression expression = (PsiPrefixExpression)element;
                String replacementString = PointlessBooleanExpressionInspection.this.calculateSimplifiedPrefixExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression((PsiExpression)expression, replacementString);
            }
        }
    }
}

