/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedSwitchStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NestedSwitchStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/NestedSwitchStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSwitchStatementVisitor();
    }

    private static class NestedSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/NestedSwitchStatementInspection$NestedSwitchStatementVisitor.visitSwitchStatement must not be null");
            }
            super.visitSwitchStatement(statement);
            PsiElement containingSwitchStatement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
            if (containingSwitchStatement == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            PsiMethod containingContainingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)containingSwitchStatement, PsiMethod.class);
            if (containingMethod == null || containingContainingMethod == null || !containingMethod.equals(containingContainingMethod)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

