/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionQueryCalledVisitor
extends JavaRecursiveElementVisitor {
    @NonNls
    private static final Set<String> queryNames = new HashSet<String>(35);
    private boolean queried = false;
    private final PsiVariable variable;

    CollectionQueryCalledVisitor(PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CollectionQueryCalledVisitor.visitElement must not be null");
        }
        if (!this.queried) {
            super.visitElement(element);
        }
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CollectionQueryCalledVisitor.visitForeachStatement must not be null");
        }
        if (this.queried) {
            return;
        }
        super.visitForeachStatement(statement);
        PsiExpression qualifier = statement.getIteratedValue();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReference referenceExpression = (PsiReference)qualifier;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (!referent.equals(this.variable)) {
            return;
        }
        this.queried = true;
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        String methodName;
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CollectionQueryCalledVisitor.visitMethodCallExpression must not be null");
        }
        if (this.queried) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        boolean isStatement = call.getParent() instanceof PsiExpressionStatement;
        if (isStatement && !queryNames.contains(methodName = methodExpression.getReferenceName())) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        this.checkQualifier(qualifier);
    }

    private void checkQualifier(PsiExpression expression) {
        if (this.queried) {
            return;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.queried = true;
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            this.checkQualifier(parenthesizedExpression.getExpression());
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            this.checkQualifier(thenExpression);
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            this.checkQualifier(elseExpression);
        }
    }

    public boolean isQueried() {
        return this.queried;
    }

    static {
        queryNames.add("clone");
        queryNames.add("contains");
        queryNames.add("containsAll");
        queryNames.add("containsKey");
        queryNames.add("containsValue");
        queryNames.add("copyInto");
        queryNames.add("drainTo");
        queryNames.add("entrySet");
        queryNames.add("element");
        queryNames.add("elements");
        queryNames.add("empty");
        queryNames.add("enumeration");
        queryNames.add("firstElement");
        queryNames.add("get");
        queryNames.add("getFirst");
        queryNames.add("getLast");
        queryNames.add("getProperty");
        queryNames.add("indexOf");
        queryNames.add("isEmpty");
        queryNames.add("iterator");
        queryNames.add("keys");
        queryNames.add("keySet");
        queryNames.add("lastElement");
        queryNames.add("lastIndexOf");
        queryNames.add("peek");
        queryNames.add("poll");
        queryNames.add("pop");
        queryNames.add("propertyNames");
        queryNames.add("save");
        queryNames.add("size");
        queryNames.add("store");
        queryNames.add("storeToXML");
        queryNames.add("subList");
        queryNames.add("toArray");
        queryNames.add("values");
    }
}

