/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToCollectionFieldFromParameterInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = true;

    @NotNull
    public String getID() {
        if ("AssignmentToCollectionOrArrayFieldFromParameter" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToCollectionFieldFromParameterInspection.getID must not return null");
        }
        return "AssignmentToCollectionOrArrayFieldFromParameter";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.collection.array.field.from.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToCollectionFieldFromParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiExpression rhs = (PsiExpression)infos[0];
        PsiField field = (PsiField)infos[1];
        PsiType type = field.getType();
        if (type instanceof PsiArrayType) {
            string = InspectionGadgetsBundle.message("assignment.collection.array.field.from.parameter.problem.descriptor.array", rhs.getText());
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToCollectionFieldFromParameterInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("assignment.collection.array.field.from.parameter.problem.descriptor.collection", rhs.getText());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentToCollectionFieldFromParameterInspection.buildErrorString must not return null");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.collection.array.field.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToCollectionFieldFromParameterVisitor();
    }

    private class AssignmentToCollectionFieldFromParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToCollectionFieldFromParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            PsiMethod containingMethod;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentToCollectionFieldFromParameterInspection$AssignmentToCollectionFieldFromParameterVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = expression.getRExpression();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.EQ)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            if (AssignmentToCollectionFieldFromParameterInspection.this.ignorePrivateMethods && ((containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class)) == null || containingMethod.hasModifierProperty("private"))) {
                return;
            }
            PsiElement element = ((PsiReference)rhs).resolve();
            if (!(element instanceof PsiParameter)) {
                return;
            }
            if (!(element.getParent() instanceof PsiParameterList)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!CollectionUtils.isArrayOrCollectionField(field)) {
                return;
            }
            this.registerError((PsiElement)lhs, rhs, field);
        }
    }
}

