/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlyStrongTypeCastInspection
extends BaseInspection {
    public boolean ignoreInMatchingInstanceof = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType expectedType = (PsiType)infos[0];
        String typeText = expectedType.getPresentableText();
        String string = InspectionGadgetsBundle.message("overly.strong.type.cast.problem.descriptor", typeText);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overly.strong.type.cast.ignore.in.matching.instanceof.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInMatchingInstanceof");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new OverlyStrongCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyStrongTypeCastVisitor();
    }

    private class OverlyStrongTypeCastVisitor
    extends BaseInspectionVisitor {
        private OverlyStrongTypeCastVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            PsiArrayType arrayType;
            PsiType componentType;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongTypeCastVisitor.visitTypeCastExpression must not be null");
            }
            super.visitTypeCastExpression(expression);
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (operandType == null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
            if (expectedType == null) {
                return;
            }
            if (expectedType.equals(type)) {
                return;
            }
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)expectedType);
            if (resolved != null && !resolved.isPhysical()) {
                return;
            }
            if (expectedType.isAssignableFrom(operandType)) {
                return;
            }
            if (this.isTypeParameter(expectedType)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && this.isTypeParameter(componentType = (arrayType = (PsiArrayType)expectedType).getDeepComponentType())) {
                return;
            }
            if (type instanceof PsiPrimitiveType || expectedType instanceof PsiPrimitiveType) {
                return;
            }
            if (PsiPrimitiveType.getUnboxedType((PsiType)type) != null || PsiPrimitiveType.getUnboxedType((PsiType)expectedType) != null) {
                return;
            }
            if (expectedType instanceof PsiClassType) {
                PsiClassType classType;
                PsiClassType rawType;
                PsiClassType expectedClassType = (PsiClassType)expectedType;
                PsiClassType expectedRawType = expectedClassType.rawType();
                if (type.equals(expectedRawType)) {
                    return;
                }
                if (type instanceof PsiClassType && (rawType = (classType = (PsiClassType)type).rawType()).equals((Object)expectedRawType)) {
                    return;
                }
                if (type instanceof PsiArrayType) {
                    return;
                }
            }
            if (OverlyStrongTypeCastInspection.this.ignoreInMatchingInstanceof && InstanceOfUtils.hasAgreeingInstanceof(expression)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, expectedType);
        }

        private boolean isTypeParameter(PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            return aClass instanceof PsiTypeParameter;
        }
    }

    private static class OverlyStrongCastFix
    extends InspectionGadgetsFix {
        private OverlyStrongCastFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("overly.strong.type.cast.weaken.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/OverlyStrongTypeCastInspection$OverlyStrongCastFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression expression = (PsiTypeCastExpression)castTypeElement.getParent();
            if (expression == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
            if (expectedType == null) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            String newExpression = '(' + expectedType.getCanonicalText() + ')' + operand.getText();
            OverlyStrongCastFix.replaceExpressionAndShorten((PsiExpression)expression, newExpression);
        }
    }
}

