/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.tools.javac.JavaAwareResolveVisitor;
import org.codehaus.groovy.tools.javac.JavaStubGenerator;
import org.jetbrains.groovy.compiler.rt.CompilationUnitPatcher;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;
import org.jetbrains.groovy.compiler.rt.GroovyCompilerWrapper;
import org.jetbrains.groovy.compiler.rt.PsiAwareResourceLoader;

public class GroovycRunner {
    public static final String PATCHERS = "patchers";
    public static final String ENCODING = "encoding";
    public static final String OUTPUTPATH = "outputpath";
    public static final String FINAL_OUTPUTPATH = "final_outputpath";
    public static final String END = "end";
    public static final String SRC_FILE = "src_file";
    public static final String COMPILED_START = "%%c";
    public static final String COMPILED_END = "/%c";
    public static final String TO_RECOMPILE_START = "%%rc";
    public static final String TO_RECOMPILE_END = "/%rc";
    public static final String MESSAGES_START = "%%m";
    public static final String MESSAGES_END = "/%m";
    public static final String SEPARATOR = "#%%#%%%#%%%%%%%%%#";
    public static final String PRESENTABLE_MESSAGE = "@#$%@# Presentable:";
    public static final String CLEAR_PRESENTABLE = "$@#$%^ CLEAR_PRESENTABLE";

    private GroovycRunner() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("There is no arguments for groovy compiler");
            return;
        }
        boolean forStubs = "stubs".equals(args[0]);
        File argsFile = new File(args[1]);
        if (!argsFile.exists()) {
            System.err.println("Arguments file for groovy compiler not found");
            return;
        }
        try {
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            compilerConfiguration.setOutput(new PrintWriter(System.err));
            compilerConfiguration.setWarningLevel(3);
            ArrayList compilerMessages = new ArrayList();
            ArrayList patchers = new ArrayList();
            ArrayList srcFiles = new ArrayList();
            HashMap class2File = new HashMap();
            String[] finalOutput = new String[1];
            GroovycRunner.fillFromArgsFile(argsFile, compilerConfiguration, patchers, compilerMessages, srcFiles, class2File, finalOutput);
            if (srcFiles.isEmpty()) {
                return;
            }
            System.out.println("@#$%@# Presentable:Groovy compiler: loading sources...");
            CompilationUnit unit = GroovycRunner.createCompilationUnit(forStubs, compilerConfiguration, finalOutput[0]);
            GroovycRunner.addSources(forStubs, srcFiles, unit);
            GroovycRunner.runPatchers(patchers, compilerMessages, class2File, unit);
            System.out.println("@#$%@# Presentable:Groovyc: compiling...");
            List compiledFiles = GroovyCompilerWrapper.compile(compilerMessages, forStubs, unit);
            System.out.println(CLEAR_PRESENTABLE);
            System.out.println();
            GroovycRunner.reportCompiledItems(compiledFiles);
            System.out.println();
            if (compiledFiles.isEmpty()) {
                GroovycRunner.reportNotCompiledItems(srcFiles);
            }
            int errorCount = 0;
            for (int i = 0; i < compilerMessages.size(); ++i) {
                CompilerMessage message = (CompilerMessage)compilerMessages.get(i);
                if (message.getCategory() == "error") {
                    if (errorCount > 100) continue;
                    ++errorCount;
                }
                GroovycRunner.printMessage(message);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fillFromArgsFile(File argsFile, CompilerConfiguration compilerConfiguration, List patchers, List compilerMessages, List srcFiles, Map class2File, String[] finalOutput) {
        String line;
        String moduleClasspath = null;
        BufferedReader reader = null;
        try {
            FileInputStream stream = new FileInputStream(argsFile);
            reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null && SRC_FILE.equals(line)) {
                File file = new File(reader.readLine());
                srcFiles.add(file);
                while (!END.equals(line = reader.readLine())) {
                    class2File.put(line, file);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return moduleClasspath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return moduleClasspath;
        }
        while (line != null) {
            block35: {
                String s;
                block33: {
                    block36: {
                        block34: {
                            if (line.startsWith(PATCHERS)) break block33;
                            if (!line.startsWith(ENCODING)) break block34;
                            compilerConfiguration.setSourceEncoding(reader.readLine());
                            break block35;
                        }
                        if (!line.startsWith(OUTPUTPATH)) break block36;
                        compilerConfiguration.setTargetDirectory(reader.readLine());
                        break block35;
                    }
                    if (!line.startsWith(FINAL_OUTPUTPATH)) break block35;
                    finalOutput[0] = reader.readLine();
                    break block35;
                }
                while (!END.equals(s = reader.readLine())) {
                    try {
                        CompilationUnitPatcher patcher = (CompilationUnitPatcher)Class.forName(s).newInstance();
                        patchers.add(patcher);
                    }
                    catch (InstantiationException e) {
                        GroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (IllegalAccessException e) {
                        GroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (ClassNotFoundException e) {
                        GroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                }
            }
            line = reader.readLine();
        }
        return moduleClasspath;
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                argsFile.delete();
            }
        }
    }

    private static void addSources(boolean forStubs, List srcFiles, CompilationUnit unit) {
        for (int i = 0; i < srcFiles.size(); ++i) {
            final File file = (File)srcFiles.get(i);
            if (forStubs && file.getName().endsWith(".java")) continue;
            unit.addSource(new SourceUnit(file, unit.getConfiguration(), unit.getClassLoader(), unit.getErrorCollector()){

                public void parse() throws CompilationFailedException {
                    System.out.println("@#$%@# Presentable:Parsing " + file.getName() + "...");
                    super.parse();
                    System.out.println(GroovycRunner.CLEAR_PRESENTABLE);
                }
            });
        }
    }

    private static void runPatchers(List patchers, List compilerMessages, Map class2File, CompilationUnit unit) {
        if (!patchers.isEmpty()) {
            PsiAwareResourceLoader loader = new PsiAwareResourceLoader(class2File);
            for (int i = 0; i < patchers.size(); ++i) {
                CompilationUnitPatcher patcher = (CompilationUnitPatcher)patchers.get(i);
                try {
                    patcher.patchCompilationUnit(unit, loader);
                    continue;
                }
                catch (LinkageError e) {
                    GroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't run " + patcher.getClass().getName());
                }
            }
        }
    }

    private static void reportNotCompiledItems(Collection toRecompile) {
        Iterator iterator = toRecompile.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            System.out.print(TO_RECOMPILE_START);
            System.out.print(file.getAbsolutePath());
            System.out.print(TO_RECOMPILE_END);
            System.out.println();
        }
    }

    private static void reportCompiledItems(List compiledFiles) {
        for (int i = 0; i < compiledFiles.size(); ++i) {
            GroovyCompilerWrapper.OutputItem compiledOutputItem = (GroovyCompilerWrapper.OutputItem)compiledFiles.get(i);
            System.out.print(COMPILED_START);
            System.out.print(compiledOutputItem.getOutputPath());
            System.out.print(SEPARATOR);
            System.out.print(compiledOutputItem.getSourceFile());
            System.out.print(SEPARATOR);
            System.out.print(compiledOutputItem.getOutputRootDirectory());
            System.out.print(COMPILED_END);
            System.out.println();
        }
    }

    private static void printMessage(CompilerMessage message) {
        System.out.print(MESSAGES_START);
        System.out.print(message.getCategory());
        System.out.print(SEPARATOR);
        System.out.print(message.getMessage());
        System.out.print(SEPARATOR);
        System.out.print(message.getUrl());
        System.out.print(SEPARATOR);
        System.out.print(message.getLineNum());
        System.out.print(SEPARATOR);
        System.out.print(message.getColumnNum());
        System.out.print(SEPARATOR);
        System.out.print(MESSAGES_END);
        System.out.println();
    }

    private static void addExceptionInfo(List compilerMessages, Throwable e, String message) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        compilerMessages.add(new CompilerMessage("warning", message + ":\n" + writer, "<exception>", -1, -1));
    }

    private static CompilationUnit createCompilationUnit(final boolean forStubs, CompilerConfiguration config, final String finalOutput) {
        CompilationUnit unit;
        config.setClasspath("");
        GroovyClassLoader classLoader = GroovycRunner.buildClassLoaderFor(config);
        GroovyClassLoader transformLoader = new GroovyClassLoader(classLoader){

            public Enumeration getResources(String name) throws IOException {
                if (name.endsWith("org.codehaus.groovy.transform.ASTTransformation")) {
                    Enumeration resources = super.getResources(name);
                    ArrayList list = Collections.list(resources);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String file = ((URL)iterator.next()).getFile();
                        if (!file.contains(finalOutput)) continue;
                        iterator.remove();
                    }
                    return Collections.enumeration(list);
                }
                return super.getResources(name);
            }
        };
        try {
            unit = new CompilationUnit(config, null, classLoader, transformLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        System.out.println(GroovycRunner.PRESENTABLE_MESSAGE + (forStubs ? "Groovy stub generator: " : "Groovy compiler: ") + this.getPhaseDescription());
                    }
                }
            };
        }
        catch (NoSuchMethodError e) {
            unit = new CompilationUnit(config, null, classLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        System.out.println(GroovycRunner.PRESENTABLE_MESSAGE + (forStubs ? "Groovy stub generator: " : "Groovy compiler: ") + this.getPhaseDescription());
                    }
                }
            };
        }
        if (forStubs) {
            try {
                GroovycRunner.addStubGeneration(config, unit);
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        return unit;
    }

    private static void addStubGeneration(CompilerConfiguration config, final CompilationUnit unit) {
        boolean useJava5 = config.getTargetBytecode().equals("1.5");
        final JavaStubGenerator stubGenerator = new JavaStubGenerator(config.getTargetDirectory(), false, useJava5);
        unit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode node) throws CompilationFailedException {
                new JavaAwareResolveVisitor(unit).startResolving(node, source);
            }
        }, 3);
        unit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode node) throws CompilationFailedException {
                String name = node.getNameWithoutPackage();
                if ("package-info".equals(name)) {
                    return;
                }
                System.out.println("@#$%@# Presentable:Generating stub for " + name);
                try {
                    stubGenerator.generateClass(node);
                }
                catch (FileNotFoundException e) {
                    source.addException((Exception)e);
                }
            }
        }, 3);
    }

    static GroovyClassLoader buildClassLoaderFor(final CompilerConfiguration compilerConfiguration) {
        return (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyClassLoader(this.getClass().getClassLoader(), compilerConfiguration){

                    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException, CompilationFailedException {
                        try {
                            return super.loadClass(name, lookupScriptFiles, preferClassOverScript);
                        }
                        catch (NoClassDefFoundError e) {
                            String ncdfe = e.getMessage();
                            throw new RuntimeException("Groovyc error: " + ncdfe + " class not found while resolving class " + name + "; try compiling " + ncdfe + " explicitly", e);
                        }
                        catch (LinkageError e) {
                            throw new RuntimeException("Problem loading class " + name, e);
                        }
                    }
                };
            }
        });
    }
}

