/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;

public class GroovyCompilerWrapper {
    private static final String LINE_AT = " @ line ";

    private GroovyCompilerWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List compile(List collector, boolean forStubs, CompilationUnit unit) {
        ArrayList compiledFiles = new ArrayList();
        try {
            unit.compile(forStubs ? 3 : 9);
            GroovyCompilerWrapper.addCompiledFiles(unit, compiledFiles, forStubs, collector);
        }
        catch (CompilationFailedException e) {
            GroovyCompilerWrapper.processCompilationException((Exception)((Object)e), collector, forStubs);
        }
        catch (IOException e) {
            GroovyCompilerWrapper.processException(e, collector, forStubs);
        }
        catch (NoClassDefFoundError e) {
            String className = e.getMessage();
            if (className.startsWith("org/apache/ivy/")) {
                GroovyCompilerWrapper.addMessageWithoutLocation(collector, "Cannot @Grab without Ivy, please add it to your module dependencies (NoClassDefFoundError: " + className + ")", true);
            } else {
                GroovyCompilerWrapper.addMessageWithoutLocation(collector, "Groovyc error: " + className + " class not found, try compiling it explicitly", !forStubs);
            }
        }
        finally {
            GroovyCompilerWrapper.addWarnings(unit.getErrorCollector(), collector);
        }
        return compiledFiles;
    }

    private static void addCompiledFiles(CompilationUnit compilationUnit, final List compiledFiles, boolean forStubs, List collector) throws IOException {
        File targetDirectory = compilationUnit.getConfiguration().getTargetDirectory();
        final String outputPath = targetDirectory.getCanonicalPath().replace(File.separatorChar, '/');
        if (forStubs) {
            compilationUnit.applyToPrimaryClassNodes(new CompilationUnit.PrimaryClassNodeOperation(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    String topLevel = classNode.getName();
                    String stubPath = outputPath + "/" + topLevel.replace('.', '/') + ".java";
                    String fileName = source.getName();
                    if (new File(stubPath).exists()) {
                        compiledFiles.add(new OutputItemImpl(outputPath, stubPath, fileName));
                    }
                }
            });
            return;
        }
        TreeSet<String> allClasses = new TreeSet<String>();
        List listOfClasses = compilationUnit.getClasses();
        for (int i = 0; i < listOfClasses.size(); ++i) {
            allClasses.add(((GroovyClass)listOfClasses.get(i)).getName());
        }
        Iterator iterator = compilationUnit.iterator();
        while (iterator.hasNext()) {
            SourceUnit sourceUnit = (SourceUnit)iterator.next();
            String fileName = sourceUnit.getName();
            ModuleNode ast = sourceUnit.getAST();
            List topLevelClasses = ast.getClasses();
            for (int i = 0; i < topLevelClasses.size(); ++i) {
                String className;
                ClassNode classNode = (ClassNode)topLevelClasses.get(i);
                String topLevel = classNode.getName();
                String nested = topLevel + "$";
                SortedSet<String> tail = allClasses.tailSet(topLevel);
                Iterator tailIter = tail.iterator();
                while (tailIter.hasNext() && ((className = (String)tailIter.next()).equals(topLevel) || className.startsWith(nested))) {
                    tailIter.remove();
                    compiledFiles.add(new OutputItemImpl(outputPath, outputPath + "/" + className.replace('.', '/') + ".class", fileName));
                }
            }
        }
    }

    private static void addWarnings(ErrorCollector errorCollector, List collector) {
        for (int i = 0; i < errorCollector.getWarningCount(); ++i) {
            WarningMessage warning = errorCollector.getWarning(i);
            collector.add(new CompilerMessage("warning", warning.getMessage(), null, -1, -1));
        }
    }

    private static void processCompilationException(Exception exception, List collector, boolean forStubs) {
        if (exception instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException multipleCompilationErrorsException = (MultipleCompilationErrorsException)exception;
            ErrorCollector errorCollector = multipleCompilationErrorsException.getErrorCollector();
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                GroovyCompilerWrapper.processException(errorCollector.getError(i), collector, forStubs);
            }
        } else {
            GroovyCompilerWrapper.processException(exception, collector, forStubs);
        }
    }

    private static void processException(Message message, List collector, boolean forStubs) {
        if (message instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
            GroovyCompilerWrapper.addErrorMessage(syntaxErrorMessage.getCause(), collector);
        } else if (message instanceof ExceptionMessage) {
            ExceptionMessage exceptionMessage = (ExceptionMessage)message;
            GroovyCompilerWrapper.processException(exceptionMessage.getCause(), collector, forStubs);
        } else if (message instanceof SimpleMessage) {
            GroovyCompilerWrapper.addErrorMessage((SimpleMessage)message, collector);
        } else {
            GroovyCompilerWrapper.addMessageWithoutLocation(collector, "An unknown error occurred: " + message, true);
        }
    }

    private static void processException(Exception exception, List collector, boolean forStubs) {
        if (exception instanceof GroovyRuntimeException) {
            GroovyCompilerWrapper.addErrorMessage((GroovyRuntimeException)exception, collector);
        } else if (forStubs) {
            GroovyCompilerWrapper.addMessageWithoutLocation(collector, "Groovyc stub generation failed: " + exception.getMessage(), false);
        } else {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            GroovyCompilerWrapper.addMessageWithoutLocation(collector, writer.toString(), true);
        }
    }

    private static void addMessageWithoutLocation(List collector, String message, boolean error) {
        collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private static void addErrorMessage(SyntaxException exception, List collector) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        collector.add(new CompilerMessage("error", justMessage, exception.getSourceLocator(), exception.getLine(), exception.getStartColumn()));
    }

    private static void addErrorMessage(GroovyRuntimeException exception, List collector) {
        ASTNode astNode = exception.getNode();
        ModuleNode module = exception.getModule();
        if (module == null) {
            module = GroovyCompilerWrapper.findModule(astNode);
        }
        collector.add(new CompilerMessage("error", exception.getMessageWithoutLocationText(), module == null ? "<no module>" : module.getDescription(), astNode.getLineNumber(), astNode.getColumnNumber()));
    }

    private static ModuleNode findModule(ASTNode node) {
        if (node instanceof ModuleNode) {
            return (ModuleNode)node;
        }
        if (node instanceof ClassNode) {
            return ((ClassNode)node).getModule();
        }
        if (node instanceof AnnotatedNode) {
            return ((AnnotatedNode)node).getDeclaringClass().getModule();
        }
        return null;
    }

    private static void addErrorMessage(SimpleMessage message, List collector) {
        GroovyCompilerWrapper.addMessageWithoutLocation(collector, message.getMessage(), true);
    }

    public static class OutputItemImpl
    implements OutputItem {
        private final String myOutputPath;
        private final String myOutputDir;
        private final String mySourceFileName;

        public OutputItemImpl(String outputDir, String outputPath, String sourceFileName) {
            this.myOutputDir = outputDir;
            this.myOutputPath = outputPath;
            this.mySourceFileName = sourceFileName;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public String getOutputRootDirectory() {
            return this.myOutputDir;
        }

        public String getSourceFile() {
            return this.mySourceFileName;
        }
    }

    public static interface OutputItem {
        public String getOutputPath();

        public String getSourceFile();

        public String getOutputRootDirectory();
    }
}

