/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntRefIdReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class AntPattern
extends AntElementVisitor {
    private static final List<Pattern> ourDefaultExcludes = new ArrayList<Pattern>(AntPattern.getDefaultExcludes(true));
    private static final List<Pattern> ourCaseInsensitiveDefaultExcludes = new ArrayList<Pattern>(AntPattern.getDefaultExcludes(false));
    private final boolean myCaseSensitive;
    private static final String ourSeparatorPattern = Pattern.quote("/");
    private final List<Pattern> myIncludePatterns = new ArrayList<Pattern>();
    private final List<Pattern> myExcludePatterns = new ArrayList<Pattern>();
    private final List<PrefixItem[]> myCouldBeIncludedPatterns = new ArrayList<PrefixItem[]>();

    private static List<Pattern> getDefaultExcludes(boolean caseSensitive) {
        return Arrays.asList(AntPattern.convertToRegexPattern("**/*~", caseSensitive), AntPattern.convertToRegexPattern("**/#*#", caseSensitive), AntPattern.convertToRegexPattern("**/.#*", caseSensitive), AntPattern.convertToRegexPattern("**/%*%", caseSensitive), AntPattern.convertToRegexPattern("**/._*", caseSensitive), AntPattern.convertToRegexPattern("**/CVS", caseSensitive), AntPattern.convertToRegexPattern("**/CVS/**", caseSensitive), AntPattern.convertToRegexPattern("**/.cvsignore", caseSensitive), AntPattern.convertToRegexPattern("**/SCCS", caseSensitive), AntPattern.convertToRegexPattern("**/SCCS/**", caseSensitive), AntPattern.convertToRegexPattern("**/vssver.scc", caseSensitive), AntPattern.convertToRegexPattern("**/.svn", caseSensitive), AntPattern.convertToRegexPattern("**/.svn/**", caseSensitive), AntPattern.convertToRegexPattern("**/_svn", caseSensitive), AntPattern.convertToRegexPattern("**/_svn/**", caseSensitive), AntPattern.convertToRegexPattern("**/.DS_Store", caseSensitive));
    }

    AntPattern(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
    }

    public boolean hasIncludePatterns() {
        return this.myIncludePatterns.size() > 0;
    }

    @Override
    public void visitAntStructuredElement(AntStructuredElement element) {
        AntTypeDefinition typeDef = element.getTypeDefinition();
        if (typeDef != null) {
            PsiReference[] refs;
            String value;
            AntTypeId antTypeId = typeDef.getTypeId();
            if ("include".equals(antTypeId.getName())) {
                if (AntPattern.isEnabled(element) && (value = element.computeAttributeValue(element.getSourceElement().getAttributeValue("name"))) != null) {
                    this.addIncludePattern(value);
                }
            } else if ("exclude".equals(antTypeId.getName())) {
                if (AntPattern.isEnabled(element) && (value = element.computeAttributeValue(element.getSourceElement().getAttributeValue("name"))) != null) {
                    this.addExcludePattern(value);
                }
            } else {
                String excludeAttribs;
                String includeAttribs = element.computeAttributeValue(element.getSourceElement().getAttributeValue("includes"));
                if (includeAttribs != null) {
                    this.addPatterns(true, includeAttribs);
                }
                if ((excludeAttribs = element.computeAttributeValue(element.getSourceElement().getAttributeValue("excludes"))) != null) {
                    this.addPatterns(false, excludeAttribs);
                }
            }
            for (PsiReference ref : refs = element.getReferences()) {
                PsiElement psiElement;
                if (!(ref instanceof AntRefIdReference) || !((psiElement = ref.resolve()) instanceof AntStructuredElement)) continue;
                ((AntStructuredElement)psiElement).acceptAntElementVisitor(this);
            }
        }
        super.visitAntStructuredElement(element);
    }

    public final void addExcludePattern(String antPattern) {
        this.myExcludePatterns.add(AntPattern.convertToRegexPattern(antPattern, this.myCaseSensitive));
    }

    public final void addIncludePattern(String antPattern) {
        String normalizedPattern;
        this.myIncludePatterns.add(AntPattern.convertToRegexPattern(antPattern, this.myCaseSensitive));
        String string = normalizedPattern = antPattern.endsWith("/") || antPattern.endsWith(File.separator) ? antPattern.replace(File.separatorChar, '/') + "**" : antPattern.replace(File.separatorChar, '/');
        if (normalizedPattern.startsWith("/") && normalizedPattern.length() > 1) {
            normalizedPattern = normalizedPattern.substring(1, normalizedPattern.length());
        }
        if (!normalizedPattern.startsWith("/")) {
            String[] patDirs = normalizedPattern.split(ourSeparatorPattern);
            PrefixItem[] items = new PrefixItem[patDirs.length];
            for (int i = 0; i < patDirs.length; ++i) {
                items[i] = new PrefixItem(patDirs[i]);
            }
            this.myCouldBeIncludedPatterns.add(items);
        }
    }

    public boolean acceptPath(String relativePath) {
        String path = relativePath.replace('\\', '/');
        boolean accepted = this.myIncludePatterns.size() == 0;
        for (Pattern includePattern : this.myIncludePatterns) {
            if (!includePattern.matcher(path).matches()) continue;
            accepted = true;
            break;
        }
        if (accepted) {
            for (Pattern excludePattern : this.myExcludePatterns) {
                if (!excludePattern.matcher(path).matches()) continue;
                accepted = false;
                break;
            }
        }
        return accepted;
    }

    private static boolean isEnabled(AntStructuredElement element) {
        XmlTag srcElem = element.getSourceElement();
        AntFile antFile = element.getAntFile();
        String ifProperty = srcElem.getAttributeValue("if");
        if (ifProperty != null && antFile.getProperty(ifProperty) == null) {
            return false;
        }
        String unlessProperty = srcElem.getAttributeValue("unless");
        return unlessProperty == null || antFile.getProperty(unlessProperty) == null;
    }

    private void addPatterns(boolean addToIncludes, String patternString) {
        StringTokenizer tokenizer = new StringTokenizer(patternString, ", \t", false);
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (pattern.length() <= 0) continue;
            if (addToIncludes) {
                this.addIncludePattern(pattern);
                continue;
            }
            this.addExcludePattern(pattern);
        }
    }

    private static Pattern convertToRegexPattern(@NonNls String antPattern, boolean caseSensitive) {
        return Pattern.compile(FileUtil.convertAntToRegexp((String)antPattern), caseSensitive ? 0 : 2);
    }

    public static AntPattern create(AntStructuredElement element, boolean honorDefaultExcludes, boolean caseSensitive) {
        AntPattern antPattern = new AntPattern(caseSensitive);
        element.acceptAntElementVisitor(antPattern);
        if (honorDefaultExcludes) {
            antPattern.myExcludePatterns.addAll(caseSensitive ? ourDefaultExcludes : ourCaseInsensitiveDefaultExcludes);
        }
        return antPattern;
    }

    protected static boolean matchPatternStart(PrefixItem[] patDirs, String str) {
        PrefixItem item;
        int strIdxStart;
        String[] strDirs = str.split(ourSeparatorPattern);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !"**".equals((item = patDirs[patIdxStart]).getStrPattern()); ++patIdxStart, ++strIdxStart) {
            if (item.getPattern().matcher(strDirs[strIdxStart]).matches()) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public boolean couldBeIncluded(String relativePath) {
        if (this.myIncludePatterns.size() == 0) {
            return true;
        }
        for (PrefixItem[] couldBeIncludedPattern : this.myCouldBeIncludedPatterns) {
            if (!AntPattern.matchPatternStart(couldBeIncludedPattern, relativePath)) continue;
            return true;
        }
        return false;
    }

    private class PrefixItem {
        private final String myStrPattern;
        private Pattern myCompiledPattern;

        public PrefixItem(String strPattern) {
            this.myStrPattern = strPattern;
        }

        public String getStrPattern() {
            return this.myStrPattern;
        }

        public Pattern getPattern() {
            if (this.myCompiledPattern == null) {
                this.myCompiledPattern = Pattern.compile(FileUtil.convertAntToRegexp((String)this.myStrPattern), AntPattern.this.myCaseSensitive ? 0 : 2);
            }
            return this.myCompiledPattern;
        }
    }
}

