/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.extapi.psi.LightPsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.misc.AntStringInterner;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.impl.AntIntrospector;
import com.intellij.lang.ant.psi.impl.AntOuterProjectElement;
import com.intellij.lang.ant.psi.impl.AntProjectImpl;
import com.intellij.lang.ant.psi.impl.AntPropertyImpl;
import com.intellij.lang.ant.psi.impl.PropertiesBuilder;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.DataType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntFileImpl
extends LightPsiFileBase
implements AntFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.psi.impl.AntFileImpl");
    @NonNls
    public static final String PROJECT_TAG = "project";
    @NonNls
    public static final String TARGET_TAG = "target";
    @NonNls
    public static final String IMPORT_TAG = "import";
    @NonNls
    public static final String FORMAT_TAG = "format";
    @NonNls
    public static final String JAVADOC2_TAG = "javadoc2";
    @NonNls
    public static final String JAVADOC_TAG = "javadoc";
    @NonNls
    public static final String UNWAR_TAG = "unwar";
    @NonNls
    public static final String UNJAR_TAG = "unjar";
    @NonNls
    public static final String PROPERTY = "property";
    @NonNls
    public static final String UNZIP_TAG = "unzip";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String ID_ATTR = "id";
    @NonNls
    public static final String DEPENDS_ATTR = "depends";
    @NonNls
    public static final String IF_ATTR = "if";
    @NonNls
    public static final String UNLESS_ATTR = "unless";
    @NonNls
    public static final String DESCRIPTION_ATTR = "description";
    @NonNls
    public static final String DEFAULT_ATTR = "default";
    @NonNls
    public static final String BASEDIR_ATTR = "basedir";
    @NonNls
    public static final String FILE_ATTR = "file";
    @NonNls
    public static final String PREFIX_ATTR = "prefix";
    @NonNls
    public static final String DEFAULT_ENVIRONMENT_PREFIX = "env.";
    private AntProject myProject;
    private AntElement myPrologElement;
    private AntElement myEpilogueElement;
    private PsiElement[] myChildren;
    private ClassLoader myClassLoader;
    private Hashtable myProjectProperties;
    private boolean myNeedPropertiesRebuild = false;
    private Map<String, List<AntProperty>> myProperties;
    private volatile AntProperty[] myPropertiesArray;
    private volatile PropertiesWatcher myDependentFilesWatcher;
    private List<String> myEnvPrefixes;
    private volatile Map<String, String> myExternalProperties;
    private volatile Map<String, AntTypeDefinition> myTypeDefinitions;
    private volatile AntTypeDefinition[] myTypeDefinitionArray;
    private volatile AntTypeDefinition myTargetDefinition;
    private volatile HashMap<AntTypeId, String> myProjectElements;
    private long myModificationCount = 0L;
    public static final Key ANT_BUILD_FILE = Key.create((String)"ANT_BUILD_FILE");

    public AntFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)AntSupport.getLanguage());
        AntConfiguration.initAntSupport(this.getProject());
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntFileImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntFile(this);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getVirtualFile().getFileType();
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getFileType must not return null");
        }
        return fileType;
    }

    public PsiElement getOriginalElement() {
        return this.getSourceElement().getOriginalElement();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getSourceElement().getOriginalFile().getVirtualFile();
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.NULL_ROLE;
    }

    @Override
    public boolean canRename() {
        return this.isPhysical();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearExternalProperties() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myExternalProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExternalProperty(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntFileImpl.setExternalProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntFileImpl.setExternalProperty must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myExternalProperties == null) {
                this.myExternalProperties = new HashMap<String, String>();
            }
            this.myExternalProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public PsiElement[] getChildren() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        this.buildPropertiesIfNeeded();
        if (this.myChildren == null) {
            AntProject project = this.getAntProject();
            ArrayList<AntElement> children = new ArrayList<AntElement>(3);
            if (this.myPrologElement != null) {
                children.add(this.myPrologElement);
            }
            children.add(project);
            if (this.myEpilogueElement != null) {
                children.add(this.myEpilogueElement);
            }
            this.myChildren = children.toArray(new PsiElement[children.size()]);
        }
        // MONITOREXIT : object
        if (this.myChildren != null) return this.myChildren;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getChildren must not return null");
    }

    public PsiElement getFirstChild() {
        return this.getChildren()[0];
    }

    public PsiElement getLastChild() {
        PsiElement[] psiElements = this.getChildren();
        return psiElements[psiElements.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntFileImpl copyLight(FileViewProvider viewProvider) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            HashMap<String, AntTypeDefinition> defs;
            AntFileImpl copy = new AntFileImpl(viewProvider);
            if (this.myTypeDefinitions != null) {
                defs = new HashMap<String, AntTypeDefinition>();
                for (Map.Entry<String, AntTypeDefinition> entry : this.myTypeDefinitions.entrySet()) {
                    AntTypeDefinitionImpl original = (AntTypeDefinitionImpl)entry.getValue();
                    if (original == null) continue;
                    defs.put(entry.getKey(), new AntTypeDefinitionImpl(original));
                }
            } else {
                defs = null;
            }
            copy.myTypeDefinitions = defs;
            copy.myProjectElements = this.myProjectElements == null ? null : new HashMap<AntTypeId, String>(this.myProjectElements);
            copy.myClassLoader = this.myClassLoader;
            HashMap<String, String> hashMap = copy.myExternalProperties = this.myExternalProperties != null ? new HashMap<String, String>(this.myExternalProperties) : null;
            if (this.myProperties != null) {
                HashMap<String, List<AntProperty>> map = new HashMap<String, List<AntProperty>>();
                for (Map.Entry<String, List<AntProperty>> entry : this.myProperties.entrySet()) {
                    map.put(entry.getKey(), new ArrayList(entry.getValue()));
                }
                copy.myProperties = map;
            } else {
                copy.myProperties = null;
            }
            return copy;
        }
    }

    public String toString() {
        return "AntFile[" + this.getName() + "]";
    }

    @Override
    @Nullable
    public VirtualFile getContainingPath() {
        VirtualFile result = this.getVirtualFile();
        return result == null ? null : result.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCachesWithTypeDefinitions() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myTypeDefinitions = null;
            this.myTypeDefinitionArray = null;
            this.myTargetDefinition = null;
            this.myProjectElements = null;
            this.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myChildren != null || this.myPrologElement != null || this.myProject != null || this.myEpilogueElement != null || this.myTargetDefinition != null || this.myClassLoader != null || this.myEnvPrefixes != null) {
                this.myChildren = null;
                this.myPrologElement = null;
                this.myProject = null;
                this.myEpilogueElement = null;
                this.myTargetDefinition = null;
                this.myClassLoader = null;
                this.myEnvPrefixes = null;
                this.incModificationCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateProperties() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myProperties = null;
            this.myPropertiesArray = null;
            this.myNeedPropertiesRebuild = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incModificationCount() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            ++this.myModificationCount;
            for (AntFile file : AntSupport.getImportingFiles(this)) {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationCount() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return this.myModificationCount;
        }
    }

    public void subtreeChanged() {
        this.clearCaches();
    }

    @Override
    @NotNull
    public XmlFile getSourceElement() {
        XmlFile xmlFile = (XmlFile)this.getViewProvider().getPsi(StdLanguages.XML);
        if (xmlFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getSourceElement must not return null");
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public ClassLoader getClassLoader() {
        if (this.myClassLoader == null) {
            AntBuildFileImpl buildFile = (AntBuildFileImpl)this.getSourceElement().getCopyableUserData(ANT_BUILD_FILE);
            if (buildFile != null) {
                this.myClassLoader = buildFile.getClassLoader();
            } else {
                AntConfigurationBase configuration = AntConfigurationBase.getInstance(this.getProject());
                AntInstallation antInstallation = null;
                if (configuration != null) {
                    antInstallation = configuration.getProjectDefaultAnt();
                }
                if (antInstallation == null) {
                    antInstallation = GlobalAntConfiguration.getInstance().getBundledAnt();
                }
                assert (antInstallation != null);
                this.myClassLoader = antInstallation.getClassLoader();
            }
        }
        ClassLoader classLoader = this.myClassLoader;
        if (classLoader == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getClassLoader must not return null");
        }
        return classLoader;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public AntInstallation getAntInstallation() {
        AntInstallation projectDefaultInstallation;
        AntInstallation antInstallation;
        AntInstallation assignedInstallation;
        AntBuildFileImpl buildFile = (AntBuildFileImpl)this.getSourceElement().getCopyableUserData(ANT_BUILD_FILE);
        if (buildFile != null && (assignedInstallation = (AntInstallation)AntBuildFileImpl.ANT_INSTALLATION.get(buildFile.getAllOptions())) != null) {
            antInstallation = assignedInstallation;
            if (antInstallation == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getAntInstallation must not return null");
            return antInstallation;
        }
        AntConfigurationBase configuration = AntConfigurationBase.getInstance(this.getProject());
        if (configuration != null && (projectDefaultInstallation = configuration.getProjectDefaultAnt()) != null) {
            antInstallation = projectDefaultInstallation;
            if (antInstallation == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getAntInstallation must not return null");
            return antInstallation;
        }
        antInstallation = GlobalAntConfiguration.getInstance().getBundledAnt();
        if (antInstallation != null) return antInstallation;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getAntInstallation must not return null");
    }

    @Nullable
    public Sdk getTargetJdk() {
        AntBuildFileImpl buildFile = (AntBuildFileImpl)this.getSourceElement().getCopyableUserData(ANT_BUILD_FILE);
        if (buildFile == null) {
            return ProjectRootManager.getInstance((com.intellij.openapi.project.Project)this.getProject()).getProjectJdk();
        }
        String jdkName = (String)AntBuildFileImpl.CUSTOM_JDK_NAME.get(buildFile.getAllOptions());
        if (jdkName == null || jdkName.length() == 0) {
            jdkName = (String)AntConfigurationImpl.DEFAULT_JDK_NAME.get(buildFile.getAllOptions());
        }
        if (jdkName != null && jdkName.length() > 0) {
            return ProjectJdkTable.getInstance().findJdk(jdkName);
        }
        return ProjectRootManager.getInstance((com.intellij.openapi.project.Project)this.getProject()).getProjectJdk();
    }

    @Override
    @Nullable
    public AntElement getAntParent() {
        return null;
    }

    @Override
    public AntFile getAntFile() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public AntProject getAntProject() {
        boolean updateBuilFile = false;
        try {
            Object object = PsiLock.LOCK;
            synchronized (object) {
                if (this.myProject == null) {
                    int projectEnd;
                    XmlFile baseFile = this.getSourceElement();
                    XmlDocument document = baseFile.getDocument();
                    assert (document != null);
                    XmlTag tag = document.getRootTag();
                    if (tag == null) {
                        AntProject antProject = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 13, 15] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (updateBuilFile) {
                            // empty if block
                        }
                        return antProject;
                    }
                    CharSequence fileText = baseFile.getViewProvider().getContents();
                    TextRange tagRange = tag.getTextRange();
                    int projectStart = tagRange.getStartOffset();
                    if (projectStart > 0) {
                        this.myPrologElement = new AntOuterProjectElement(this, 0, ((Object)fileText.subSequence(0, projectStart)).toString());
                    }
                    if ((projectEnd = tagRange.getEndOffset()) < fileText.length()) {
                        this.myEpilogueElement = new AntOuterProjectElement(this, projectEnd, ((Object)fileText.subSequence(projectEnd, fileText.length())).toString());
                    }
                    AntProjectImpl project = new AntProjectImpl(this, tag, this.createProjectDefinition());
                    this.myProject = project;
                    if (this.getSourceElement().isPhysical() || this.myProperties == null) {
                        this.buildPropertiesMap();
                    }
                    for (AntFile imported : project.getImportedFiles()) {
                        if (!imported.isPhysical()) continue;
                        AntSupport.registerDependency(this, imported);
                    }
                    updateBuilFile = true;
                }
                AntProject antProject = this.myProject;
                return antProject;
            }
        }
        finally {
            if (updateBuilFile) {
                // empty if block
            }
        }
    }

    @Override
    @Nullable
    public AntProperty getProperty(String name) {
        return this.getPropertyRecursively(name, new HashSet<AntFile>());
    }

    @Override
    public void processAllProperties(@NonNls String name, Processor<AntProperty> processor) {
        this.processAllPropertiesRecursively(name, new HashSet<AntFile>(), processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AntProperty getPropertyRecursively(String name, Set<AntFile> processed) {
        if (name == null || processed.contains(this)) {
            return null;
        }
        processed.add(this);
        try {
            AntProject antProject;
            AntProperty antProperty;
            Object object = PsiLock.LOCK;
            synchronized (object) {
                List<AntProperty> antProperties;
                antProperty = this.myProperties != null ? ((antProperties = this.myProperties.get(name)) != null && !antProperties.isEmpty() ? antProperties.get(0) : null) : null;
            }
            if (antProperty == null && (antProject = this.getAntProject()) != null) {
                for (AntFile imported : antProject.getImportedFiles()) {
                    AntProperty antProperty2 = antProperty = imported instanceof AntFileImpl ? ((AntFileImpl)imported).getPropertyRecursively(name, processed) : imported.getProperty(name);
                    if (antProperty != null) break;
                }
            }
            object = antProperty;
            return object;
        }
        finally {
            processed.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAllPropertiesRecursively(String name, Set<AntFile> processed, Processor<AntProperty> processor) {
        if (name == null) return;
        if (processed.contains(this)) {
            return;
        }
        processed.add(this);
        try {
            Object object = PsiLock.LOCK;
            synchronized (object) {
                List<AntProperty> antProperties;
                if (this.myProperties != null && (antProperties = this.myProperties.get(name)) != null) {
                    for (AntProperty property : antProperties) {
                        if (processor.process((Object)property)) continue;
                        return;
                    }
                }
            }
            AntProject antProject = this.getAntProject();
            if (antProject == null) return;
            AntFile[] arr$ = antProject.getImportedFiles();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                AntFile imported = arr$[i$];
                if (imported instanceof AntFileImpl) {
                    ((AntFileImpl)imported).processAllPropertiesRecursively(name, processed, processor);
                } else {
                    imported.processAllProperties(name, processor);
                }
                ++i$;
            }
            return;
        }
        finally {
            processed.remove(this);
        }
    }

    public void buildPropertiesIfNeeded() {
        if (this.myNeedPropertiesRebuild || this.myDependentFilesWatcher != null && this.myDependentFilesWatcher.needRebuildProperties()) {
            this.buildPropertiesMap();
        }
    }

    private void buildPropertiesMap() {
        this.myNeedPropertiesRebuild = false;
        this.myDependentFilesWatcher = null;
        this.myProperties = new HashMap<String, List<AntProperty>>();
        this.myPropertiesArray = null;
        this.loadPredefinedProperties(this.myProjectProperties, this.myExternalProperties);
        List<PsiFile> dependentFiles = PropertiesBuilder.defineProperties(this);
        this.myDependentFilesWatcher = new PropertiesWatcher(dependentFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPredefinedProperties(Hashtable properties, Map<String, String> externalProps) {
        Enumeration props = properties != null ? properties.keys() : new Hashtable().keys();
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append("<project name=\"predefined properties\">");
        try {
            VirtualFile dir;
            String value;
            while (props.hasMoreElements()) {
                String name = (String)props.nextElement();
                String value2 = (String)properties.get(name);
                builder.append("<property name=\"");
                builder.append(name);
                builder.append("\" value=\"");
                builder.append(value2);
                builder.append("\"/>");
            }
            Map<String, String> envMap = System.getenv();
            for (String name : envMap.keySet()) {
                value = envMap.get(name);
                if (name.length() <= 0) continue;
                builder.append("<property name=\"");
                builder.append(DEFAULT_ENVIRONMENT_PREFIX);
                builder.append(name);
                builder.append("\" value=\"");
                builder.append(value);
                builder.append("\"/>");
            }
            if (externalProps != null) {
                for (String name : externalProps.keySet()) {
                    value = externalProps.get(name);
                    builder.append("<property name=\"");
                    builder.append(name);
                    builder.append("\" value=\"");
                    builder.append(value);
                    builder.append("\"/>");
                }
            }
            VirtualFile file = this.getVirtualFile();
            final AntProject antProject = this.getAntProject();
            String basedir = antProject.getBaseDir();
            if (basedir == null) {
                basedir = ".";
            }
            if (file != null && !FileUtil.isAbsolute((String)basedir) && (dir = file.getParent()) != null) {
                try {
                    basedir = new File(dir.getPath(), basedir).getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (basedir != null) {
                builder.append("<property name=\"basedir\" value=\"");
                builder.append(basedir);
                builder.append("\"/>");
            }
            AntInstallation installation = this.getAntInstallation();
            builder.append("<property name=\"ant.home\" value=\"");
            String homeDir = installation.getHomeDir();
            if (homeDir != null) {
                builder.append(homeDir.replace(File.separatorChar, '/'));
            }
            builder.append("\"/>");
            builder.append("<property name=\"ant.version\" value=\"");
            builder.append(installation.getVersion());
            builder.append("\"/>");
            builder.append("<property name=\"ant.project.name\" value=\"");
            String name = antProject.getName();
            builder.append(name == null ? "" : name);
            builder.append("\"/>");
            builder.append("<property name=\"ant.java.version\" value=\"");
            Sdk jdkToRunWith = this.getTargetJdk();
            String version = jdkToRunWith != null ? jdkToRunWith.getVersionString() : null;
            builder.append(version != null ? version : SystemInfo.JAVA_VERSION);
            builder.append("\"/>");
            if (file != null) {
                String path = file.getPath();
                builder.append("<property name=\"ant.file\" value=\"");
                builder.append(path);
                builder.append("\"/>");
                if (name != null) {
                    builder.append("<property name=\"ant.file.");
                    builder.append(name);
                    builder.append("\" value=\"");
                    builder.append(path);
                    builder.append("\"/>");
                }
            }
            builder.append("</project>");
            XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((com.intellij.openapi.project.Project)this.getProject()).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)builder, LocalTimeCounter.currentTime(), false, false);
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return;
            }
            AntTypeDefinition propertyDef = this.getAntFile().getBaseTypeDefinition(Property.class.getName());
            AntProjectImpl fakeProject = new AntProjectImpl(this, rootTag, antProject.getTypeDefinition());
            for (XmlTag tag : rootTag.getSubTags()) {
                AntPropertyImpl property = new AntPropertyImpl(fakeProject, tag, propertyDef){

                    public PsiFile getContainingFile() {
                        return this.getSourceElement().getContainingFile();
                    }

                    public PsiElement getNavigationElement() {
                        XmlAttribute attr;
                        if (AntFileImpl.BASEDIR_ATTR.equals(this.getName()) && (attr = antProject.getSourceElement().getAttribute(AntFileImpl.BASEDIR_ATTR, null)) != null) {
                            return attr;
                        }
                        return super.getNavigationElement();
                    }
                };
                this.appendProperty(property.getName(), property);
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, AntProperty element) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myNeedPropertiesRebuild) {
                this.buildPropertiesMap();
            }
            this.appendProperty(name, element);
        }
    }

    private void appendProperty(String name, AntProperty element) {
        List<AntProperty> props;
        if (this.myProperties == null) {
            this.myProperties = new HashMap<String, List<AntProperty>>();
        }
        if ((props = this.myProperties.get(name)) == null) {
            props = new ArrayList<AntProperty>();
            this.myProperties.put(name, props);
        }
        props.add(element);
        this.myPropertiesArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public AntProperty[] getProperties() {
        AntProperty[] antPropertyArray;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myNeedPropertiesRebuild) {
                this.buildPropertiesMap();
            }
            if (this.myProperties == null) {
                // MONITOREXIT @DISABLED, blocks:[2, 10] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                antPropertyArray = AntProperty.EMPTY_ARRAY;
                if (AntProperty.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getProperties must not return null");
                return antPropertyArray;
            }
            if (this.myPropertiesArray == null) {
                ArrayList<AntProperty> props = new ArrayList<AntProperty>(this.myProperties.size());
                for (List<AntProperty> list : this.myProperties.values()) {
                    if (list.isEmpty()) continue;
                    props.add(list.get(0));
                }
                this.myPropertiesArray = props.toArray(new AntProperty[props.size()]);
            }
        }
        antPropertyArray = this.myPropertiesArray;
        if (this.myPropertiesArray != null) return antPropertyArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getProperties must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEnvironmentPropertyPrefix(@NotNull String envPrefix) {
        if (envPrefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntFileImpl.addEnvironmentPropertyPrefix must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            String env;
            this.checkEnvList();
            String string = env = envPrefix.endsWith(".") ? envPrefix : envPrefix + '.';
            if (this.myEnvPrefixes.indexOf(env) < 0) {
                this.myEnvPrefixes.add(env);
                for (AntProperty element : this.getProperties()) {
                    String name = element.getName();
                    if (name == null || !name.startsWith(DEFAULT_ENVIRONMENT_PREFIX)) continue;
                    this.setProperty(env + name.substring(DEFAULT_ENVIRONMENT_PREFIX.length()), element);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnvironmentProperty(@NotNull String propName) {
        if (propName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntFileImpl.isEnvironmentProperty must not be null");
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.checkEnvList();
            if (!propName.endsWith(".")) {
                for (String prefix : this.myEnvPrefixes) {
                    if (!propName.startsWith(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEnvironmentPrefixes() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.checkEnvList();
            return this.myEnvPrefixes;
        }
    }

    private void checkEnvList() {
        if (this.myEnvPrefixes == null) {
            this.myEnvPrefixes = new ArrayList<String>();
            this.myEnvPrefixes.add(DEFAULT_ENVIRONMENT_PREFIX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntElement lightFindElementAt(int offset) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myProject == null) {
                return this;
            }
            TextRange projectRange = this.myProject.getTextRange();
            if (offset < projectRange.getStartOffset() || offset >= projectRange.getEndOffset()) {
                return this;
            }
            AntElement prolog = this.myPrologElement;
            int n = prolog == null ? 0 : prolog.getTextLength();
            return this.myProject.lightFindElementAt(offset - n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AntTypeDefinition[] getBaseTypeDefinitions() {
        Object object = PsiLock.LOCK;
        // MONITORENTER : object
        if (this.myTypeDefinitionArray == null || this.myTypeDefinitions == null || this.myTypeDefinitionArray.length != this.myTypeDefinitions.size()) {
            this.buildTypeDefinitions();
            this.myTypeDefinitionArray = this.myTypeDefinitions.values().toArray(new AntTypeDefinition[this.myTypeDefinitions.size()]);
        }
        // MONITOREXIT : object
        if (this.myTypeDefinitionArray != null) return this.myTypeDefinitionArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileImpl.getBaseTypeDefinitions must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntTypeDefinition getBaseTypeDefinition(String className) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.buildTypeDefinitions();
            return this.lookupTypeDefinition(className);
        }
    }

    private void buildTypeDefinitions() {
        if (this.myTypeDefinitions == null) {
            this.myTypeDefinitions = new HashMap<String, AntTypeDefinition>();
            this.myProjectElements = new HashMap();
            ReflectedProject reflectedProject = ReflectedProject.getProject(this.getClassLoader());
            if (reflectedProject.myProject != null) {
                this.updateTypeDefinitions(reflectedProject.myTaskDefinitions, true);
                this.updateTypeDefinitions(reflectedProject.myDataTypeDefinitions, false);
                this.myProjectProperties = reflectedProject.myProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntTypeDefinition getTargetDefinition() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Class targetClass;
            AntTypeDefinition targetDef;
            this.buildTypeDefinitions();
            if (this.myTargetDefinition == null && (targetDef = AntFileImpl.createTypeDefinition(new AntTypeId(TARGET_TAG), targetClass = ReflectedProject.getProject(this.getClassLoader()).myTargetClass, false)) != null) {
                for (AntTypeDefinition def : this.getBaseTypeDefinitions()) {
                    AntTypeId id = def.getTypeId();
                    if (!this.canBeUsedInTarget(def)) continue;
                    targetDef.registerNestedType(id, def.getClassName());
                }
                this.myTargetDefinition = targetDef;
                this.registerCustomType(targetDef);
            }
            return this.myTargetDefinition;
        }
    }

    private boolean canBeUsedInTarget(AntTypeDefinition def) {
        return (def.isTask() || this.isDataDype(def)) && this.isProjectNestedElement(def);
    }

    private boolean isDataDype(AntTypeDefinition def) {
        try {
            ClassLoader loader = this.getClassLoader();
            String className = def.getClassName();
            if (className.startsWith("AntMacroDef") || className.startsWith("AntPresetDef")) {
                return false;
            }
            Class<?> defClass = loader.loadClass(className);
            Class<?> dataTypeClass = loader.loadClass(DataType.class.getName());
            return dataTypeClass.isAssignableFrom(defClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isProjectNestedElement(AntTypeDefinition def) {
        AntTypeDefinition projectDef;
        AntTypeId id = def.getTypeId();
        if (this.myProject != null && (projectDef = this.myProject.getTypeDefinition()) != null) {
            return def.getClassName().equals(projectDef.getNestedClassName(id));
        }
        return def.getClassName().equals(this.myProjectElements.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCustomType(AntTypeDefinition def) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.buildTypeDefinitions();
            this.addTypeDefinition(def);
            if (this.myTargetDefinition != null && this.myTargetDefinition != def && this.canBeUsedInTarget(def)) {
                this.myTargetDefinition.registerNestedType(def.getTypeId(), def.getClassName());
            }
        }
    }

    private AntTypeDefinition lookupTypeDefinition(String className) {
        return this.myTypeDefinitions.get(className);
    }

    private void addTypeDefinition(AntTypeDefinition def) {
        this.myTypeDefinitions.put(def.getClassName(), def);
        this.myTypeDefinitionArray = null;
    }

    private void removeTypeDefinition(AntTypeDefinition def) {
        AntTypeDefinition definition = this.myTypeDefinitions.remove(def.getClassName());
        if (definition != null) {
            definition.setOutdated(true);
        }
        this.myTypeDefinitionArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterCustomType(AntTypeDefinition def) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            String registeredClassName;
            if (this.myTypeDefinitions != null) {
                this.removeTypeDefinition(def);
            }
            if (this.myProjectElements != null && (registeredClassName = this.myProjectElements.get(def.getTypeId())) != null && registeredClassName.equals(def.getClassName())) {
                this.myProjectElements.remove(def.getTypeId());
            }
            if (this.myTargetDefinition != null && this.myTargetDefinition != def) {
                this.myTargetDefinition.unregisterNestedType(def.getTypeId());
            }
        }
    }

    private void updateTypeDefinitions(Hashtable ht, boolean isTask) {
        if (ht == null) {
            return;
        }
        Enumeration types = ht.keys();
        while (types.hasMoreElements()) {
            Class typeClass;
            AntTypeId typeId;
            AntTypeDefinition def;
            String typeName = (String)types.nextElement();
            if (isTask && typeName.equals(JAVADOC2_TAG)) {
                typeName = JAVADOC_TAG;
            }
            if (isTask && (typeName.equals(UNWAR_TAG) || typeName.equals(UNJAR_TAG))) {
                typeName = UNZIP_TAG;
            }
            if ((def = AntFileImpl.createTypeDefinition(typeId = new AntTypeId(typeName), typeClass = (Class)ht.get(typeName), isTask)) == null) continue;
            String className = def.getClassName();
            this.addTypeDefinition(def);
            this.myProjectElements.put(typeId, className);
            this.registerNestedDefinitionsRecursively(typeClass);
        }
    }

    private void registerNestedDefinitionsRecursively(Class parentClass) {
        AntIntrospector helper = AntFileImpl.getHelperExceptionSafe(parentClass);
        if (helper != null) {
            Enumeration nestedEnum = helper.getNestedElements();
            while (nestedEnum.hasMoreElements()) {
                AntTypeDefinition nestedDef;
                String nestedElement = (String)nestedEnum.nextElement();
                Class nestedElementClass = helper.getElementType(nestedElement);
                if (nestedElementClass == null || this.lookupTypeDefinition(nestedElementClass.getName()) != null || (nestedDef = AntFileImpl.createTypeDefinition(new AntTypeId(nestedElement), nestedElementClass, false)) == null) continue;
                this.addTypeDefinition(nestedDef);
                this.registerNestedDefinitionsRecursively(nestedElementClass);
            }
        }
    }

    private AntTypeDefinition createProjectDefinition() {
        this.buildTypeDefinitions();
        HashMap<String, AntAttributeType> projectAttrs = new HashMap<String, AntAttributeType>();
        projectAttrs.put(NAME_ATTR, AntAttributeType.STRING);
        projectAttrs.put(DEFAULT_ATTR, AntAttributeType.STRING);
        projectAttrs.put(BASEDIR_ATTR, AntAttributeType.STRING);
        AntTypeDefinition def = this.getTargetDefinition();
        if (def != null) {
            this.myProjectElements.put(def.getTypeId(), def.getClassName());
        }
        return new AntTypeDefinitionImpl(new AntTypeId(PROJECT_TAG), Project.class.getName(), false, false, projectAttrs, this.myProjectElements);
    }

    @Nullable
    static AntTypeDefinition createTypeDefinition(AntTypeId id, Class typeClass, boolean isTask) {
        AntIntrospector helper = AntFileImpl.getHelperExceptionSafe(typeClass);
        if (helper == null) {
            return null;
        }
        HashMap<String, AntAttributeType> attributes = new HashMap<String, AntAttributeType>();
        Enumeration attrEnum = helper.getAttributes();
        while (attrEnum.hasMoreElements()) {
            String attr = AntStringInterner.intern(((String)attrEnum.nextElement()).toLowerCase(Locale.US));
            attributes.put(attr, AntAttributeType.create(helper.getAttributeType(attr)));
        }
        HashMap<AntTypeId, String> nestedDefinitions = new HashMap<AntTypeId, String>();
        Enumeration nestedEnum = helper.getNestedElements();
        while (nestedEnum.hasMoreElements()) {
            String nestedElement = (String)nestedEnum.nextElement();
            Class elementType = helper.getElementType(nestedElement);
            if (elementType == null) continue;
            String className = AntStringInterner.intern(elementType.getName());
            nestedDefinitions.put(new AntTypeId(nestedElement), className);
        }
        boolean isAllTasksContainer = false;
        ClassLoader loader = typeClass.getClassLoader();
        try {
            Class<TaskContainer> containerClass = loader != null ? loader.loadClass(TaskContainer.class.getName()) : TaskContainer.class;
            isAllTasksContainer = containerClass.isAssignableFrom(typeClass);
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        return new AntTypeDefinitionImpl(id, typeClass.getName(), isTask, isAllTasksContainer, attributes, nestedDefinitions, helper.getExtensionPointTypes(), null);
    }

    @Nullable
    private static AntIntrospector getHelperExceptionSafe(Class c) {
        try {
            return AntIntrospector.getInstance(c);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Icon getElementIcon(int flags) {
        return this.getRole().getIcon();
    }

    private static class PropertiesWatcher {
        private final List<PsiFile> myDependentFiles;
        private final long[] myStamps;

        public PropertiesWatcher(List<PsiFile> dependentFiles) {
            this.myDependentFiles = dependentFiles;
            this.myStamps = new long[dependentFiles.size()];
            int index = 0;
            for (PsiFile file : dependentFiles) {
                this.myStamps[index++] = file.getModificationStamp();
            }
        }

        public boolean needRebuildProperties() {
            int idx = 0;
            for (PsiFile file : this.myDependentFiles) {
                if (this.myStamps[idx++] == file.getModificationStamp()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ReflectedProject {
        @NonNls
        private static final String INIT_METHOD_NAME = "init";
        @NonNls
        private static final String GET_TASK_DEFINITIONS_METHOD_NAME = "getTaskDefinitions";
        @NonNls
        private static final String GET_DATA_TYPE_DEFINITIONS_METHOD_NAME = "getDataTypeDefinitions";
        @NonNls
        private static final String GET_PROPERTIES_METHOD_NAME = "getProperties";
        private static final List<SoftReference<Pair<ReflectedProject, ClassLoader>>> ourProjects = new ArrayList<SoftReference<Pair<ReflectedProject, ClassLoader>>>();
        private static final Alarm ourAlarm = new Alarm();
        private final Object myProject;
        private Hashtable myTaskDefinitions;
        private Hashtable myDataTypeDefinitions;
        private Hashtable myProperties;
        private Class myTargetClass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static ReflectedProject getProject(ClassLoader classLoader) {
            ReflectedProject reflectedProject;
            SoftReference<Pair<ReflectedProject, ClassLoader>> ref2;
            try {
                List<SoftReference<Pair<ReflectedProject, ClassLoader>>> list = ourProjects;
                // MONITORENTER : list
                for (SoftReference<Pair<ReflectedProject, ClassLoader>> ref2 : ourProjects) {
                    Pair<ReflectedProject, ClassLoader> pair = ref2.get();
                    if (pair == null || pair.first == null || ((ReflectedProject)pair.first).myProject == null || pair.second != classLoader) continue;
                    reflectedProject = (ReflectedProject)pair.first;
                    // MONITOREXIT : list
                }
            }
            catch (Throwable throwable) {
                ourAlarm.cancelAllRequests();
                ourAlarm.addRequest(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = ourProjects;
                        synchronized (list) {
                            ourProjects.clear();
                        }
                    }
                }, 30000, ModalityState.NON_MODAL);
                throw throwable;
            }
            {
                ourAlarm.cancelAllRequests();
                ourAlarm.addRequest(new /* invalid duplicate definition of identical inner class */, 30000, ModalityState.NON_MODAL);
                return reflectedProject;
            }
            ReflectedProject project = new ReflectedProject(classLoader);
            ref2 = new SoftReference<Pair>(new Pair((Object)project, (Object)classLoader));
            int i = 0;
            while (true) {
                if (i >= ourProjects.size()) {
                    ourProjects.add(ref2);
                    ReflectedProject reflectedProject2 = project;
                    // MONITOREXIT : list
                    ourAlarm.cancelAllRequests();
                    ourAlarm.addRequest(new /* invalid duplicate definition of identical inner class */, 30000, ModalityState.NON_MODAL);
                    return reflectedProject2;
                }
                Pair<ReflectedProject, ClassLoader> pair = ourProjects.get(i).get();
                if (pair == null) {
                    ourProjects.set(i, ref2);
                    ReflectedProject reflectedProject3 = project;
                    // MONITOREXIT : list
                    ourAlarm.cancelAllRequests();
                    ourAlarm.addRequest(new /* invalid duplicate definition of identical inner class */, 30000, ModalityState.NON_MODAL);
                    return reflectedProject3;
                }
                ++i;
            }
        }

        private ReflectedProject(ClassLoader classLoader) {
            Object myProject = null;
            try {
                Class<?> projectClass = classLoader.loadClass("org.apache.tools.ant.Project");
                if (projectClass != null) {
                    myProject = projectClass.newInstance();
                    Method method = projectClass.getMethod(INIT_METHOD_NAME, new Class[0]);
                    method.invoke(myProject, new Object[0]);
                    method = ReflectedProject.getMethod(projectClass, GET_TASK_DEFINITIONS_METHOD_NAME);
                    this.myTaskDefinitions = (Hashtable)method.invoke(myProject, new Object[0]);
                    method = ReflectedProject.getMethod(projectClass, GET_DATA_TYPE_DEFINITIONS_METHOD_NAME);
                    this.myDataTypeDefinitions = (Hashtable)method.invoke(myProject, new Object[0]);
                    method = ReflectedProject.getMethod(projectClass, GET_PROPERTIES_METHOD_NAME);
                    this.myProperties = (Hashtable)method.invoke(myProject, new Object[0]);
                    this.myTargetClass = classLoader.loadClass("org.apache.tools.ant.Target");
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                myProject = null;
            }
            this.myProject = myProject;
        }

        private static Method getMethod(Class introspectionHelperClass, String name) throws NoSuchMethodException {
            Method method = introspectionHelperClass.getMethod(name, new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
    }
}

