/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class TargetFilter
implements JDOMExternalizable {
    @NonNls
    private static final String FILTER_TARGET_NAME = "targetName";
    @NonNls
    private static final String FILTER_IS_VISIBLE = "isVisible";
    private String myTargetName;
    private boolean myVisible;
    private String myDescription = "";

    public TargetFilter() {
    }

    public TargetFilter(String targetName, boolean isVisible) {
        this.myTargetName = targetName;
        this.myVisible = isVisible;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean isVisible) {
        this.myVisible = isVisible;
    }

    public void readExternal(Element element) {
        this.myTargetName = element.getAttributeValue(FILTER_TARGET_NAME);
        this.myVisible = Boolean.valueOf(element.getAttributeValue(FILTER_IS_VISIBLE));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String targetName = this.getTargetName();
        if (targetName == null) {
            throw new WriteExternalException();
        }
        element.setAttribute(FILTER_TARGET_NAME, targetName);
        element.setAttribute(FILTER_IS_VISIBLE, Boolean.valueOf(this.isVisible()).toString());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void updateDescription(AntBuildTarget target) {
        if (target == null) {
            return;
        }
        this.myDescription = target.getNotEmptyDescription();
    }

    public static TargetFilter fromTarget(AntBuildTarget target) {
        TargetFilter filter = new TargetFilter(target.getName(), target.isDefault());
        filter.myDescription = target.getNotEmptyDescription();
        filter.myVisible = filter.myDescription != null;
        return filter;
    }
}

