/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.actions;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.states.ComparisonFailureState;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ViewAssertEqualsDiffAction
extends AnAction {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(AnActionEvent e) {
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(e.getDataContext());
        if (testProxy != null) {
            ComparisonFailureState state = (ComparisonFailureState)((TestProxy)testProxy).getState();
            state.openDiff((Project)PlatformDataKeys.PROJECT.getData(e.getDataContext()));
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        if (PlatformDataKeys.PROJECT.getData(dataContext) == null) {
            enabled = false;
        } else {
            AbstractTestProxy test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext);
            if (test instanceof TestProxy) {
                TestState state = ((TestProxy)test).getState();
                enabled = state instanceof ComparisonFailureState;
            } else {
                enabled = false;
            }
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    public static void registerShortcut(JComponent component) {
        ActionManager.getInstance().getAction(ACTION_ID).registerCustomShortcutSet(CommonShortcuts.ALT_ENTER, component);
    }
}

