/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    public static boolean findAllTestClasses(final TestClassFilter testClassFilter, final Set<PsiClass> found) {
        PsiMethod[] suiteMethods;
        final PsiManager manager = testClassFilter.getPsiManager();
        GlobalSearchScope projectScopeWithoutLibraries = GlobalSearchScope.projectScope((Project)manager.getProject());
        final GlobalSearchScope scope = projectScopeWithoutLibraries.intersectWith(testClassFilter.getScope());
        ClassInheritorsSearch.search((PsiClass)testClassFilter.getBase(), (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

            public boolean execute(PsiClass aClass) {
                if (testClassFilter.isAccepted(aClass)) {
                    found.add(aClass);
                }
                return true;
            }
        }));
        for (final PsiMethod method : suiteMethods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return JavaPsiFacade.getInstance((Project)manager.getProject()).getShortNamesCache().getMethodsByName("suite", scope);
            }
        })) {
            PsiClass containingClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                public PsiClass compute() {
                    return method.getContainingClass();
                }
            });
            if (containingClass == null || containingClass instanceof PsiAnonymousClass || containingClass.hasModifierProperty("abstract") || containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static") || !((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return JUnitUtil.isSuiteMethod((PsiMethod)method);
                }
            })).booleanValue()) continue;
            found.add(containingClass);
        }
        boolean hasJunit4 = ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, "org.junit.Test", true);
        return hasJunit4 |= ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, "org.junit.runner.RunWith", false);
    }

    private static boolean addAnnotatedMethodsAnSubclasses(final PsiManager manager, final GlobalSearchScope scope, final TestClassFilter testClassFilter, final Set<PsiClass> found, final String annotation, final boolean isMethod) {
        final Ref isJUnit4 = new Ref((Object)Boolean.FALSE);
        final PsiClass testAnnotation = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(annotation, GlobalSearchScope.allScope((Project)manager.getProject()));
            }
        });
        if (testAnnotation != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    AnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject())).forEach((Processor)new Processor<PsiMember>(){

                        public boolean process(PsiMember annotated) {
                            PsiClass containingClass;
                            PsiClass psiClass = containingClass = annotated instanceof PsiClass ? (PsiClass)annotated : annotated.getContainingClass();
                            if (containingClass != null && annotated instanceof PsiMethod == isMethod) {
                                if (scope.contains(PsiUtilBase.getVirtualFile((PsiElement)containingClass)) && testClassFilter.isAccepted(containingClass)) {
                                    found.add(containingClass);
                                    isJUnit4.set((Object)Boolean.TRUE);
                                }
                                ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                                    public boolean execute(PsiClass aClass) {
                                        if (testClassFilter.isAccepted(aClass)) {
                                            found.add(aClass);
                                            isJUnit4.set((Object)Boolean.TRUE);
                                        }
                                        return true;
                                    }
                                }));
                            }
                            return true;
                        }
                    });
                }
            });
        }
        return (Boolean)isJUnit4.get();
    }
}

