/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.file.IWriterFactory;
import org.netbeans.lib.cvsclient.io.IStreamLogger;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class ConnectionStreams
implements IConnectionStreams,
IReaderFactory,
IWriterFactory {
    private final IConnection connection;
    private final IStreamLogger streamLogger;
    private InputStream loggedInputStream;
    private OutputStream loggedOutputStream;
    private Reader loggedReader;
    private Writer loggedWriter;
    private InputStream inputStream;
    private OutputStream outputStream;
    private DeflaterOutputStream deflaterOutputStream;
    private final String myCharset;
    @NonNls
    private static final String UNTIL_HERE_THE_CONTENT_IS_GZIPPED_MESSAGE = "@until here the content is gzipped@";
    @NonNls
    private static final String FROM_NOW_ON_THE_CONTENT_IS_GZIPPED_MESSAGE = "@from now on the content is gzipped@";

    public ConnectionStreams(IConnection connection, IStreamLogger streamLogger, String charset) {
        BugLog.getInstance().assertNotNull(connection);
        BugLog.getInstance().assertNotNull(streamLogger);
        this.connection = connection;
        this.streamLogger = streamLogger;
        this.myCharset = charset;
        this.setInputStream(connection.getInputStream());
        this.setOutputStream(connection.getOutputStream());
    }

    @Override
    public Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    @Override
    public Writer createWriter(OutputStream outputStream) {
        try {
            return new OutputStreamWriter(outputStream, this.myCharset);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public IReaderFactory getReaderFactory() {
        return this;
    }

    @Override
    public IWriterFactory getWriterFactory() {
        return this;
    }

    @Override
    public InputStream getLoggedInputStream() {
        return this.loggedInputStream;
    }

    @Override
    public OutputStream getLoggedOutputStream() {
        return this.loggedOutputStream;
    }

    @Override
    public Reader getLoggedReader() {
        return this.loggedReader;
    }

    @Override
    public Writer getLoggedWriter() {
        return this.loggedWriter;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void flushForReading() throws IOException {
        this.loggedWriter.flush();
        if (this.deflaterOutputStream != null) {
            this.deflaterOutputStream.finish();
            this.println(UNTIL_HERE_THE_CONTENT_IS_GZIPPED_MESSAGE, this.streamLogger.getOutputLogStream());
        }
        this.loggedOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.loggedOutputStream != null) {
                try {
                    this.loggedOutputStream.close();
                }
                catch (IOException ex) {
                    BugLog.getInstance().showException(ex);
                }
            }
            if (this.loggedInputStream != null) {
                try {
                    this.loggedInputStream.close();
                }
                catch (IOException ex) {
                    BugLog.getInstance().showException(ex);
                }
            }
        }
        finally {
            try {
                this.connection.close();
            }
            catch (IOException ex) {
                BugLog.getInstance().showException(ex);
            }
        }
    }

    public void setGzipped() throws IOException {
        this.loggedWriter.flush();
        this.loggedOutputStream.flush();
        this.println(FROM_NOW_ON_THE_CONTENT_IS_GZIPPED_MESSAGE, this.streamLogger.getInputLogStream());
        this.println(FROM_NOW_ON_THE_CONTENT_IS_GZIPPED_MESSAGE, this.streamLogger.getOutputLogStream());
        this.deflaterOutputStream = new DeflaterOutputStream(this.connection.getOutputStream(), new Deflater(6));
        this.setOutputStream(this.deflaterOutputStream);
        this.setInputStream(new InflaterInputStream(this.connection.getInputStream()));
    }

    private void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.loggedInputStream = this.streamLogger.createLoggingInputStream(inputStream);
        this.loggedReader = this.createReader(this.loggedInputStream);
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.loggedOutputStream = this.streamLogger.createLoggingOutputStream(outputStream);
        this.loggedWriter = this.createWriter(this.loggedOutputStream);
    }

    private void println(String text, OutputStream outputStream) throws IOException {
        OutputStreamWriter writerNoSpecialEncoding = new OutputStreamWriter(outputStream);
        this.println(text, writerNoSpecialEncoding);
        writerNoSpecialEncoding.flush();
    }

    private void println(String text, Writer writer) throws IOException {
        writer.write(text);
        writer.write(10);
    }
}

