/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialogs;
import sun.security.util.HostnameChecker;
import sun.security.validator.ValidatorException;

public final class VariableX509TrustManager
extends X509ExtendedTrustManager {
    private X509TrustManager[] caTrustManagers = null;
    private X509TrustManager[] certTrustManagers = null;
    private X509TrustManager[] clientTrustManagers = null;
    private ArrayList<Certificate> temporarilyTrusted = new ArrayList();
    private ArrayList<Certificate> temporarilyUntrusted = new ArrayList();
    private static VariableX509TrustManager instance = null;

    public VariableX509TrustManager() {
        int i;
        TrustManager[] trustManagers;
        TrustManagerFactory tmFactory;
        int j;
        try {
            KeyStore[] trustedCertKeyStores = KeyStores.getCertKeyStores();
            this.certTrustManagers = new X509TrustManager[trustedCertKeyStores.length];
            for (j = 0; j < trustedCertKeyStores.length; ++j) {
                tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                tmFactory.init(trustedCertKeyStores[j]);
                trustManagers = tmFactory.getTrustManagers();
                for (i = 0; i < trustManagers.length; ++i) {
                    if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                    this.certTrustManagers[j] = (X509TrustManager)trustManagers[i];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            KeyStore[] trustedCAKeyStores = KeyStores.getCAKeyStores();
            this.caTrustManagers = new X509TrustManager[trustedCAKeyStores.length];
            for (j = 0; j < this.caTrustManagers.length; ++j) {
                tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                tmFactory.init(trustedCAKeyStores[j]);
                trustManagers = tmFactory.getTrustManagers();
                for (i = 0; i < trustManagers.length; ++i) {
                    if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                    this.caTrustManagers[j] = (X509TrustManager)trustManagers[i];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            KeyStore[] clientKeyStores = KeyStores.getClientKeyStores();
            this.clientTrustManagers = new X509TrustManager[clientKeyStores.length];
            for (j = 0; j < this.clientTrustManagers.length; ++j) {
                tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                tmFactory.init(clientKeyStores[j]);
                trustManagers = tmFactory.getTrustManagers();
                for (i = 0; i < trustManagers.length; ++i) {
                    if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                    this.clientTrustManagers[j] = (X509TrustManager)trustManagers[i];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType, String hostName, String algorithm) throws CertificateException {
        boolean trusted = false;
        ValidatorException savedException = null;
        for (int i = 0; i < this.clientTrustManagers.length; ++i) {
            try {
                this.clientTrustManagers[i].checkClientTrusted(chain, authType);
                trusted = true;
                break;
            }
            catch (ValidatorException caex) {
                savedException = caex;
                continue;
            }
        }
        if (trusted) {
            return;
        }
        throw savedException;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType, null, null);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType, String hostName, String algorithm) throws CertificateException {
        this.checkServerTrusted(chain, authType, hostName, false);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, null, null);
    }

    public synchronized void checkServerTrusted(X509Certificate[] chain, String authType, String hostName, boolean checkOnly) throws CertificateException {
        CertificateException ce = null;
        boolean trusted = true;
        boolean CNMatched = true;
        try {
            this.checkAllManagers(chain, authType);
        }
        catch (CertificateException e) {
            trusted = false;
            ce = e;
        }
        if (!this.isExplicitlyTrusted(chain, authType)) {
            if (hostName == null) {
                CNMatched = false;
            } else {
                try {
                    HostnameChecker checker = HostnameChecker.getInstance((byte)1);
                    checker.match(hostName, chain[0]);
                }
                catch (CertificateException e) {
                    CNMatched = false;
                    ce = e;
                }
            }
        }
        if (!trusted || !CNMatched) {
            if (checkOnly) {
                throw ce;
            }
            if (!this.isTemporarilyUntrusted(chain[0])) {
                boolean b = this.askUser(chain, authType, trusted, CNMatched, hostName);
                if (b) {
                    this.temporarilyTrust(chain[0]);
                } else {
                    this.temporarilyUntrust(chain[0]);
                }
            }
            this.checkAllManagers(chain, authType);
        }
    }

    private void checkAllManagers(X509Certificate[] chain, String authType) throws CertificateException {
        int i;
        boolean trusted = false;
        ValidatorException savedException = null;
        for (i = 0; i < this.caTrustManagers.length; ++i) {
            try {
                this.caTrustManagers[i].checkServerTrusted(chain, authType);
                trusted = true;
                break;
            }
            catch (ValidatorException caex) {
                savedException = caex;
                continue;
            }
        }
        if (trusted) {
            return;
        }
        for (i = 0; i < this.certTrustManagers.length; ++i) {
            try {
                this.certTrustManagers[i].checkServerTrusted(chain, authType);
                trusted = true;
                break;
            }
            catch (ValidatorException caex) {
                savedException = caex;
                continue;
            }
        }
        if (trusted) {
            return;
        }
        if (!this.temporarilyTrusted.contains(chain[0])) {
            if (savedException == null) {
                throw new ValidatorException(ValidatorException.T_SIGNATURE_ERROR, chain[0]);
            }
            throw savedException;
        }
    }

    private boolean isExplicitlyTrusted(X509Certificate[] chain, String authType) {
        boolean explicitlyTrusted = false;
        for (int i = 0; i < this.certTrustManagers.length; ++i) {
            try {
                this.certTrustManagers[i].checkServerTrusted(chain, authType);
                explicitlyTrusted = true;
                break;
            }
            catch (ValidatorException uex) {
                if (!this.temporarilyTrusted.contains(chain[0])) continue;
                explicitlyTrusted = true;
                break;
            }
            catch (CertificateException ce) {
                // empty catch block
            }
        }
        return explicitlyTrusted;
    }

    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.caTrustManagers.length; ++i) {
            issuers.addAll(Arrays.asList(this.caTrustManagers[i].getAcceptedIssuers()));
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    private void temporarilyUntrust(Certificate c) {
        this.temporarilyUntrusted.add(c);
    }

    private boolean isTemporarilyUntrusted(Certificate c) {
        return this.temporarilyUntrusted.contains(c);
    }

    private void temporarilyTrust(Certificate c) {
        this.temporarilyTrusted.add(c);
    }

    private boolean askUser(final X509Certificate[] chain, final String authType, final boolean isTrusted, final boolean hostMatched, final String hostName) {
        if (JNLPRuntime.isTrustAll()) {
            return true;
        }
        final VariableX509TrustManager trustManager = this;
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SecurityDialogs.showCertWarningDialog(SecurityDialogs.AccessType.UNVERIFIED, null, new HttpsCertVerifier(trustManager, chain, authType, isTrusted, hostMatched, hostName));
            }
        });
    }

    public static VariableX509TrustManager getInstance() {
        if (instance == null) {
            instance = new VariableX509TrustManager();
        }
        return instance;
    }
}

