/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPMatcher;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.CachedJarFileCallback;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.tools.JarSigner;
import net.sourceforge.jnlp.util.FileUtils;
import sun.misc.JarIndex;

public class JNLPClassLoader
extends URLClassLoader {
    public static final String TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";
    public static final String APPLICATION = "JNLP-INF/APPLICATION.JNLP";
    private boolean isSignedJNLP = false;
    private static Map<String, JNLPClassLoader> urlToLoader = new HashMap<String, JNLPClassLoader>();
    private File nativeDir = null;
    private List<File> nativeDirectories = Collections.synchronizedList(new LinkedList());
    private AccessControlContext acc = AccessController.getContext();
    private List<Permission> resourcePermissions;
    private ApplicationInstance app = null;
    private JNLPClassLoader[] loaders = null;
    private boolean strict = true;
    private ResourceTracker tracker = new ResourceTracker(true);
    private UpdatePolicy updatePolicy;
    private JNLPFile file;
    private ResourcesDesc resources;
    private SecurityDesc security;
    private ArrayList<Permission> runtimePermissions = new ArrayList();
    private List<JARDesc> available = new ArrayList<JARDesc>();
    private ArrayList<String> verifiedJars = null;
    private ArrayList<String> unverifiedJars = null;
    private JarSigner js = null;
    private boolean signing = false;
    private ArrayList<JarIndex> jarIndexes = new ArrayList();
    private Set<String> classpaths = new HashSet<String>();
    private TreeSet<String> jarEntries = new TreeSet();
    private HashMap<URL, SecurityDesc> jarLocationSecurityMap = new HashMap();
    private CodeBaseClassLoader codeBaseLoader;
    private boolean foundMainJar = false;
    private int useCount = 0;

    protected JNLPClassLoader(JNLPFile file, UpdatePolicy policy) throws LaunchException {
        super(new URL[0], JNLPClassLoader.class.getClassLoader());
        if (JNLPRuntime.isDebug()) {
            System.out.println("New classloader: " + file.getFileLocation());
        }
        this.file = file;
        this.updatePolicy = policy;
        this.resources = file.getResources();
        this.initializeExtensions();
        this.initializeResources();
        this.initializePermissions();
        this.setSecurity();
        this.installShutdownHooks();
    }

    private void installShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (JNLPClassLoader.this.nativeDir != null) {
                    if (JNLPRuntime.isDebug()) {
                        System.out.println("Cleaning up native directory" + JNLPClassLoader.this.nativeDir.getAbsolutePath());
                    }
                    try {
                        FileUtils.recursiveDelete(JNLPClassLoader.this.nativeDir, new File(System.getProperty("java.io.tmpdir")));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void setSecurity() throws LaunchException {
        URL codebase = null;
        codebase = this.file.getCodeBase() != null ? this.file.getCodeBase() : this.file.getResources().getMainJAR().getLocation();
        if (this.file instanceof PluginBridge) {
            this.security = this.signing ? new SecurityDesc(this.file, SecurityDesc.ALL_PERMISSIONS, codebase.getHost()) : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost());
        } else {
            if (!this.file.getSecurity().getSecurityType().equals(SecurityDesc.SANDBOX_PERMISSIONS) && !this.signing) {
                throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedJarWithSecurity"), Translator.R("LUnsignedJarWithSecurityInfo"));
            }
            this.security = this.signing ? this.file.getSecurity() : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNLPClassLoader getInstance(JNLPFile file, UpdatePolicy policy) throws LaunchException {
        JNLPClassLoader baseLoader = null;
        JNLPClassLoader loader = null;
        String uniqueKey = file.getUniqueKey();
        if (uniqueKey != null) {
            baseLoader = urlToLoader.get(uniqueKey);
        }
        if (baseLoader == null || file.isApplication() && !baseLoader.getJNLPFile().getFileLocation().equals(file.getFileLocation())) {
            loader = new JNLPClassLoader(file, policy);
            JNLPClassLoader extLoader = urlToLoader.get(uniqueKey);
            if (extLoader != null && extLoader != loader) {
                if (loader.signing && !extLoader.signing && !SecurityDialogs.showNotAllSignedWarningDialog(file)) {
                    throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedAppJarUsingUnsignedJar"), Translator.R("LSignedAppJarUsingUnsignedJarInfo"));
                }
                loader.merge(extLoader);
                extLoader.decrementLoaderUseCount();
            }
            if (baseLoader != null && baseLoader != loader) {
                loader.merge(baseLoader);
            }
        } else {
            if (!file.isApplication()) {
                loader = new JNLPClassLoader(file, policy);
                if (baseLoader != null) {
                    baseLoader.merge(loader);
                }
            }
            loader = baseLoader;
        }
        loader.incrementLoaderUseCount();
        Map<String, JNLPClassLoader> map = urlToLoader;
        synchronized (map) {
            urlToLoader.put(uniqueKey, loader);
        }
        return loader;
    }

    public static JNLPClassLoader getInstance(URL location, String uniqueKey, Version version, UpdatePolicy policy) throws IOException, ParseException, LaunchException {
        JNLPClassLoader loader = urlToLoader.get(uniqueKey);
        if (loader == null || !location.equals(loader.getJNLPFile().getFileLocation())) {
            loader = JNLPClassLoader.getInstance(new JNLPFile(location, uniqueKey, version, false, policy), policy);
        }
        return loader;
    }

    void initializeExtensions() {
        ExtensionDesc[] ext = this.resources.getExtensions();
        ArrayList<JNLPClassLoader> loaderList = new ArrayList<JNLPClassLoader>();
        loaderList.add(this);
        for (int i = 0; i < ext.length; ++i) {
            try {
                String uniqueKey = this.getJNLPFile().getUniqueKey();
                JNLPClassLoader loader = JNLPClassLoader.getInstance(ext[i].getLocation(), uniqueKey, ext[i].getVersion(), this.updatePolicy);
                loaderList.add(loader);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loaders = loaderList.toArray(new JNLPClassLoader[loaderList.size()]);
    }

    void initializePermissions() {
        this.resourcePermissions = new ArrayList<Permission>();
        JARDesc[] jars = this.resources.getJARs();
        for (int i = 0; i < jars.length; ++i) {
            Permission p = CacheUtil.getReadPermission(jars[i].getLocation(), jars[i].getVersion());
            if (JNLPRuntime.isDebug()) {
                if (p == null) {
                    System.out.println("Unable to add permission for " + jars[i].getLocation());
                } else {
                    System.out.println("Permission added: " + p.toString());
                }
            }
            if (p == null) continue;
            this.resourcePermissions.add(p);
        }
    }

    void initializeResources() throws LaunchException {
        JARDesc[] jars = this.resources.getJARs();
        if (jars == null || jars.length == 0) {
            return;
        }
        ArrayList<JARDesc> initialJars = new ArrayList<JARDesc>();
        for (int i = 0; i < jars.length; ++i) {
            this.available.add(jars[i]);
            if (jars[i].isEager()) {
                initialJars.add(jars[i]);
            }
            this.tracker.addResource(jars[i].getLocation(), jars[i].getVersion(), this.getDownloadOptionsForJar(jars[i]), jars[i].isCacheable() ? JNLPRuntime.getDefaultUpdatePolicy() : UpdatePolicy.FORCE);
        }
        if (initialJars.size() == 0) {
            initialJars.add(jars[0]);
        }
        if (this.strict) {
            this.fillInPartJars(initialJars);
        }
        if (JNLPRuntime.isVerifying()) {
            JarSigner js;
            this.waitForJars(initialJars);
            try {
                js = this.verifyJars(initialJars);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LFatalVerification"), Translator.R("LFatalVerificationInfo"));
            }
            if (js.anyJarsSigned() && js.isFullySignedByASingleCert()) {
                this.signing = true;
                if (!js.allJarsSigned() && !SecurityDialogs.showNotAllSignedWarningDialog(this.file)) {
                    throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedAppJarUsingUnsignedJar"), Translator.R("LSignedAppJarUsingUnsignedJarInfo"));
                }
                this.checkForMain(initialJars);
                while (!this.foundMainJar && this.available != null && this.available.size() != 0) {
                    this.addNextResource();
                }
                if (!(!(this.file.getLaunchInfo() instanceof AppletDesc) && !(this.file.getLaunchInfo() instanceof ApplicationDesc) || this.foundMainJar || this.available != null && this.available.size() != 0)) {
                    throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo"));
                }
                if (!this.isSignedJNLP && this.foundMainJar) {
                    this.file.setSignedJNLPAsMissing();
                }
                if (!js.getAlreadyTrustPublisher()) {
                    this.checkTrustWithUser(js);
                }
            } else {
                this.signing = false;
            }
        }
        for (JARDesc jarDesc : this.file.getResources().getJARs()) {
            try {
                File cachedFile = this.tracker.getCacheFile(jarDesc.getLocation());
                if (cachedFile == null) {
                    System.err.println("JAR " + jarDesc.getLocation() + " not found. Continuing.");
                    continue;
                }
                URL location = cachedFile.toURL();
                SecurityDesc jarSecurity = this.file.getSecurity();
                if (this.file instanceof PluginBridge) {
                    URL codebase = null;
                    codebase = this.file.getCodeBase() != null ? this.file.getCodeBase() : this.file.getResources().getMainJAR().getLocation();
                    jarSecurity = this.signing ? new SecurityDesc(this.file, SecurityDesc.ALL_PERMISSIONS, codebase.getHost()) : new SecurityDesc(this.file, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost());
                }
                this.jarLocationSecurityMap.put(jarDesc.getLocation(), jarSecurity);
            }
            catch (MalformedURLException mfe) {
                System.err.println(mfe.getMessage());
            }
        }
        this.activateJars(initialJars);
    }

    private void checkForMain(List<JARDesc> jars) throws LaunchException {
        String mainClass;
        Object ad;
        Object obj = this.file.getLaunchInfo();
        if (obj instanceof ApplicationDesc) {
            ad = (ApplicationDesc)this.file.getLaunchInfo();
            mainClass = ((ApplicationDesc)ad).getMainClass();
        } else if (obj instanceof AppletDesc) {
            ad = (AppletDesc)this.file.getLaunchInfo();
            mainClass = ((AppletDesc)ad).getMainClass();
        } else {
            return;
        }
        if (mainClass == null) {
            JARDesc mainJarDesc = this.file.getResources().getMainJAR();
            mainClass = this.getMainClassName(mainJarDesc.getLocation());
        }
        if (mainClass == null) {
            JARDesc firstJarDesc = jars.get(0);
            mainClass = this.getMainClassName(firstJarDesc.getLocation());
        }
        if (mainClass == null) {
            for (JARDesc jarDesc : jars) {
                String mainClassInThisJar = this.getMainClassName(jarDesc.getLocation());
                if (mainClassInThisJar == null) continue;
                if (mainClass == null) {
                    mainClass = mainClassInThisJar;
                    continue;
                }
                mainClass = null;
                break;
            }
        }
        String desiredJarEntryName = mainClass + ".class";
        block3: for (int i = 0; i < jars.size(); ++i) {
            try {
                File localFile = this.tracker.getCacheFile(jars.get(i).getLocation());
                if (localFile == null) {
                    System.err.println("JAR " + jars.get(i).getLocation() + " not found. Continuing.");
                    continue;
                }
                JarFile jarFile = new JarFile(localFile);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String jeName = je.getName().replaceAll("/", ".");
                    if (!jeName.equals(desiredJarEntryName)) continue;
                    this.foundMainJar = true;
                    this.verifySignedJNLP(jars.get(i), jarFile);
                    continue block3;
                }
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private String getMainClassName(URL location) {
        String mainClass = null;
        File f = this.tracker.getCacheFile(location);
        if (f != null) {
            try {
                JarFile mainJar = new JarFile(f);
                mainClass = mainJar.getManifest().getMainAttributes().getValue("Main-Class");
            }
            catch (IOException ioe) {
                mainClass = null;
            }
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySignedJNLP(JARDesc jarDesc, JarFile jarFile) throws LaunchException {
        block17: {
            JarSigner signer = new JarSigner();
            ArrayList<JARDesc> desc = new ArrayList<JARDesc>();
            desc.add(jarDesc);
            InputStream inStream = null;
            InputStreamReader inputReader = null;
            FileReader fr = null;
            FileReader jnlpReader = null;
            try {
                signer.verifyJars(desc, this.tracker);
                if (!signer.allJarsSigned()) break block17;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JNLPMatcher matcher;
                    JarEntry je = entries.nextElement();
                    String jeName = je.getName().toUpperCase();
                    if (!jeName.equals(TEMPLATE) && !jeName.equals(APPLICATION)) continue;
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Creating Jar InputStream from JarEntry");
                    }
                    inStream = jarFile.getInputStream(je);
                    inputReader = new InputStreamReader(inStream);
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Creating File InputStream from lauching JNLP file");
                    }
                    JNLPFile jnlp = this.getJNLPFile();
                    URL url = jnlp.getFileLocation();
                    File jn = null;
                    jn = url.getProtocol().toLowerCase().equals("file") ? new File(url.getPath()) : CacheUtil.getCacheFile(url, null);
                    jnlpReader = fr = new FileReader(jn);
                    if (jeName.equals(APPLICATION)) {
                        if (JNLPRuntime.isDebug()) {
                            System.err.println("APPLICATION.JNLP has been located within signed JAR. Starting verfication...");
                        }
                        matcher = new JNLPMatcher(inputReader, jnlpReader, false);
                    } else {
                        if (JNLPRuntime.isDebug()) {
                            System.err.println("APPLICATION_TEMPLATE.JNLP has been located within signed JAR. Starting verfication...");
                        }
                        matcher = new JNLPMatcher(inputReader, jnlpReader, true);
                    }
                    if (!matcher.isMatch()) {
                        throw new JNLPMatcherException("Signed Application did not match launching JNLP File");
                    }
                    this.isSignedJNLP = true;
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Signed Application Verification Successful");
                    }
                    break;
                }
            }
            catch (JNLPMatcherException e) {
                throw new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LSignedJNLPFileDidNotMatch"), Translator.R(e.getMessage()));
            }
            catch (Exception e) {
                if (JNLPRuntime.isDebug()) {
                    e.printStackTrace(System.err);
                }
            }
            finally {
                this.closeStream(inStream);
                this.closeStream(inputReader);
                this.closeStream(fr);
                this.closeStream(jnlpReader);
            }
        }
        if (JNLPRuntime.isDebug()) {
            System.err.println("Ending check for signed JNLP file...");
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void checkTrustWithUser(JarSigner js) throws LaunchException {
        if (JNLPRuntime.isTrustAll()) {
            return;
        }
        if (!js.getRootInCacerts()) {
            boolean b = SecurityDialogs.showCertWarningDialog(SecurityDialogs.AccessType.UNVERIFIED, this.file, js);
            if (!b) {
                throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LNotVerified"), "");
            }
        } else if (js.getRootInCacerts()) {
            boolean b = false;
            if (js.noSigningIssues()) {
                b = SecurityDialogs.showCertWarningDialog(SecurityDialogs.AccessType.VERIFIED, this.file, js);
            } else if (!js.noSigningIssues()) {
                b = SecurityDialogs.showCertWarningDialog(SecurityDialogs.AccessType.SIGNING_ERROR, this.file, js);
            }
            if (!b) {
                throw new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCancelOnUserRequest"), "");
            }
        }
    }

    public void enableCodeBase() {
        this.addToCodeBaseLoader(this.file.getCodeBase());
    }

    public void setApplication(ApplicationInstance app) {
        if (this.app != null) {
            if (JNLPRuntime.isDebug()) {
                IllegalStateException ex = new IllegalStateException("Application can only be set once");
                ex.printStackTrace();
            }
            return;
        }
        this.app = app;
    }

    public ApplicationInstance getApplication() {
        return this.app;
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        int i;
        Permissions result = new Permissions();
        if (this.security != null) {
            PermissionCollection permissions = this.security.getSandBoxPermissions();
            if (cs.getCodeSigners() != null && (this.getCodeSourceSecurity(cs.getLocation()).getSecurityType().equals(SecurityDesc.ALL_PERMISSIONS) || this.getCodeSourceSecurity(cs.getLocation()).getSecurityType().equals(SecurityDesc.J2EE_PERMISSIONS))) {
                permissions = this.getCodeSourceSecurity(cs.getLocation()).getPermissions(cs);
            }
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        for (i = 0; i < this.resourcePermissions.size(); ++i) {
            result.add(this.resourcePermissions.get(i));
        }
        for (i = 0; i < this.runtimePermissions.size(); ++i) {
            result.add(this.runtimePermissions.get(i));
        }
        return result;
    }

    protected void addPermission(Permission p) {
        this.runtimePermissions.add(p);
    }

    protected void fillInPartJars(List<JARDesc> jars) {
        for (int i = 0; i < jars.size(); ++i) {
            String part = jars.get(i).getPart();
            for (int a = 0; a < this.available.size(); ++a) {
                JARDesc jar = this.available.get(a);
                if (part == null || !part.equals(jar.getPart()) || jars.contains(jar)) continue;
                jars.add(jar);
            }
        }
    }

    protected void activateJars(final List<JARDesc> jars) {
        PrivilegedAction<Void> activate = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JNLPClassLoader.this.waitForJars(jars);
                for (int i = 0; i < jars.size(); ++i) {
                    JARDesc jar;
                    block18: {
                        jar = (JARDesc)jars.get(i);
                        JNLPClassLoader.this.available.remove(jar);
                        File localFile = JNLPClassLoader.this.tracker.getCacheFile(jar.getLocation());
                        try {
                            JarFile jarFile;
                            URL location = jar.getLocation();
                            if (localFile != null) {
                                location = localFile.toURL();
                                jarFile = new JarFile(localFile);
                                Enumeration<JarEntry> e = jarFile.entries();
                                while (e.hasMoreElements()) {
                                    JarEntry je = e.nextElement();
                                    if (je.getName().endsWith(".jar")) {
                                        int read;
                                        String extractedJarLocation = localFile.getParent() + "/" + je.getName();
                                        File parentDir = new File(extractedJarLocation).getParentFile();
                                        if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                                            throw new RuntimeException(Translator.R("RNestedJarExtration"));
                                        }
                                        FileOutputStream extractedJar = new FileOutputStream(extractedJarLocation);
                                        InputStream is = jarFile.getInputStream(je);
                                        byte[] bytes = new byte[1024];
                                        int fileSize = read = is.read(bytes);
                                        while (read > 0) {
                                            extractedJar.write(bytes, 0, read);
                                            read = is.read(bytes);
                                            fileSize += read;
                                        }
                                        is.close();
                                        extractedJar.close();
                                        if (fileSize <= 0) continue;
                                        JarSigner signer = new JarSigner();
                                        ArrayList<JARDesc> jars2 = new ArrayList<JARDesc>();
                                        JARDesc jarDesc = new JARDesc(new File(extractedJarLocation).toURL(), null, null, false, false, false, false);
                                        jars2.add(jarDesc);
                                        JNLPClassLoader.this.tracker.addResource(new File(extractedJarLocation).toURL(), null, null, null);
                                        signer.verifyJars(jars2, JNLPClassLoader.this.tracker);
                                        if (signer.anyJarsSigned() && !signer.getAlreadyTrustPublisher()) {
                                            JNLPClassLoader.this.checkTrustWithUser(signer);
                                        }
                                        try {
                                            URL fileURL = new URL("file://" + extractedJarLocation);
                                            URL fakeRemote = new URL(jar.getLocation().toString() + "!" + je.getName());
                                            CachedJarFileCallback.getInstance().addMapping(fakeRemote, fileURL);
                                            JNLPClassLoader.this.addURL(fakeRemote);
                                            SecurityDesc jarSecurity = JNLPClassLoader.this.file.getSecurity();
                                            if (JNLPClassLoader.this.file instanceof PluginBridge) {
                                                URL codebase = null;
                                                codebase = JNLPClassLoader.this.file.getCodeBase() != null ? JNLPClassLoader.this.file.getCodeBase() : JNLPClassLoader.this.file.getResources().getMainJAR().getLocation();
                                                jarSecurity = new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.ALL_PERMISSIONS, codebase.getHost());
                                            }
                                            JNLPClassLoader.this.jarLocationSecurityMap.put(fakeRemote, jarSecurity);
                                        }
                                        catch (MalformedURLException mfue) {
                                            if (JNLPRuntime.isDebug()) {
                                                System.err.println("Unable to add extracted nested jar to classpath");
                                            }
                                            mfue.printStackTrace();
                                        }
                                    }
                                    JNLPClassLoader.this.jarEntries.add(je.getName());
                                }
                            }
                            JNLPClassLoader.this.addURL(jar.getLocation());
                            if (localFile != null) {
                                JarIndex index;
                                CachedJarFileCallback.getInstance().addMapping(jar.getLocation(), localFile.toURL());
                                jarFile = new JarFile(localFile.getAbsolutePath());
                                Manifest mf = jarFile.getManifest();
                                if (JNLPClassLoader.this.file instanceof PluginBridge) {
                                    JNLPClassLoader.this.classpaths.addAll(JNLPClassLoader.this.getClassPathsFromManifest(mf, jar.getLocation().getPath()));
                                }
                                if ((index = JarIndex.getJarIndex((JarFile)jarFile, null)) != null) {
                                    JNLPClassLoader.this.jarIndexes.add(index);
                                }
                            } else {
                                CachedJarFileCallback.getInstance().addMapping(jar.getLocation(), jar.getLocation());
                            }
                            if (JNLPRuntime.isDebug()) {
                                System.err.println("Activate jar: " + location);
                            }
                        }
                        catch (Exception ex) {
                            if (!JNLPRuntime.isDebug()) break block18;
                            ex.printStackTrace();
                        }
                    }
                    JNLPClassLoader.this.activateNative(jar);
                }
                return null;
            }
        };
        AccessController.doPrivileged(activate, this.acc);
    }

    protected void activateNative(JARDesc jar) {
        block8: {
            File localFile;
            if (JNLPRuntime.isDebug()) {
                System.out.println("Activate native: " + jar.getLocation());
            }
            if ((localFile = this.tracker.getCacheFile(jar.getLocation())) == null) {
                return;
            }
            String[] librarySuffixes = new String[]{".so", ".dylib", ".jnilib", ".framework", ".dll"};
            try {
                JarFile jarFile = new JarFile(localFile, false);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    File outFile;
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory()) continue;
                    String name = new File(e.getName()).getName();
                    boolean isLibrary = false;
                    for (String suffix : librarySuffixes) {
                        if (!name.endsWith(suffix)) continue;
                        isLibrary = true;
                        break;
                    }
                    if (!isLibrary) continue;
                    if (this.nativeDir == null) {
                        this.nativeDir = this.getNativeDir();
                    }
                    if (!(outFile = new File(this.nativeDir, name)).isFile()) {
                        FileUtils.createRestrictedFile(outFile, true);
                    }
                    CacheUtil.streamCopy(jarFile.getInputStream(e), new FileOutputStream(outFile));
                }
            }
            catch (IOException ex) {
                if (!JNLPRuntime.isDebug()) break block8;
                ex.printStackTrace();
            }
        }
    }

    protected File getNativeDir() {
        int rand = (int)((Math.random() * 2.0 - 1.0) * 2.147483647E9);
        this.nativeDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "netx-native-" + (rand & 0xFFFF));
        File parent = this.nativeDir.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            return null;
        }
        try {
            FileUtils.createRestrictedDirectory(this.nativeDir);
            this.addNativeDirectory(this.nativeDir);
            return this.nativeDir;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void addNativeDirectory(File nativeDirectory) {
        this.nativeDirectories.add(nativeDirectory);
    }

    protected List<File> getNativeDirectories() {
        return this.nativeDirectories;
    }

    @Override
    protected String findLibrary(String lib) {
        String syslib = System.mapLibraryName(lib);
        for (File dir : this.getNativeDirectories()) {
            File target = new File(dir, syslib);
            if (!target.exists()) continue;
            return target.toString();
        }
        String result = super.findLibrary(lib);
        if (result != null) {
            return result;
        }
        return this.findLibraryExt(lib);
    }

    protected String findLibraryExt(String lib) {
        for (int i = 0; i < this.loaders.length; ++i) {
            String result = null;
            if (this.loaders[i] != this) {
                result = this.loaders[i].findLibrary(lib);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void waitForJars(List jars) {
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            JARDesc jar = (JARDesc)jars.get(i);
            urls[i] = jar.getLocation();
        }
        CacheUtil.waitForResources(this.app, this.tracker, urls, this.file.getTitle());
    }

    private JarSigner verifyJars(List<JARDesc> jars) throws Exception {
        this.js = new JarSigner();
        this.js.verifyJars(jars, this.tracker);
        return this.js;
    }

    protected Class findLoadedClassAll(String name) {
        for (int i = 0; i < this.loaders.length; ++i) {
            Class result = null;
            result = this.loaders[i] == this ? super.findLoadedClass(name) : this.loaders[i].findLoadedClassAll(name);
            if (result == null) continue;
            return result;
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findLoadedClassFromParent(name);
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        Class result = this.findLoadedClassAll(name);
        if (result == null) {
            try {
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    parent = ClassLoader.getSystemClassLoader();
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = this.loadClassExt(name);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    for (String classpath : this.classpaths) {
                        JARDesc desc;
                        try {
                            URL jarUrl = new URL(this.file.getCodeBase(), classpath);
                            desc = new JARDesc(jarUrl, null, null, false, true, false, true);
                        }
                        catch (MalformedURLException mfe) {
                            throw new ClassNotFoundException(name, mfe);
                        }
                        this.addNewJar(desc);
                    }
                    result = this.loadClassExt(name);
                    return result;
                }
                catch (ClassNotFoundException cnfe1) {
                    if (JNLPRuntime.isDebug()) {
                        cnfe1.printStackTrace();
                    }
                    for (JarIndex index : this.jarIndexes) {
                        LinkedList jarList = index.get(name.replace('.', '/'));
                        if (jarList == null) continue;
                        for (String jarName : jarList) {
                            JARDesc desc;
                            try {
                                desc = new JARDesc(new URL(this.file.getCodeBase(), jarName), null, null, false, true, false, true);
                            }
                            catch (MalformedURLException mfe) {
                                throw new ClassNotFoundException(name);
                            }
                            try {
                                this.addNewJar(desc);
                            }
                            catch (Exception e) {
                                if (!JNLPRuntime.isDebug()) continue;
                                e.printStackTrace();
                            }
                        }
                        result = this.loadClassExt(name);
                    }
                }
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private void addNewJar(final JARDesc desc) {
        this.available.add(desc);
        this.tracker.addResource(desc.getLocation(), desc.getVersion(), null, JNLPRuntime.getDefaultUpdatePolicy());
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Permission p = CacheUtil.getReadPermission(desc.getLocation(), desc.getVersion());
                JNLPClassLoader.this.resourcePermissions.add(p);
                return null;
            }
        });
        final URL remoteURL = desc.getLocation();
        URL cachedUrl = this.tracker.getCacheURL(remoteURL);
        this.available.remove(desc);
        try {
            final JarSigner signer = new JarSigner();
            final ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
            jars.add(desc);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    signer.verifyJars(jars, JNLPClassLoader.this.tracker);
                    if (signer.anyJarsSigned() && !signer.getAlreadyTrustPublisher()) {
                        JNLPClassLoader.this.checkTrustWithUser(signer);
                    }
                    SecurityDesc security = signer.anyJarsSigned() ? new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.ALL_PERMISSIONS, JNLPClassLoader.this.file.getCodeBase().getHost()) : new SecurityDesc(JNLPClassLoader.this.file, SecurityDesc.SANDBOX_PERMISSIONS, JNLPClassLoader.this.file.getCodeBase().getHost());
                    JNLPClassLoader.this.jarLocationSecurityMap.put(remoteURL, security);
                    return null;
                }
            });
            this.addURL(remoteURL);
            CachedJarFileCallback.getInstance().addMapping(remoteURL, cachedUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.loaders.length; ++i) {
            try {
                if (this.loaders[i] == this) {
                    return super.findClass(name);
                }
                return this.loaders[i].findClass(name);
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
        }
        if (this.codeBaseLoader != null) {
            return this.codeBaseLoader.findClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadClassExt(String name) throws ClassNotFoundException {
        this.addAvailable();
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            while (true) {
                JNLPClassLoader addedTo = null;
                try {
                    addedTo = this.addNextResource();
                }
                catch (LaunchException e) {
                    throw new IllegalStateException(e);
                }
                if (addedTo == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return addedTo.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public URL findResource(String name) {
        URL result;
        block4: {
            result = null;
            try {
                Enumeration<URL> e = this.findResources(name);
                if (e.hasMoreElements()) {
                    result = e.nextElement();
                }
            }
            catch (IOException e) {
                if (!JNLPRuntime.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        if (result == null && this.codeBaseLoader != null) {
            result = this.codeBaseLoader.findResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = this.findResourcesBySearching(name);
        try {
            while (!resources.hasMoreElements() && this.addNextResource() != null) {
                resources = this.findResourcesBySearching(name);
            }
        }
        catch (LaunchException le) {
            le.printStackTrace();
        }
        return resources;
    }

    private Enumeration<URL> findResourcesBySearching(String name) throws IOException {
        Enumeration<URL> e;
        ArrayList<URL> resources = new ArrayList<URL>();
        for (int i = 0; i < this.loaders.length; ++i) {
            e = this.loaders[i] == this ? super.findResources(name) : this.loaders[i].findResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        if (resources.isEmpty() && this.codeBaseLoader != null) {
            e = this.codeBaseLoader.findResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    public boolean resourceAvailableLocally(String s) {
        return this.jarEntries.contains(s);
    }

    protected void addAvailable() {
        for (int i = 1; i < this.loaders.length; ++i) {
            this.loaders[i].addAvailable();
        }
    }

    protected JNLPClassLoader addNextResource() throws LaunchException {
        if (this.available.size() == 0) {
            for (int i = 1; i < this.loaders.length; ++i) {
                JNLPClassLoader result = this.loaders[i].addNextResource();
                if (result == null) continue;
                return result;
            }
            return null;
        }
        ArrayList<JARDesc> jars = new ArrayList<JARDesc>();
        jars.add(this.available.get(0));
        this.fillInPartJars(jars);
        this.checkForMain(jars);
        this.activateJars(jars);
        return this;
    }

    @Deprecated
    public String getExtensionName() {
        String result = this.file.getInformation().getTitle();
        if (result == null) {
            result = this.file.getInformation().getDescription();
        }
        if (result == null && this.file.getFileLocation() != null) {
            result = this.file.getFileLocation().toString();
        }
        if (result == null && this.file.getCodeBase() != null) {
            result = this.file.getCodeBase().toString();
        }
        return result;
    }

    @Deprecated
    public String getExtensionHREF() {
        return this.file.getFileLocation().toString();
    }

    public boolean getSigning() {
        return this.signing;
    }

    protected SecurityDesc getSecurity() {
        return this.security;
    }

    protected SecurityDesc getCodeSourceSecurity(URL source) {
        return this.jarLocationSecurityMap.get(source);
    }

    private void merge(JNLPClassLoader extLoader) {
        try {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        catch (SecurityException se) {
            throw new SecurityException("JNLPClassLoader() may only be called from trusted sources!");
        }
        for (URL u : extLoader.getURLs()) {
            this.addURL(u);
        }
        this.addToCodeBaseLoader(extLoader.file.getCodeBase());
        for (File nativeDirectory : extLoader.getNativeDirectories()) {
            this.addNativeDirectory(nativeDirectory);
        }
        for (URL key : extLoader.jarLocationSecurityMap.keySet()) {
            this.jarLocationSecurityMap.put(key, extLoader.jarLocationSecurityMap.get(key));
        }
    }

    private void addToCodeBaseLoader(URL u) {
        if (u == null) {
            return;
        }
        if (!u.getFile().endsWith("/")) {
            throw new IllegalArgumentException("addToPathLoader only accepts path based URLs");
        }
        if (this.codeBaseLoader == null) {
            this.codeBaseLoader = new CodeBaseClassLoader(new URL[]{u}, this);
        } else {
            this.codeBaseLoader.addURL(u);
        }
    }

    private DownloadOptions getDownloadOptionsForJar(JARDesc jar) {
        return this.file.getDownloadOptionsForJar(jar);
    }

    private Set<String> getClassPathsFromManifest(Manifest mf, String originalJarPath) {
        HashSet<String> result = new HashSet<String>();
        if (mf != null) {
            String[] paths;
            String classpath = mf.getMainAttributes().getValue("Class-Path");
            if (classpath == null || classpath.trim().length() == 0) {
                return result;
            }
            for (String path : paths = classpath.split(" +")) {
                if (path.trim().length() == 0) continue;
                String dir = "";
                int lastSlash = originalJarPath.lastIndexOf("/");
                if (lastSlash != -1) {
                    dir = originalJarPath.substring(0, lastSlash + 1);
                }
                String fullPath = dir + path;
                result.add(fullPath);
            }
        }
        return result;
    }

    private synchronized void incrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        ++this.useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decrementLoaderUseCount() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        --this.useCount;
        if (this.useCount <= 0) {
            Map<String, JNLPClassLoader> map = urlToLoader;
            synchronized (map) {
                urlToLoader.remove(this.file.getUniqueKey());
            }
        }
    }

    public static class CodeBaseClassLoader
    extends URLClassLoader {
        JNLPClassLoader parentJNLPClassLoader;

        public CodeBaseClassLoader(URL[] urls, JNLPClassLoader cl) {
            super(urls);
            this.parentJNLPClassLoader = cl;
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        public Class<?> findLoadedClassFromParent(String name) {
            return this.findLoadedClass(name);
        }

        public JNLPClassLoader getParentJNLPClassLoader() {
            return this.parentJNLPClassLoader;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            if (!name.startsWith("META-INF")) {
                return super.findResources(name);
            }
            return new Vector(0).elements();
        }

        @Override
        public URL findResource(String name) {
            if (!name.startsWith("META-INF")) {
                return super.findResource(name);
            }
            return null;
        }
    }
}

