/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.BasicExceptionDialog;

public class GuiLaunchHandler
implements LaunchHandler {
    private JNLPSplashScreen splashScreen = null;
    private final Object mutex = new Object();
    private UpdatePolicy policy = UpdatePolicy.ALWAYS;

    @Override
    public void launchCompleted(ApplicationInstance application) {
    }

    @Override
    public void launchError(final LaunchException exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
                BasicExceptionDialog.show(exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSplashScreen() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.splashScreen != null) {
                if (this.splashScreen.isSplashScreenValid()) {
                    this.splashScreen.setVisible(false);
                }
                this.splashScreen.dispose();
            }
        }
    }

    @Override
    public void launchStarting(ApplicationInstance application) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchInitialized(JNLPFile file) {
        int preferredWidth = 500;
        int preferredHeight = 400;
        final URL splashImageURL = file.getInformation().getIconLocation(IconDesc.SPLASH, preferredWidth, preferredHeight);
        if (splashImageURL != null) {
            final ResourceTracker resourceTracker = new ResourceTracker(true);
            resourceTracker.addResource(splashImageURL, file.getFileVersion(), null, this.policy);
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            GuiLaunchHandler.this.splashScreen = new JNLPSplashScreen(resourceTracker, null, null);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    while (this.splashScreen == null) {
                    }
                }
                catch (InvocationTargetException ite) {
                    ite.printStackTrace();
                }
                this.splashScreen.setSplashImageURL(splashImageURL);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (splashImageURL != null) {
                    Object object = GuiLaunchHandler.this.mutex;
                    synchronized (object) {
                        if (GuiLaunchHandler.this.splashScreen.isSplashScreenValid()) {
                            GuiLaunchHandler.this.splashScreen.setVisible(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean launchWarning(LaunchException warning) {
        DefaultLaunchHandler.printMessage(warning);
        return true;
    }

    @Override
    public boolean validationError(LaunchException security) {
        this.closeSplashScreen();
        DefaultLaunchHandler.printMessage(security);
        return true;
    }
}

