/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.JniHelper;
import gnu.classpath.tools.javah.JniPrintStream;
import gnu.classpath.tools.javah.Main;
import gnu.classpath.tools.javah.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class JniIncludePrinter
extends Printer {
    protected JniIncludePrinter(Main classpath, File outFile, boolean isDir, boolean force) {
        super(classpath, outFile, isDir, force);
    }

    private void writeFields(ClassWrapper klass, JniPrintStream out) throws IOException {
        klass.linkSupers();
        boolean wroteAny = false;
        while (klass != null) {
            for (FieldNode field : klass.fields) {
                if (!Modifier.isStatic(field.access) || !Modifier.isFinal(field.access) || !(field.value instanceof Integer) && !(field.value instanceof Long)) continue;
                String name = String.valueOf(JniHelper.mangle(klass.name)) + "_" + field.name;
                out.print("#undef ");
                out.println(name);
                out.print("#define ");
                out.print(name);
                out.print(" ");
                out.print(field.value);
                if (field.value instanceof Integer) {
                    out.print("L");
                } else if (field.value instanceof Long) {
                    out.print("LL");
                }
                out.println();
                wroteAny = true;
            }
            klass = klass.superClass;
        }
        if (wroteAny) {
            out.println();
        }
    }

    protected void writePreambleImpl(PrintStream out) {
        out.println("/* DO NOT EDIT THIS FILE - it is machine generated */");
        out.println();
        out.println("#include <jni.h>");
    }

    protected PrintStream getPrintStreamImpl(FileOutputStream fos, ClassWrapper klass) {
        return new JniPrintStream(this.classpath, fos, klass);
    }

    public void printClass(File file, ClassWrapper klass) throws IOException {
        String xname = JniHelper.mangle(klass.name);
        String filename = klass.name;
        filename = filename.replace('/', '_');
        filename = filename.replace('$', '_');
        JniPrintStream out = (JniPrintStream)this.getPrintStream(filename = String.valueOf(filename) + ".h", klass);
        if (out == null) {
            return;
        }
        out.println();
        out.print("#ifndef __");
        out.print(xname);
        out.println("__");
        out.print("#define __");
        out.print(xname);
        out.println("__");
        out.println();
        out.println("#ifdef __cplusplus");
        out.println("extern \"C\"");
        out.println("{");
        out.println("#endif");
        out.println();
        for (MethodNode method : klass.methods) {
            if (!Modifier.isNative(method.access)) continue;
            out.print("JNIEXPORT ");
            out.print(Type.getReturnType(method.desc));
            out.print(" JNICALL ");
            out.print(method, xname);
            out.println(";");
        }
        out.println();
        this.writeFields(klass, out);
        out.println("#ifdef __cplusplus");
        out.println("}");
        out.println("#endif");
        out.println();
        out.print("#endif /* __");
        out.print(xname);
        out.println("__ */");
        out.close();
    }
}

