/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.ClassDocProxy;
import gnu.classpath.tools.gjdoc.ClassDocReflectedImpl;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.DocImpl;
import gnu.classpath.tools.gjdoc.ErrorReporter;
import gnu.classpath.tools.gjdoc.GjdocRootDoc;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.PackageDocImpl;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.Parser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RootDocImpl
extends DocImpl
implements GjdocRootDoc {
    private ErrorReporter reporter = new ErrorReporter();
    private RandomAccessFile rawCommentCache;
    private String[][] customOptionArr;
    private List specifiedSourceFiles = new LinkedList();
    private Set specifiedPackageNames = new LinkedHashSet();
    private List classesList = new LinkedList();
    private Map classDocMap = new HashMap();
    private Map packageDocMap = new HashMap();
    private ClassDocImpl[] classes;
    private List specifiedClasses;
    private Set specifiedPackages;
    private List scheduledClasses = new LinkedList();
    private List sourcePath;
    private String sourceEncoding;
    private Parser parser = new Parser();
    private Set unlocatableReportedSet = new HashSet();
    private Set inaccessibleReportedSet = new HashSet();
    private List unlocatablePrefixes = new LinkedList();
    private Map resolvedImportCache = new HashMap();
    private Set unlocatableReflectedClassNames = new HashSet();
    public static boolean recursiveClasses = false;

    public ClassDoc[] classes() {
        return this.classes;
    }

    public ClassDoc classNamed(String qualifiedName) {
        return (ClassDoc)this.classDocMap.get(qualifiedName);
    }

    public String[][] options() {
        return this.customOptionArr;
    }

    public PackageDoc packageNamed(String name) {
        return (PackageDoc)this.packageDocMap.get(name);
    }

    public ClassDoc[] specifiedClasses() {
        return this.specifiedClasses.toArray(new ClassDocImpl[0]);
    }

    public PackageDoc[] specifiedPackages() {
        return this.specifiedPackages.toArray(new PackageDocImpl[0]);
    }

    public void printError(String msg) {
        this.reporter.printError(msg);
    }

    public void printFatal(String msg) {
        this.reporter.printFatal(msg);
    }

    public void printNotice(String msg) {
        this.reporter.printNotice(msg);
    }

    public void printWarning(String msg) {
        this.reporter.printWarning(msg);
    }

    public String name() {
        return "RootDoc";
    }

    public ErrorReporter getReporter() {
        return this.reporter;
    }

    public void build() throws ParseException, IOException {
        File rawCommentCacheFile = new File("gjdoc_rawcomment.cache");
        rawCommentCacheFile.deleteOnExit();
        this.rawCommentCache = new RandomAccessFile(rawCommentCacheFile, "rw");
        List javaLangSourceDirs = this.findSourceFiles("java/lang");
        if (!javaLangSourceDirs.isEmpty()) {
            for (File javaLangSourceDir : javaLangSourceDirs) {
                this.parser.processSourceDir(javaLangSourceDir, this.sourceEncoding, "java.lang");
            }
        } else {
            Debug.log(1, "Sourcepath is " + this.sourcePath);
        }
        for (String specifiedPackageName : this.specifiedPackageNames) {
            String displayPackageName = specifiedPackageName;
            if (displayPackageName == null || displayPackageName.length() == 0) {
                displayPackageName = "<unnamed>";
            }
            this.printNotice("Loading classes for package " + displayPackageName + "...");
            String relPath = specifiedPackageName != null ? specifiedPackageName.replace('.', File.separatorChar) : "";
            List sourceDirs = this.findSourceFiles(relPath);
            if (!sourceDirs.isEmpty()) {
                for (File sourceDir : sourceDirs) {
                    this.parser.processSourceDir(sourceDir, this.sourceEncoding, specifiedPackageName);
                }
                continue;
            }
            this.printError("Package '" + specifiedPackageName + "' not found.");
        }
        this.specifiedClasses = new LinkedList();
        for (File specifiedSourceFile : this.specifiedSourceFiles) {
            this.printNotice("Loading source file " + specifiedSourceFile + " ...");
            ClassDocImpl classDoc = this.parser.processSourceFile(specifiedSourceFile, true, this.sourceEncoding, null);
            if (classDoc == null) continue;
            this.specifiedClasses.add(classDoc);
            this.classesList.add(classDoc);
            classDoc.setIsIncluded(true);
            this.addPackageDoc(classDoc.containingPackage());
        }
        this.printNotice("Constructing Javadoc information...");
        this.loadScheduledClasses(this.parser);
        this.printNotice("Resolving references in comments...");
        this.resolveComments();
        this.printNotice("Resolving references in classes...");
        for (ClassDoc cd : this.classDocMap.values()) {
            if (!(cd instanceof ClassDocImpl)) continue;
            ((ClassDocImpl)cd).resolve();
        }
        this.printNotice("Resolving references in packages...");
        for (PackageDocImpl pd : this.packageDocMap.values()) {
            pd.resolve();
        }
        this.specifiedPackages = new LinkedHashSet();
        for (String specifiedPackageName : this.specifiedPackageNames) {
            PackageDoc specifiedPackageDoc = (PackageDoc)this.packageDocMap.get(specifiedPackageName);
            if (specifiedPackageDoc == null) continue;
            ((PackageDocImpl)specifiedPackageDoc).setIsIncluded(true);
            this.specifiedPackages.add(specifiedPackageDoc);
            ClassDoc[] packageClassDocs = specifiedPackageDoc.allClasses();
            int i = 0;
            while (i < packageClassDocs.length) {
                ClassDocImpl specifiedPackageClassDoc = (ClassDocImpl)packageClassDocs[i];
                specifiedPackageClassDoc.setIsIncluded(true);
                this.classesList.add(specifiedPackageClassDoc);
                ++i;
            }
        }
        this.printNotice("Resolving references in class comments...");
        for (ClassDoc cd : this.classDocMap.values()) {
            if (!(cd instanceof ClassDocImpl)) continue;
            ((ClassDocImpl)cd).resolveComments();
        }
        this.printNotice("Resolving references in package comments...");
        for (PackageDocImpl pd : this.packageDocMap.values()) {
            pd.resolveComments();
        }
        this.classes = this.classesList.toArray(new ClassDocImpl[0]);
        Arrays.sort(this.classes);
        this.parser = null;
        System.gc();
        System.gc();
    }

    public long writeRawComment(String rawComment) {
        try {
            long pos = this.rawCommentCache.getFilePointer();
            byte[] bytes = rawComment.getBytes("utf-8");
            this.rawCommentCache.writeInt(bytes.length);
            this.rawCommentCache.write(bytes);
            return pos;
        }
        catch (IOException e) {
            this.printFatal("Cannot write to comment cache: " + e.getMessage());
            return -1L;
        }
    }

    public String readRawComment(long pos) {
        try {
            this.rawCommentCache.seek(pos);
            int sz = this.rawCommentCache.readInt();
            byte[] bytes = new byte[sz];
            this.rawCommentCache.read(bytes);
            return new String(bytes, "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.printFatal("Cannot read from comment cache: " + e.getMessage());
            return null;
        }
    }

    List findSourceFiles(String relPath) {
        LinkedList<File> result = new LinkedList<File>();
        for (File path : this.sourcePath) {
            File file = new File(path, relPath);
            if (!file.exists()) continue;
            result.add(file);
        }
        return result;
    }

    PackageDocImpl findOrCreatePackageDoc(String packageName) {
        PackageDocImpl rc = this.getPackageDoc(packageName);
        if (rc == null) {
            rc = new PackageDocImpl(packageName);
            if (this.specifiedPackageNames.contains(packageName)) {
                String packageDirectoryName = packageName.replace('.', File.separatorChar);
                List packageDirectories = this.findSourceFiles(packageDirectoryName);
                Iterator it = packageDirectories.iterator();
                boolean packageDocFound = false;
                while (it.hasNext()) {
                    File packageDirectory = (File)it.next();
                    File packageDocFile = new File(packageDirectory, "package.html");
                    rc.setPackageDirectory(packageDirectory);
                    packageDocFound = true;
                    if (packageDocFile == null || !packageDocFile.exists()) continue;
                    try {
                        rc.setRawCommentText(RootDocImpl.readHtmlBody(packageDocFile));
                    }
                    catch (IOException e) {
                        this.printWarning("Error while reading documentation for package " + packageName + ": " + e.getMessage());
                    }
                    break;
                }
                if (!packageDocFound) {
                    this.printNotice("No description found for package " + packageName);
                }
            }
            this.addPackageDoc(rc);
        }
        return rc;
    }

    public void addClassDoc(ClassDoc cd) {
        this.classDocMap.put(cd.qualifiedName(), cd);
    }

    public void addClassDocRecursive(ClassDoc cd) {
        this.classDocMap.put(cd.qualifiedName(), cd);
        ClassDoc[] innerClasses = cd.innerClasses(false);
        int i = 0;
        while (i < innerClasses.length) {
            this.addClassDocRecursive(innerClasses[i]);
            ++i;
        }
    }

    public void addPackageDoc(PackageDoc pd) {
        this.packageDocMap.put(pd.name(), pd);
    }

    public PackageDocImpl getPackageDoc(String name) {
        return (PackageDocImpl)this.packageDocMap.get(name);
    }

    public ClassDocImpl getClassDoc(String qualifiedName) {
        return (ClassDocImpl)this.classDocMap.get(qualifiedName);
    }

    public void scheduleClass(ClassDoc context, String qualifiedName) throws ParseException, IOException {
        if (this.classDocMap.get(qualifiedName) == null) {
            this.scheduledClasses.add(new ScheduledClass(context, qualifiedName));
        }
    }

    public void loadScheduledClasses(Parser parser) throws ParseException, IOException {
        while (!this.scheduledClasses.isEmpty()) {
            ScheduledClass[] scheduledClassesArr = this.scheduledClasses.toArray(new ScheduledClass[0]);
            this.scheduledClasses.clear();
            int i = 0;
            while (i < scheduledClassesArr.length) {
                String scheduledClassName = scheduledClassesArr[i].qualifiedName;
                ClassDoc scheduledClassContext = scheduledClassesArr[i].contextClass;
                if (this.classDocMap.get(scheduledClassName) == null) {
                    try {
                        this.loadScheduledClass(parser, scheduledClassName, scheduledClassContext);
                    }
                    catch (ParseException parseException) {
                        this.printWarning("Couldn't load class " + scheduledClassName + " referenced by " + scheduledClassContext);
                    }
                }
                ++i;
            }
        }
    }

    private void loadScheduledClass(Parser parser, String scheduledClassName, ClassDoc scheduledClassContext) throws ParseException, IOException {
        ClassDoc loadedClass = scheduledClassContext.findClass(scheduledClassName);
        if (loadedClass == null || loadedClass instanceof ClassDocProxy) {
            ClassDoc classDoc = this.findScheduledClassFile(scheduledClassName, scheduledClassContext);
            if (classDoc != null) {
                if (classDoc instanceof ClassDocReflectedImpl) {
                    Main.getRootDoc().addClassDocRecursive(classDoc);
                }
                if (classDoc.superclass() != null && classDoc.superclass() instanceof ClassDocProxy) {
                    this.scheduleClass(classDoc, classDoc.superclass().qualifiedName());
                }
            } else {
                boolean filesWereProcessed;
                boolean retryLater = false;
                int numberOfProcessedFilesBefore = parser.getNumberOfProcessedFiles();
                ClassDoc cc = scheduledClassContext.containingClass();
                while (cc != null && !retryLater) {
                    ClassDoc sc = cc.superclass();
                    while (sc != null && !retryLater) {
                        if (sc instanceof ClassDocProxy) {
                            ((ClassDocImpl)cc).resolve();
                            retryLater = true;
                        }
                        sc = sc.superclass();
                    }
                    cc = cc.containingClass();
                }
                loadedClass = scheduledClassContext.findClass(scheduledClassName);
                int numberOfProcessedFilesAfter = parser.getNumberOfProcessedFiles();
                boolean bl = filesWereProcessed = numberOfProcessedFilesAfter > numberOfProcessedFilesBefore;
                if (loadedClass == null && retryLater && filesWereProcessed) {
                    this.scheduleClass(scheduledClassContext, scheduledClassName);
                }
            }
        }
    }

    private ClassDoc getInnerClass(ClassDoc topLevelClass, String innerClassName) {
        StringTokenizer st = new StringTokenizer(innerClassName, ".");
        block0: while (st.hasMoreTokens()) {
            String innerClassNameComponent = st.nextToken();
            ClassDoc[] innerClasses = topLevelClass.innerClasses();
            int i = 0;
            while (i < innerClasses.length) {
                if (innerClasses[i].name().equals(innerClassNameComponent)) {
                    topLevelClass = innerClasses[i];
                    continue block0;
                }
                ++i;
            }
            this.printWarning("Could not find inner class " + innerClassName + " in class " + topLevelClass.qualifiedName());
            return null;
        }
        return topLevelClass;
    }

    private ResolvedImport resolveImport(String importSpecifier) {
        ResolvedImport result = this.resolveImportFileSystem(importSpecifier);
        if (result == null && Main.getInstance().isReflectionEnabled()) {
            result = this.resolveImportReflection(importSpecifier);
        }
        if (result == null) {
            result = new ResolvedImportNotFound(importSpecifier);
        }
        return result;
    }

    private ResolvedImport resolveImportReflection(String importSpecifier) {
        String importedPackageOrClass = importSpecifier;
        if (importedPackageOrClass.endsWith(".*")) {
            importedPackageOrClass = importedPackageOrClass.substring(0, importedPackageOrClass.length() - 2);
            return new ResolvedImportReflectionPackage(importedPackageOrClass);
        }
        try {
            Class<?> importedClass = Class.forName(importSpecifier);
            return new ResolvedImportReflectionClass(importedClass);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ResolvedImport resolveImportFileSystem(String importSpecifier) {
        for (String unlocatablePrefix : this.unlocatablePrefixes) {
            if (!importSpecifier.startsWith(unlocatablePrefix)) continue;
            return null;
        }
        String longestUnlocatablePrefix = "";
        for (File _sourcePath : this.sourcePath) {
            StringBuffer packageOrClassPrefix = new StringBuffer();
            StringTokenizer st = new StringTokenizer(importSpecifier, ".");
            while (st.hasMoreTokens() && _sourcePath.isDirectory()) {
                String token = st.nextToken();
                if ("*".equals(token)) {
                    return new ResolvedImportPackageFile(_sourcePath, packageOrClassPrefix.substring(0, packageOrClassPrefix.length() - 1));
                }
                packageOrClassPrefix.append(token);
                packageOrClassPrefix.append('.');
                File classFile = new File(_sourcePath, String.valueOf(token) + ".java");
                if (classFile.exists()) {
                    StringBuffer innerClassName = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        if (innerClassName.length() > 0) {
                            innerClassName.append('.');
                        }
                        innerClassName.append(token);
                    }
                    return new ResolvedImportClassFile(classFile, innerClassName.toString(), token, importSpecifier);
                }
                _sourcePath = new File(_sourcePath, token);
            }
            if (!st.hasMoreTokens() || packageOrClassPrefix.length() <= longestUnlocatablePrefix.length()) continue;
            longestUnlocatablePrefix = packageOrClassPrefix.toString();
        }
        if (longestUnlocatablePrefix.length() > 0) {
            this.unlocatablePrefixes.add(longestUnlocatablePrefix);
        }
        return null;
    }

    private ResolvedImport getResolvedImport(String importSpecifier) {
        ResolvedImport result = (ResolvedImport)this.resolvedImportCache.get(importSpecifier);
        if (result == null) {
            result = this.resolveImport(importSpecifier);
            this.resolvedImportCache.put(importSpecifier, result);
        }
        return result;
    }

    public String resolveClassName(String className, ClassDocImpl context) {
        for (String importSpecifier : context.getImportSpecifierList()) {
            ResolvedImport resolvedImport = this.getResolvedImport(importSpecifier);
            String resolvedScheduledClassName = resolvedImport.match(className);
            if (resolvedScheduledClassName == null) continue;
            return resolvedScheduledClassName;
        }
        return className;
    }

    public ClassDoc findScheduledClassFile(String scheduledClassName, ClassDoc scheduledClassContext) throws ParseException, IOException {
        String resolvedScheduledClassName = null;
        if (scheduledClassContext instanceof ClassDocImpl) {
            for (String importSpecifier : ((ClassDocImpl)scheduledClassContext).getImportSpecifierList()) {
                ResolvedImport resolvedImport = this.getResolvedImport(importSpecifier);
                resolvedScheduledClassName = resolvedImport.match(scheduledClassName);
                if (resolvedScheduledClassName == null) continue;
                ClassDoc result = resolvedImport.tryFetch(scheduledClassName);
                if (result != null) {
                    return result;
                }
                if (!this.inaccessibleReportedSet.contains(scheduledClassName)) {
                    this.inaccessibleReportedSet.add(scheduledClassName);
                    this.printWarning("Error while loading class " + scheduledClassName);
                }
                return null;
            }
        } else {
            System.err.println("findScheduledClassFile for '" + scheduledClassName + "' in proxy for " + scheduledClassContext);
        }
        ResolvedImport fqImport = this.resolveImportFileSystem(scheduledClassName);
        if (fqImport != null && fqImport instanceof ResolvedImportClassFile) {
            return fqImport.tryFetch(((ResolvedImportClassFile)fqImport).getName());
        }
        if (!this.unlocatableReflectedClassNames.contains(scheduledClassName)) {
            if (Main.getInstance().isReflectionEnabled()) {
                try {
                    Class<?> clazz = Class.forName(scheduledClassName);
                    this.printWarning("Cannot locate class " + scheduledClassName + " on file system, falling back to reflection.");
                    ClassDocReflectedImpl result = new ClassDocReflectedImpl(clazz);
                    return result;
                }
                catch (Throwable throwable) {
                    this.unlocatableReflectedClassNames.add(scheduledClassName);
                }
            } else {
                this.unlocatableReflectedClassNames.add(scheduledClassName);
            }
        }
        if (resolvedScheduledClassName == null) {
            resolvedScheduledClassName = scheduledClassName;
        }
        if (!this.unlocatableReportedSet.contains(resolvedScheduledClassName)) {
            this.unlocatableReportedSet.add(resolvedScheduledClassName);
            this.printWarning("Cannot locate class " + resolvedScheduledClassName + " referenced in class " + scheduledClassContext.qualifiedName());
        }
        return null;
    }

    public void addSpecifiedPackageName(String packageName) {
        this.specifiedPackageNames.add(packageName);
    }

    public void addSpecifiedSourceFile(File sourceFile) {
        this.specifiedSourceFiles.add(sourceFile);
    }

    public boolean hasSpecifiedPackagesOrClasses() {
        return !this.specifiedPackageNames.isEmpty() || !this.specifiedSourceFiles.isEmpty();
    }

    public void setOptions(String[][] customOptionArr) {
        this.customOptionArr = customOptionArr;
    }

    public void setSourcePath(List sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void flush() {
        try {
            this.rawCommentCache.close();
        }
        catch (IOException iOException) {
            this.printError("Cannot close raw comment cache");
        }
        this.rawCommentCache = null;
        this.customOptionArr = null;
        this.specifiedPackageNames = null;
        this.classesList = null;
        this.classDocMap = null;
        this.packageDocMap = null;
        this.classes = null;
        this.specifiedClasses = null;
        this.specifiedPackages = null;
        this.scheduledClasses = null;
        this.sourcePath = null;
        this.parser = null;
        this.unlocatableReportedSet = null;
        this.inaccessibleReportedSet = null;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public RootDocImpl() {
        super(null);
    }

    public static String readHtmlBody(File file) throws IOException {
        int end;
        FileReader fr = new FileReader(file);
        long size = file.length();
        char[] packageDocBuf = new char[(int)size];
        int index = 0;
        int i = fr.read(packageDocBuf, index, (int)size);
        while (i > 0) {
            i = fr.read(packageDocBuf, index += i, (int)(size -= (long)i));
        }
        fr.close();
        String html = new String(packageDocBuf);
        int start = html.indexOf("<body");
        if (start == -1) {
            start = html.indexOf("<BODY");
        }
        if ((end = html.indexOf("</body>")) == -1) {
            end = html.indexOf("</BODY>");
        }
        if (start != -1 && end != -1 && (start = html.indexOf(62, start) + 1) != -1 && start < end) {
            html = html.substring(start, end);
        }
        return html.trim();
    }

    public Parser getParser() {
        return this.parser;
    }

    private static interface ResolvedImport {
        public String match(String var1);

        public boolean mismatch(String var1);

        public ClassDoc tryFetch(String var1);
    }

    private class ResolvedImportClassFile
    implements ResolvedImport {
        private File classFile;
        private String innerClassName;
        private String name;
        private ClassDoc classDoc;
        private boolean alreadyFetched;
        private String qualifiedName;

        ResolvedImportClassFile(File classFile, String innerClassName, String name, String qualifiedName) {
            this.classFile = classFile;
            this.innerClassName = innerClassName;
            this.name = name;
            this.qualifiedName = qualifiedName;
        }

        public String toString() {
            return "ResolvedImportClassFile{" + this.classFile + "," + this.innerClassName + "}";
        }

        public String match(String name) {
            String topLevelName = name;
            int ndx = topLevelName.indexOf(46);
            String _innerClassName = null;
            if (ndx > 0) {
                _innerClassName = topLevelName.substring(ndx + 1);
                topLevelName = topLevelName.substring(0, ndx);
            }
            if (this.name.equals(topLevelName)) {
                if (_innerClassName == null) {
                    return this.qualifiedName;
                }
                return String.valueOf(this.qualifiedName) + "." + _innerClassName;
            }
            return null;
        }

        public boolean mismatch(String name) {
            return this.match(name) == null;
        }

        public ClassDoc tryFetch(String name) {
            if (this.match(name) != null) {
                ClassDoc topLevelClass = null;
                if (this.alreadyFetched) {
                    topLevelClass = this.classDoc;
                } else {
                    this.alreadyFetched = true;
                    try {
                        topLevelClass = RootDocImpl.this.parser.processSourceFile(this.classFile, false, RootDocImpl.this.sourceEncoding, null);
                    }
                    catch (Exception exception) {
                        RootDocImpl.this.printWarning("Could not parse source file " + this.classFile);
                    }
                }
                if (topLevelClass == null) {
                    return null;
                }
                return RootDocImpl.this.getInnerClass(topLevelClass, this.innerClassName);
            }
            return null;
        }

        public String getName() {
            if (this.innerClassName != null) {
                return String.valueOf(this.name) + this.innerClassName;
            }
            return this.name;
        }
    }

    private class ResolvedImportNotFound
    implements ResolvedImport {
        private String importSpecifier;
        private String name;

        ResolvedImportNotFound(String importSpecifier) {
            this.importSpecifier = importSpecifier;
            int ndx = importSpecifier.lastIndexOf(46);
            this.name = ndx >= 0 ? importSpecifier.substring(ndx + 1) : importSpecifier;
        }

        public String toString() {
            return "ResolvedImportNotFound{" + this.importSpecifier + "}";
        }

        public String match(String name) {
            if (name.equals(this.name) || this.importSpecifier.equals(name)) {
                return this.name;
            }
            return null;
        }

        public boolean mismatch(String name) {
            return true;
        }

        public ClassDoc tryFetch(String name) {
            return null;
        }
    }

    private class ResolvedImportPackageFile
    implements ResolvedImport {
        private Set topLevelClassNames;
        private File packageFile;
        private String packageName;
        private Map cache = new HashMap();

        ResolvedImportPackageFile(File packageFile, String packageName) {
            this.packageFile = packageFile;
            this.packageName = packageName;
            this.topLevelClassNames = new HashSet();
            File[] files = packageFile.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory() && files[i].getName().endsWith(".java")) {
                    String topLevelClassName = files[i].getName();
                    topLevelClassName = topLevelClassName.substring(0, topLevelClassName.length() - 5);
                    this.topLevelClassNames.add(topLevelClassName);
                }
                ++i;
            }
        }

        public String match(String name) {
            ClassDoc loadedClass = RootDocImpl.this.classNamed(String.valueOf(this.packageName) + "." + name);
            if (loadedClass != null) {
                return loadedClass.qualifiedName();
            }
            String topLevelName = name;
            int ndx = topLevelName.indexOf(46);
            if (ndx > 0) {
                topLevelName.substring(ndx + 1);
                topLevelName = topLevelName.substring(0, ndx);
            }
            if (this.topLevelClassNames.contains(topLevelName)) {
                return String.valueOf(this.packageName) + "." + name;
            }
            return null;
        }

        public boolean mismatch(String name) {
            return this.match(name) == null;
        }

        public ClassDoc tryFetch(String name) {
            ClassDoc loadedClass = RootDocImpl.this.classNamed(String.valueOf(this.packageName) + "." + name);
            if (loadedClass != null) {
                return loadedClass;
            }
            if (this.match(name) != null) {
                ClassDoc topLevelClass;
                String topLevelName = name;
                int ndx = topLevelName.indexOf(46);
                String innerClassName = null;
                if (ndx > 0) {
                    innerClassName = topLevelName.substring(ndx + 1);
                    topLevelName = topLevelName.substring(0, ndx);
                }
                if ((topLevelClass = (ClassDoc)this.cache.get(topLevelName)) == null) {
                    File classFile = new File(this.packageFile, String.valueOf(topLevelName) + ".java");
                    try {
                        topLevelClass = RootDocImpl.this.parser.processSourceFile(classFile, false, RootDocImpl.this.sourceEncoding, null);
                    }
                    catch (Exception exception) {
                        RootDocImpl.this.printWarning("Could not parse source file " + classFile);
                    }
                    this.cache.put(topLevelName, topLevelClass);
                }
                if (innerClassName == null) {
                    return topLevelClass;
                }
                return RootDocImpl.this.getInnerClass(topLevelClass, innerClassName);
            }
            return null;
        }

        public String toString() {
            return "ResolvedImportPackageFile{" + this.packageFile + "," + this.packageName + "}";
        }
    }

    private class ResolvedImportReflectionClass
    implements ResolvedImport {
        private Class clazz;
        private String name;

        ResolvedImportReflectionClass(Class clazz) {
            this.clazz = clazz;
            String className = clazz.getName();
            int ndx = className.lastIndexOf(46);
            this.name = ndx >= 0 ? className.substring(ndx + 1) : className;
        }

        public String toString() {
            return "ResolvedImportReflectionClass{" + this.clazz.getName() + "}";
        }

        public String match(String name) {
            if (this.name.equals(name) || this.clazz.getName().equals(name)) {
                return this.clazz.getName();
            }
            return null;
        }

        public boolean mismatch(String name) {
            return this.match(name) == null;
        }

        public ClassDoc tryFetch(String name) {
            if (this.match(name) != null) {
                return new ClassDocReflectedImpl(this.clazz);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    private class ResolvedImportReflectionPackage
    implements ResolvedImport {
        private String packagePrefix;

        ResolvedImportReflectionPackage(String packagePrefix) {
            this.packagePrefix = packagePrefix;
        }

        public String toString() {
            return "ResolvedImportReflectionPackage{" + this.packagePrefix + ".*}";
        }

        public String match(String name) {
            try {
                Class<?> clazz = Class.forName(String.valueOf(this.packagePrefix) + "." + name);
                return clazz.getName();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean mismatch(String name) {
            return this.match(name) == null;
        }

        public ClassDoc tryFetch(String name) {
            try {
                Class<?> clazz = Class.forName(String.valueOf(this.packagePrefix) + name);
                return ClassDocReflectedImpl.newInstance(clazz);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getName() {
            return this.packagePrefix;
        }
    }

    class ScheduledClass {
        ClassDoc contextClass;
        String qualifiedName;

        ScheduledClass(ClassDoc contextClass, String qualifiedName) {
            this.contextClass = contextClass;
            this.qualifiedName = qualifiedName;
        }

        public String toString() {
            return "ScheduledClass{" + this.qualifiedName + "}";
        }
    }
}

