/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListModel
extends AbstractListModel {
    private static final long serialVersionUID = 2315945659722172272L;
    private Vector elements = new Vector();

    public Object elementAt(int index) {
        return this.elements.elementAt(index);
    }

    public String toString() {
        return this.elements.toString();
    }

    public int indexOf(Object element) {
        return this.elements.indexOf(element);
    }

    public int indexOf(Object element, int startIndex) {
        return this.elements.indexOf(element, startIndex);
    }

    public int lastIndexOf(Object element) {
        return this.elements.lastIndexOf(element);
    }

    public int lastIndexOf(Object element, int endIndex) {
        return this.elements.lastIndexOf(element, endIndex);
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public Object set(int index, Object element) {
        Object result = this.elements.set(index, element);
        this.fireContentsChanged(this, index, index);
        return result;
    }

    public void add(int index, Object element) {
        this.elements.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElement(Object element) {
        int s = this.elements.size();
        this.elements.add(element);
        this.fireIntervalAdded(this, s, s);
    }

    public int size() {
        return this.elements.size();
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public boolean contains(Object element) {
        return this.elements.contains(element);
    }

    public void copyInto(Object[] array) {
        this.elements.copyInto(array);
    }

    public void clear() {
        int s = this.elements.size();
        if (s > 0) {
            this.elements.clear();
            this.fireIntervalRemoved(this, 0, s - 1);
        }
    }

    public Object remove(int index) {
        Object result = this.elements.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return result;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Enumeration<?> elements() {
        return this.elements.elements();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public void ensureCapacity(int size) {
        this.elements.ensureCapacity(size);
    }

    public void setSize(int size) {
        int oldSize = this.elements.size();
        this.elements.setSize(size);
        if (oldSize < size) {
            this.fireIntervalAdded(this, oldSize, size - 1);
        } else if (oldSize > size) {
            this.fireIntervalRemoved(this, size, oldSize - 1);
        }
    }

    public int capacity() {
        return this.elements.capacity();
    }

    public Object firstElement() {
        return this.elements.firstElement();
    }

    public Object lastElement() {
        return this.elements.lastElement();
    }

    public void setElementAt(Object element, int index) {
        this.elements.setElementAt(element, index);
        this.fireContentsChanged(this, index, index);
    }

    public void removeElementAt(int index) {
        this.elements.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void insertElementAt(Object element, int index) {
        this.elements.insertElementAt(element, index);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean removeElement(Object element) {
        int index = this.elements.indexOf(element);
        if (index != -1) {
            this.elements.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        int size = this.size();
        if (size > 0) {
            this.elements.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void removeRange(int startIndex, int endIndex) {
        if (startIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        int index = endIndex;
        while (index >= startIndex) {
            this.elements.remove(index);
            --index;
        }
        this.fireIntervalRemoved(this, startIndex, endIndex);
    }

    @Override
    public int getSize() {
        return this.elements.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.elements.get(index);
    }
}

