/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
extends MenuComponent
implements Serializable,
Accessible {
    private static transient long next_menuitem_number;
    private static final long serialVersionUID = -21757335363267194L;
    String actionCommand;
    boolean enabled = true;
    long eventMask;
    String label = "";
    private MenuShortcut shortcut;
    private transient ActionListener action_listeners;

    public MenuItem() {
    }

    public MenuItem(String label) {
        this.label = label;
    }

    public MenuItem(String label, MenuShortcut shortcut) {
        this.label = label;
        this.shortcut = shortcut;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            MenuItemPeer mp = (MenuItemPeer)this.peer;
            mp.setLabel(label);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enable(enabled);
    }

    public void enable(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(true);
        }
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(false);
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    protected final void enableEvents(long events) {
        this.eventMask |= events;
    }

    protected final void disableEvents(long events) {
        this.eventMask &= events ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createMenuItem(this);
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
        this.enableEvents(128L);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.action_listeners, ActionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ActionListener.class) {
            return this.getActionListeners();
        }
        return (EventListener[])Array.newInstance(listenerType, 0);
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(e);
        }
        if (!e.isConsumed()) {
            ((Menu)this.getParent()).processEvent(e);
        }
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            event.setSource(this);
            this.action_listeners.actionPerformed(event);
        }
    }

    @Override
    public String paramString() {
        return "label=" + this.label + ",enabled=" + this.enabled + ",actionCommand=" + this.actionCommand + "," + super.paramString();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "menuitem" + MenuItem.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_menuitem_number++;
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -217847831945965825L;

        protected AccessibleAWTMenuItem() {
            super(MenuItem.this);
        }

        public String getAccessibleName() {
            return MenuItem.this.label;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return MenuItem.this.label;
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            if (i != 0) {
                return false;
            }
            MenuItem.this.processActionEvent(new ActionEvent(this, 1001, MenuItem.this.actionCommand));
            return true;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return MenuItem.this.enabled ? new Integer(1) : new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            boolean result = number.intValue() != 0;
            this.setEnabled(result);
            return result;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }
    }
}

