/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.dssi;

import gnu.javax.sound.midi.dssi.DSSISynthesizer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class DSSIMidiDeviceProvider
extends MidiDeviceProvider {
    private static DSSIInfo[] infos;

    static {
        File dssidir = new File("/usr/lib/dssi/");
        String[] sofiles = dssidir.list(new FilenameFilter(){

            public boolean accept(File dir, String n) {
                return n.endsWith(".so");
            }
        });
        ArrayList ilist = new ArrayList();
        int i = 0;
        while (i < sofiles.length) {
            ilist.addAll(DSSIMidiDeviceProvider.examineLibrary(new File(dssidir, sofiles[i]).getAbsolutePath()));
            ++i;
        }
        infos = ilist.toArray(new DSSIInfo[ilist.size()]);
    }

    static native long dlopen_(String var0);

    static native void dlclose_(long var0);

    static native long getDSSIHandle_(long var0, long var2);

    static native String getDSSIName_(long var0);

    static native String getDSSICopyright_(long var0);

    static native String getDSSIVendor_(long var0);

    static native String getDSSILabel_(long var0);

    private static List examineLibrary(String soname) {
        long handle;
        ArrayList<DSSIInfo> list2 = new ArrayList<DSSIInfo>();
        long index = 0L;
        long sohandle = DSSIMidiDeviceProvider.dlopen_(soname);
        if (sohandle == 0L) {
            return list2;
        }
        while ((handle = DSSIMidiDeviceProvider.getDSSIHandle_(sohandle, index)) != 0L) {
            String name = DSSIMidiDeviceProvider.getDSSILabel_(handle);
            DSSIMidiDeviceProvider.getDSSICopyright_(handle);
            String label = DSSIMidiDeviceProvider.getDSSIName_(handle);
            String vendor = DSSIMidiDeviceProvider.getDSSIVendor_(handle);
            list2.add(new DSSIInfo(name, vendor, label, "DSSI-1", soname, index));
            ++index;
        }
        DSSIMidiDeviceProvider.dlclose_(sohandle);
        return list2;
    }

    public MidiDevice.Info[] getDeviceInfo() {
        return infos;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        int i = 0;
        while (i < infos.length) {
            if (info.equals(infos[i])) {
                return new DSSISynthesizer(infos[i], DSSIMidiDeviceProvider.infos[i].soname, DSSIMidiDeviceProvider.infos[i].index);
            }
            ++i;
        }
        throw new IllegalArgumentException("Don't recognize MIDI device " + info);
    }

    private static class DSSIInfo
    extends MidiDevice.Info {
        String soname;
        long index;

        public DSSIInfo(String name, String vendor, String description, String version, String soname, long index) {
            super(name, vendor, description, version);
            this.soname = soname;
            this.index = index;
        }
    }
}

