/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.CBC;
import gnu.javax.crypto.mode.CFB;
import gnu.javax.crypto.mode.CTR;
import gnu.javax.crypto.mode.EAX;
import gnu.javax.crypto.mode.ECB;
import gnu.javax.crypto.mode.ICM;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.OFB;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModeFactory
implements Registry {
    private static Set names;

    private ModeFactory() {
    }

    public static IMode getInstance(String mode, String cipher, int cipherBlockSize) {
        if (mode == null || cipher == null) {
            return null;
        }
        mode = mode.trim();
        IBlockCipher cipherImpl = CipherFactory.getInstance(cipher = cipher.trim());
        if (cipherImpl == null) {
            return null;
        }
        return ModeFactory.getInstance(mode, cipherImpl, cipherBlockSize);
    }

    public static IMode getInstance(String mode, IBlockCipher cipher, int cipherBlockSize) {
        boolean ok = false;
        Iterator it = cipher.blockSizes();
        while (it.hasNext()) {
            boolean bl = ok = cipherBlockSize == (Integer)it.next();
            if (ok) break;
        }
        if (!ok) {
            throw new IllegalArgumentException("cipherBlockSize");
        }
        IMode result = null;
        if (mode.equalsIgnoreCase("ecb")) {
            result = new ECB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ctr")) {
            result = new CTR(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("icm")) {
            result = new ICM(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("ofb")) {
            result = new OFB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("cbc")) {
            result = new CBC(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("cfb")) {
            result = new CFB(cipher, cipherBlockSize);
        } else if (mode.equalsIgnoreCase("eax")) {
            result = new EAX(cipher, cipherBlockSize);
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set getNames() {
        Class<ModeFactory> clazz = ModeFactory.class;
        synchronized (ModeFactory.class) {
            if (names == null) {
                HashSet<String> hs = new HashSet<String>();
                hs.add("ecb");
                hs.add("ctr");
                hs.add("icm");
                hs.add("ofb");
                hs.add("cbc");
                hs.add("cfb");
                hs.add("eax");
                names = Collections.unmodifiableSet(hs);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return names;
        }
    }
}

