/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Entry {
    private static final Logger log = Logger.getLogger(Entry.class.getName());
    private static final String[] TYPES = new String[]{"Encrypted", "PasswordEncrypted", "Authenticated", "PasswordAuthenticated", "Compressed", "Certificate", "PublicKey", "PrivateKey", "CertPath", "BinaryData"};
    protected int type;
    protected Properties properties;
    protected byte[] payload;

    protected Entry(int type, Properties properties) {
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("invalid packet type");
        }
        if (properties == null) {
            throw new IllegalArgumentException("no properties");
        }
        this.type = type;
        this.properties = (Properties)properties.clone();
    }

    protected Entry(int type) {
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("invalid packet type");
        }
        this.type = type;
        this.properties = new Properties();
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public void encode(DataOutputStream out) throws IOException {
        if (this.payload == null) {
            this.encodePayload();
        }
        if (out == null) {
            return;
        }
        out.write(this.type);
        this.properties.encode(out);
        out.writeInt(this.payload.length);
        out.write(this.payload);
    }

    public String toString() {
        return "Entry{" + "type=" + TYPES[this.type] + ", properties=" + this.properties + ", payload=" + (this.payload == null ? "-" : "byte[" + this.payload.length + "]") + "}";
    }

    protected void defaultDecode(DataInputStream in) throws IOException {
        this.properties = new Properties();
        this.properties.decode(in);
        int len = in.readInt();
        if (len < 0) {
            throw new IOException("corrupt length");
        }
        this.payload = new byte[len];
        in.readFully(this.payload);
    }

    protected abstract void encodePayload() throws IOException;
}

