/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMRuntimeMXBeanImpl;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;

public final class RuntimeMXBeanImpl
extends BeanImpl
implements RuntimeMXBean {
    private static final String SUN_BOOT_CLASS_PATH = "sun.boot.class.path";
    private static final String JAVA_BOOT_CLASS_PATH = "java.boot.class.path";
    private long startTime = -1L;
    private String bootClassPath = null;
    private boolean bootClassPathSupported = true;

    public RuntimeMXBeanImpl() throws NotCompliantMBeanException {
        super((Class)RuntimeMXBean.class);
    }

    public String getBootClassPath() {
        this.checkMonitorPermissions();
        if (this.isBootClassPathSupported()) {
            return this.bootClassPath;
        }
        throw new UnsupportedOperationException("Retrieving the boot classpath is not supported.");
    }

    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public List getInputArguments() {
        this.checkMonitorPermissions();
        return Arrays.asList(VMRuntimeMXBeanImpl.getInputArguments());
    }

    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public String getManagementSpecVersion() {
        return "1.0";
    }

    public String getName() {
        return VMRuntimeMXBeanImpl.getName();
    }

    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    public long getStartTime() {
        if (this.startTime == -1L) {
            this.startTime = VMRuntimeMXBeanImpl.getStartTime();
        }
        return this.startTime;
    }

    public Map getSystemProperties() {
        HashMap map = new HashMap();
        Properties props = System.getProperties();
        for (Map.Entry next : props.entrySet()) {
            Object key = next.getKey();
            Object value = next.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            map.put(key, value);
        }
        return map;
    }

    public long getUptime() {
        return new Date().getTime() - this.getStartTime();
    }

    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    public boolean isBootClassPathSupported() {
        if (this.bootClassPath == null) {
            this.bootClassPath = SystemProperties.getProperty(JAVA_BOOT_CLASS_PATH);
            if (this.bootClassPath == null) {
                this.bootClassPath = SystemProperties.getProperty(SUN_BOOT_CLASS_PATH);
            }
            if (this.bootClassPath == null) {
                this.bootClassPathSupported = false;
            }
        }
        return this.bootClassPathSupported;
    }
}

