/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmi;

import gnu.classpath.tools.rmi.Persistent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;

public class PersistentHashTable
extends Hashtable
implements Serializable,
Persistent {
    private static final long serialVersionUID = 1L;
    File database;
    WriteToDiskTask sheduled;
    long lastUpdated;
    transient boolean ready;

    private /* synthetic */ void finit$() {
        this.sheduled = null;
    }

    private PersistentHashTable(File file) {
        this.finit$();
        if (file == null) {
            throw new NullPointerException("Null file provided");
        }
        this.database = file;
    }

    public static Map createInstance(File file, boolean bl) {
        try {
            PersistentHashTable persistentHashTable;
            if (file.exists()) {
                if (bl) {
                    file.delete();
                    persistentHashTable = new PersistentHashTable(file);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
                    persistentHashTable = (PersistentHashTable)objectInputStream.readObject();
                    objectInputStream.close();
                }
            } else {
                persistentHashTable = new PersistentHashTable(file);
            }
            persistentHashTable.ready = true;
            return persistentHashTable;
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to intialize with file " + file);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public synchronized void writeContent() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.database);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to write database to disk: " + this.database);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public void markDirty() {
        if (System.currentTimeMillis() - this.lastUpdated > 300000L) {
            this.writeContent();
            this.lastUpdated = System.currentTimeMillis();
            if (this.sheduled != null) {
                this.sheduled.cancel();
                this.sheduled = null;
            }
        } else {
            if (this.sheduled != null) {
                this.sheduled.cancel();
            }
            this.sheduled = new WriteToDiskTask(this);
            Persistent.timer.schedule((TimerTask)this.sheduled, 5000);
        }
    }

    public void shutdown() {
        if (this.sheduled != null) {
            this.writeContent();
            this.sheduled = null;
        }
    }

    public Object put(Object object, Object object2) {
        super.put(object, object2);
        if (this.ready) {
            this.markDirty();
        }
        return object2;
    }

    public Object remove(Object object) {
        Object v = super.remove(object);
        if (this.ready) {
            this.markDirty();
        }
        return v;
    }

    class WriteToDiskTask
    extends TimerTask {
        private /* synthetic */ PersistentHashTable this$0;

        public void run() {
            this.this$0.writeContent();
            this.this$0.sheduled = null;
        }

        WriteToDiskTask(PersistentHashTable persistentHashTable) {
            this.this$0 = persistentHashTable;
        }
    }
}

