/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.giop.nameservice;

import gnu.CORBA.NamingService.NamingMap;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class PersistentMap
extends NamingMap {
    public final File file;
    ORB orb;
    boolean reset;

    public PersistentMap(ORB oRB, File file, boolean bl) {
        this.orb = oRB;
        this.file = file;
        this.reset = bl;
        if (this.file.exists() && !this.reset) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                Entry entry = new Entry();
                while (entry.read(bufferedReader)) {
                    Object object = this.string_to_object(entry.ior);
                    this.orb.connect(object);
                    this.map.put(entry.getComponent(), object);
                }
            }
            catch (Exception exception) {
                InternalError internalError = new InternalError(this.file.getAbsolutePath());
                internalError.initCause(exception);
                throw internalError;
            }
        }
    }

    protected Object string_to_object(String string) {
        return this.orb.string_to_object(string);
    }

    protected String object_to_string(Object object) {
        return this.orb.object_to_string(object);
    }

    public void bind(NameComponent nameComponent, Object object) throws AlreadyBound, InvalidName {
        if (this.containsKey(nameComponent)) {
            throw new AlreadyBound(nameComponent.id + "." + nameComponent.kind);
        }
        super.bind(nameComponent, object);
        this.register(nameComponent, object);
    }

    public void rebind(NameComponent nameComponent, Object object) throws InvalidName {
        java.lang.Object object2;
        java.lang.Object object3;
        if (this.containsKey(nameComponent)) {
            String string;
            object3 = this.get(nameComponent);
            object2 = this.object_to_string(object);
            if (((String)object2).equals(string = this.object_to_string((Object)object3))) {
                return;
            }
            this.remove(nameComponent);
        }
        object3 = this.entries().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            if (!object2.getValue().equals(object)) continue;
            object3.remove();
        }
        this.map.put(nameComponent, object);
        this.register(nameComponent, object);
    }

    public void remove(NameComponent nameComponent) {
        super.remove(nameComponent);
        this.unregister(nameComponent);
    }

    public void register(NameComponent nameComponent, Object object) {
        String string = this.object_to_string(object);
        File file = this.file;
        synchronized (file) {
            try {
                FileOutputStream fileOutputStream;
                try {
                    fileOutputStream = !this.file.exists() ? new FileOutputStream(this.file) : new FileOutputStream(this.file, true);
                    Entry entry = new Entry();
                    entry.id = nameComponent.id;
                    entry.kind = nameComponent.kind;
                    entry.ior = string;
                    entry.write(fileOutputStream);
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    InternalError internalError = new InternalError(this.file.getAbsolutePath());
                    internalError.initCause(exception);
                    throw internalError;
                }
                fileOutputStream = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var5_7 = null;
                throw throwable;
            }
        }
    }

    public void unregister(NameComponent nameComponent) {
        File file = this.file;
        synchronized (file) {
            try {
                File file2;
                try {
                    file2 = new File(this.file.getParent(), this.file.getName() + "_t");
                    FileInputStream fileInputStream = new FileInputStream(this.file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                    String string = nameComponent.kind;
                    if (string == null) {
                        string = "";
                    }
                    Entry entry = new Entry();
                    while (entry.read(bufferedReader)) {
                        if (entry.id.equals(nameComponent.id) && entry.kind.equals(string)) continue;
                        entry.write(bufferedOutputStream);
                    }
                    File file3 = new File(this.file.getParent(), this.file.getName() + "_d");
                    if (file3.exists()) {
                        file3.delete();
                    }
                    if (!this.file.renameTo(file3)) {
                        throw new IOException(this.file.getAbsolutePath() + " rename failed");
                    }
                    if (!file2.renameTo(this.file)) {
                        throw new IOException(this.file.getAbsolutePath() + " rename failed");
                    }
                }
                catch (Exception exception) {
                    InternalError internalError = new InternalError(this.file.getAbsolutePath());
                    internalError.initCause(exception);
                    throw internalError;
                }
                file2 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public static class Entry {
        String id;
        String kind;
        String ior;

        public NameComponent getComponent() {
            return new NameComponent(this.id, this.kind);
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.getKey(this.id, this.kind).getBytes());
            outputStream.write(10);
            outputStream.write(this.ior.getBytes());
            outputStream.write(10);
            outputStream.close();
        }

        public boolean read(BufferedReader bufferedReader) throws IOException {
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            if (string != null && string2 != null) {
                if (string.length() < 2) {
                    this.id = string;
                    this.kind = "";
                } else {
                    int n = -1;
                    for (int i = 1; i < string.length(); ++i) {
                        if (string.charAt(i) != '.' || string.charAt(i - 1) == '\\') continue;
                        n = i;
                        break;
                    }
                    if (n < 0) {
                        this.id = string;
                        this.kind = "";
                    } else if (n == string.length() - 1) {
                        this.id = string.substring(0, string.length() - 1);
                        this.kind = "";
                    } else {
                        this.id = string.substring(0, n);
                        this.kind = string.substring(n + 1);
                    }
                }
                this.ior = string2;
                return true;
            }
            return false;
        }

        public String getKey(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
            this.appEscaping(stringBuffer, string);
            stringBuffer.append('.');
            if (string2 != null && string2.length() > 0) {
                this.appEscaping(stringBuffer, string2);
            }
            return stringBuffer.toString();
        }

        void appEscaping(StringBuffer stringBuffer, String string) {
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '.': 
                    case '/': 
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        continue block3;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
    }
}

