/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.TagParser;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.html2.DomHTMLAppletElement;
import gnu.xml.dom.html2.DomHTMLEmbedElement;
import gnu.xml.dom.html2.DomHTMLObjectElement;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class AppletTag {
    URL documentbase;
    String name;
    String code;
    String codebase;
    ArrayList archives;
    HashMap parameters;
    Dimension screenSize;

    private /* synthetic */ void finit$() {
        this.name = "";
        this.code = "";
        this.codebase = "";
        this.archives = new ArrayList();
        this.parameters = new HashMap();
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    }

    AppletTag() {
        this.finit$();
    }

    AppletTag(DomHTMLAppletElement domHTMLAppletElement) {
        this.finit$();
        this.name = domHTMLAppletElement.getName();
        this.parameters.put("name", this.name);
        this.parameters.put("object", domHTMLAppletElement.getObject());
        this.parameters.put("align", domHTMLAppletElement.getAlign());
        this.parameters.put("alt", domHTMLAppletElement.getAlt());
        this.parameters.put("height", domHTMLAppletElement.getHeight());
        this.parameters.put("hspace", Integer.toString(domHTMLAppletElement.getHspace()));
        this.parameters.put("vspace", Integer.toString(domHTMLAppletElement.getVspace()));
        this.parameters.put("width", domHTMLAppletElement.getWidth());
        TagParser.parseParams((DomNode)domHTMLAppletElement, this);
        if (this.code.equals("")) {
            this.code = domHTMLAppletElement.getCode();
            if (this.code.equals("")) {
                this.code = domHTMLAppletElement.getCls();
            }
        }
        if (this.codebase.equals("")) {
            this.codebase = domHTMLAppletElement.getCodeBase();
            if (this.codebase.equals("")) {
                this.codebase = domHTMLAppletElement.getSrc();
            }
        }
        if (this.archives.size() == 0) {
            String string = "";
            String string2 = domHTMLAppletElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                string = this.code + ".jar";
            }
            if (!string2.equals("")) {
                string = string + new StringBuffer(",").append(string2);
            }
            if (!string.equals("")) {
                this.archives = TagParser.parseArchives(string, this);
            }
        }
    }

    AppletTag(DomHTMLEmbedElement domHTMLEmbedElement) {
        String string;
        this.finit$();
        this.name = domHTMLEmbedElement.getName();
        this.parameters.put("name", this.name);
        String string2 = domHTMLEmbedElement.getJavaObject();
        if (!string2.equals("")) {
            this.parameters.put("java_object", string2);
        } else {
            this.parameters.put("object", domHTMLEmbedElement.getObject());
        }
        this.parameters.put("width", domHTMLEmbedElement.getWidth());
        this.parameters.put("height", domHTMLEmbedElement.getHeight());
        this.parameters.put("align", domHTMLEmbedElement.getAlign());
        this.parameters.put("alt", domHTMLEmbedElement.getAlt());
        this.parameters.put("hspace", Integer.toString(domHTMLEmbedElement.getHspace()));
        this.parameters.put("mayscript", domHTMLEmbedElement.getMayscript());
        this.parameters.put("pluginspage", domHTMLEmbedElement.getPluginsPage());
        this.parameters.put("title", domHTMLEmbedElement.getTitle());
        this.parameters.put("type", domHTMLEmbedElement.getType());
        this.parameters.put("java_type", domHTMLEmbedElement.getJavaType());
        this.parameters.put("vspace", Integer.toString(domHTMLEmbedElement.getVspace()));
        TagParser.parseParams((DomNode)domHTMLEmbedElement, this);
        if (this.codebase.equals("")) {
            string = domHTMLEmbedElement.getJavaCodeBase();
            this.codebase = !string.equals("") ? string : domHTMLEmbedElement.getCodeBase();
        }
        if (this.code.equals("")) {
            string = domHTMLEmbedElement.getJavaCode();
            this.code = !string.equals("") ? string : domHTMLEmbedElement.getCode();
        }
        if (this.archives.size() == 0) {
            string = "";
            String string3 = domHTMLEmbedElement.getJavaArchive();
            String string4 = domHTMLEmbedElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                string = this.code + ".jar";
            }
            if (!string3.equals("")) {
                string = string + new StringBuffer(",").append(string3);
            } else if (!string4.equals("")) {
                string = string + new StringBuffer(",").append(string4);
            }
            if (!string.equals("")) {
                this.archives = TagParser.parseArchives(string, this);
            }
        }
    }

    AppletTag(DomHTMLObjectElement domHTMLObjectElement) {
        String string;
        this.finit$();
        this.name = domHTMLObjectElement.getName();
        this.parameters.put("name", this.name);
        String string2 = domHTMLObjectElement.getJavaObject();
        if (!string2.equals("")) {
            this.parameters.put("java_object", string2);
        } else {
            this.parameters.put("object", domHTMLObjectElement.getObject());
        }
        this.parameters.put("type", domHTMLObjectElement.getType());
        this.parameters.put("java_type", domHTMLObjectElement.getJavaType());
        this.parameters.put("align", domHTMLObjectElement.getAlign());
        this.parameters.put("codetype", domHTMLObjectElement.getCodeType());
        this.parameters.put("data", domHTMLObjectElement.getData());
        this.parameters.put("declare", Boolean.toString(domHTMLObjectElement.getDeclare()));
        this.parameters.put("height", domHTMLObjectElement.getHeight());
        this.parameters.put("hspace", Integer.toString(domHTMLObjectElement.getHspace()));
        this.parameters.put("border", domHTMLObjectElement.getBorder());
        this.parameters.put("standby", domHTMLObjectElement.getStandby());
        this.parameters.put("tabindex", Integer.toString(domHTMLObjectElement.getTabIndex()));
        this.parameters.put("usemap", domHTMLObjectElement.getUseMap());
        this.parameters.put("vspace", Integer.toString(domHTMLObjectElement.getVspace()));
        this.parameters.put("width", domHTMLObjectElement.getWidth());
        this.parameters.put("mayscript", domHTMLObjectElement.getMayscript());
        this.parameters.put("scriptable", domHTMLObjectElement.getScriptable());
        TagParser.parseParams((DomNode)domHTMLObjectElement, this);
        if (this.codebase.equals("")) {
            string = domHTMLObjectElement.getJavaCodeBase();
            this.codebase = !string.equals("") ? string : domHTMLObjectElement.getCodeBase();
        }
        if (this.code.equals("")) {
            string = domHTMLObjectElement.getJavaCode();
            this.code = !string.equals("") ? string : domHTMLObjectElement.getCode();
        }
        if (this.archives.size() == 0) {
            string = "";
            String string3 = domHTMLObjectElement.getJavaArchive();
            String string4 = domHTMLObjectElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                string = this.code + ".jar";
            }
            if (!string3.equals("")) {
                string = string + new StringBuffer(",").append(string3);
            } else if (!string4.equals("")) {
                string = string + new StringBuffer(",").append(string4);
            }
            if (!string.equals("")) {
                this.archives = TagParser.parseArchives(string, this);
            }
        }
    }

    public String toString() {
        return "  name=" + this.name + "\n" + "  code=" + this.code + "\n" + "  codebase=" + this.codebase + "\n" + "  archive=" + this.archives + "\n" + "  parameters=" + this.parameters + "\n" + "  documentbase=" + this.documentbase + "\n";
    }

    Dimension getSize() {
        double d;
        String string;
        Dimension dimension = new Dimension(320, 200);
        try {
            string = (String)this.parameters.get("width");
            if (string != null && !string.equals("")) {
                if (string.charAt(string.length() - 1) == '%') {
                    d = (double)NumberFormat.getPercentInstance(Locale.US).parse(string).intValue() / 100.0;
                    dimension.width = (int)(d * (double)this.screenSize.width);
                } else {
                    dimension.width = NumberFormat.getInstance(Locale.US).parse(string).intValue();
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            string = (String)this.parameters.get("height");
            if (string != null && !string.equals("")) {
                if (string.charAt(string.length() - 1) == '%') {
                    d = (double)NumberFormat.getPercentInstance(Locale.US).parse(string).intValue() / 100.0;
                    dimension.height = (int)(d * (double)this.screenSize.height);
                } else {
                    dimension.height = NumberFormat.getInstance(Locale.US).parse(string).intValue();
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dimension;
    }

    String getCodeBase() {
        return this.codebase;
    }

    ArrayList getArchives() {
        return this.archives;
    }

    String getCode() {
        return this.code;
    }

    URL getDocumentBase() {
        return this.documentbase;
    }

    String getParameter(String string) {
        return (String)this.parameters.get(string.toLowerCase());
    }

    URL prependCodeBase(String string) throws MalformedURLException {
        URL uRL;
        if (this.documentbase == null) {
            this.documentbase = TagParser.db;
        }
        if (this.codebase.equals("")) {
            if (this.documentbase.getFile().endsWith(File.separator)) {
                uRL = this.documentbase;
            } else {
                String string2 = this.documentbase.getFile();
                if (string2.indexOf(".") < 0) {
                    uRL = new URL(this.documentbase + File.separator);
                } else {
                    string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1);
                    uRL = new URL(this.documentbase.getProtocol(), this.documentbase.getHost(), this.documentbase.getPort(), string2);
                }
            }
        } else {
            URL uRL2 = new URL(this.documentbase, this.codebase);
            uRL = "file".equals(uRL2.getProtocol()) ? (new File(uRL2.getFile()).isDirectory() && !this.codebase.endsWith(File.separator) ? new URL(this.documentbase, this.codebase + File.separator) : new URL(this.documentbase, this.codebase)) : (this.codebase.endsWith(File.separator) ? new URL(this.documentbase, this.codebase) : new URL(this.documentbase, this.codebase + File.separator));
        }
        return new URL(uRL, string);
    }
}

