/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.AttributeSet;

public class HTML {
    public static final String NULL_ATTRIBUTE_VALUE = "#DEFAULT";
    static final int BREAKS = 1;
    static final int BLOCK = 2;
    static final int PREFORMATTED = 4;
    static final int SYNTHETIC = 8;
    private static Map tagMap;
    private static Map attrMap;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Attribute[] getAllAttributeKeys() {
        return Attribute.getAllAttributes();
    }

    public static Tag[] getAllTags() {
        return Tag.getAllTags();
    }

    public static Attribute getAttributeKey(String string) {
        if (attrMap == null) {
            attrMap = new TreeMap();
            Attribute[] attributeArray = HTML.getAllAttributeKeys();
            for (int i = 0; i < attributeArray.length; ++i) {
                attrMap.put(attributeArray[i].toString(), attributeArray[i]);
            }
        }
        return (Attribute)attrMap.get(string.toLowerCase());
    }

    public static int getIntegerAttributeValue(AttributeSet attributeSet, Attribute attribute, int n) {
        Object object = attributeSet.getAttribute(attribute);
        if (object == null) {
            return n;
        }
        try {
            return Integer.parseInt(object.toString().trim());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static Tag getTag(String string) {
        if (tagMap == null) {
            tagMap = new TreeMap();
            Tag[] tagArray = HTML.getAllTags();
            for (int i = 0; i < tagArray.length; ++i) {
                tagMap.put(tagArray[i].toString(), tagArray[i]);
            }
        }
        return (Tag)tagMap.get(string.toLowerCase());
    }

    public static class UnknownTag
    extends Tag
    implements Serializable {
        private static final long serialVersionUID = -1534369342247250625L;

        public UnknownTag(String string) {
            super(string);
        }
    }

    public static class Tag {
        public static final Tag A = new Tag("a");
        public static final Tag ADDRESS = new Tag("address");
        public static final Tag APPLET = new Tag("applet");
        public static final Tag AREA = new Tag("area");
        public static final Tag B = new Tag("b");
        public static final Tag BASE = new Tag("base");
        public static final Tag BASEFONT = new Tag("basefont");
        public static final Tag BIG = new Tag("big");
        public static final Tag BLOCKQUOTE = new Tag("blockquote", 3);
        public static final Tag BODY = new Tag("body", 3);
        public static final Tag BR = new Tag("br", 1);
        public static final Tag CAPTION = new Tag("caption");
        public static final Tag CENTER = new Tag("center", 1);
        public static final Tag CITE = new Tag("cite");
        public static final Tag CODE = new Tag("code");
        public static final Tag DD = new Tag("dd", 3);
        public static final Tag DFN = new Tag("dfn");
        public static final Tag DIR = new Tag("dir", 3);
        public static final Tag DIV = new Tag("div", 3);
        public static final Tag DL = new Tag("dl", 3);
        public static final Tag DT = new Tag("dt", 3);
        public static final Tag EM = new Tag("em");
        public static final Tag FONT = new Tag("font");
        public static final Tag FORM = new Tag("form", 1);
        public static final Tag FRAME = new Tag("frame");
        public static final Tag FRAMESET = new Tag("frameset");
        public static final Tag H1 = new Tag("h1", 3);
        public static final Tag H2 = new Tag("h2", 3);
        public static final Tag H3 = new Tag("h3", 3);
        public static final Tag H4 = new Tag("h4", 3);
        public static final Tag H5 = new Tag("h5", 3);
        public static final Tag H6 = new Tag("h6", 3);
        public static final Tag HEAD = new Tag("head", 3);
        public static final Tag HR = new Tag("hr", 1);
        public static final Tag HTML = new Tag("html", 1);
        public static final Tag I = new Tag("i");
        public static final Tag IMG = new Tag("img");
        public static final Tag INPUT = new Tag("input");
        public static final Tag ISINDEX = new Tag("isindex", 1);
        public static final Tag KBD = new Tag("kbd");
        public static final Tag LI = new Tag("li", 3);
        public static final Tag LINK = new Tag("link");
        public static final Tag MAP = new Tag("map");
        public static final Tag MENU = new Tag("menu", 3);
        public static final Tag META = new Tag("meta");
        static final Tag NOBR = new Tag("nobr");
        public static final Tag NOFRAMES = new Tag("noframes", 3);
        public static final Tag OBJECT = new Tag("object");
        public static final Tag OL = new Tag("ol", 3);
        public static final Tag OPTION = new Tag("option");
        public static final Tag P = new Tag("p", 3);
        public static final Tag PARAM = new Tag("param");
        public static final Tag PRE = new Tag("pre", 7);
        public static final Tag S = new Tag("s");
        public static final Tag SAMP = new Tag("samp");
        public static final Tag SCRIPT = new Tag("script");
        public static final Tag SELECT = new Tag("select");
        public static final Tag SMALL = new Tag("small");
        public static final Tag SPAN = new Tag("span");
        public static final Tag STRIKE = new Tag("strike");
        public static final Tag STRONG = new Tag("strong");
        public static final Tag STYLE = new Tag("style");
        public static final Tag SUB = new Tag("sub");
        public static final Tag SUP = new Tag("sup");
        public static final Tag TABLE = new Tag("table", 2);
        public static final Tag TD = new Tag("td", 3);
        public static final Tag TEXTAREA = new Tag("textarea", 4);
        public static final Tag TH = new Tag("th", 3);
        public static final Tag TITLE = new Tag("title", 3);
        public static final Tag TR = new Tag("tr", 2);
        public static final Tag TT = new Tag("tt");
        public static final Tag U = new Tag("u");
        public static final Tag UL = new Tag("ul", 3);
        public static final Tag VAR = new Tag("var");
        private static final int TOTAL_SYNTHETIC_TAGS = 3;
        public static final Tag COMMENT = new Tag("comment", 8);
        public static final Tag CONTENT = new Tag("content", 8);
        public static final Tag IMPLIED = new Tag("p-implied", 8);
        final String name;
        final int flags;

        public Tag() {
            this.name = null;
            this.flags = 0;
        }

        protected Tag(String string) {
            this.name = string;
            this.flags = 0;
        }

        protected Tag(String string, boolean bl, boolean bl2) {
            int n = 0;
            if (bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            this.flags = n;
            this.name = string;
        }

        Tag(String string, int n) {
            this.name = string;
            this.flags = n;
        }

        public boolean isBlock() {
            return (this.flags & 2) != 0;
        }

        public boolean isPreformatted() {
            return (this.flags & 4) != 0;
        }

        public boolean breaksFlow() {
            return (this.flags & 1) != 0;
        }

        public String toString() {
            return this.name;
        }

        static Tag[] getAllTags() {
            Field[] fieldArray = javax.swing.text.html.HTML.class$("javax.swing.text.html.HTML$Tag").getFields();
            Tag[] tagArray = new Tag[fieldArray.length - 3];
            int n = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if ((field.getModifiers() & 8) == 0 || !field.getType().equals(javax.swing.text.html.HTML.class$("javax.swing.text.html.HTML$Tag"))) continue;
                try {
                    Tag tag = (Tag)field.get(null);
                    if (tag.isSyntetic()) continue;
                    tagArray[n++] = tag;
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Tag.unexpected(illegalAccessException);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Tag.unexpected(illegalArgumentException);
                }
            }
            return tagArray;
        }

        boolean isSyntetic() {
            return (this.flags & 8) != 0;
        }

        private static void unexpected(Exception exception) throws Error {
            throw new Error("This should never happen, report a bug", exception);
        }
    }

    public static final class Attribute {
        public static final Attribute ACTION = new Attribute("action");
        public static final Attribute ALIGN = new Attribute("align");
        public static final Attribute ALINK = new Attribute("alink");
        public static final Attribute ALT = new Attribute("alt");
        public static final Attribute ARCHIVE = new Attribute("archive");
        public static final Attribute BACKGROUND = new Attribute("background");
        public static final Attribute BGCOLOR = new Attribute("bgcolor");
        public static final Attribute BORDER = new Attribute("border");
        public static final Attribute CELLPADDING = new Attribute("cellpadding");
        public static final Attribute CELLSPACING = new Attribute("cellspacing");
        public static final Attribute CHECKED = new Attribute("checked");
        public static final Attribute CLASS = new Attribute("class");
        public static final Attribute CLASSID = new Attribute("classid");
        public static final Attribute CLEAR = new Attribute("clear");
        public static final Attribute CODE = new Attribute("code");
        public static final Attribute CODEBASE = new Attribute("codebase");
        public static final Attribute CODETYPE = new Attribute("codetype");
        public static final Attribute COLOR = new Attribute("color");
        public static final Attribute COLS = new Attribute("cols");
        public static final Attribute COLSPAN = new Attribute("colspan");
        public static final Attribute COMMENT = new Attribute("comment");
        public static final Attribute COMPACT = new Attribute("compact");
        public static final Attribute CONTENT = new Attribute("content");
        public static final Attribute COORDS = new Attribute("coords");
        public static final Attribute DATA = new Attribute("data");
        public static final Attribute DECLARE = new Attribute("declare");
        public static final Attribute DIR = new Attribute("dir");
        public static final Attribute DUMMY = new Attribute("dummy");
        public static final Attribute ENCTYPE = new Attribute("enctype");
        public static final Attribute ENDTAG = new Attribute("endtag");
        public static final Attribute FACE = new Attribute("face");
        public static final Attribute FRAMEBORDER = new Attribute("frameborder");
        public static final Attribute HALIGN = new Attribute("halign");
        public static final Attribute HEIGHT = new Attribute("height");
        public static final Attribute HREF = new Attribute("href");
        public static final Attribute HSPACE = new Attribute("hspace");
        public static final Attribute HTTPEQUIV = new Attribute("http-equiv");
        public static final Attribute ID = new Attribute("id");
        public static final Attribute ISMAP = new Attribute("ismap");
        public static final Attribute LANG = new Attribute("lang");
        public static final Attribute LANGUAGE = new Attribute("language");
        public static final Attribute LINK = new Attribute("link");
        public static final Attribute LOWSRC = new Attribute("lowsrc");
        public static final Attribute MARGINHEIGHT = new Attribute("marginheight");
        public static final Attribute MARGINWIDTH = new Attribute("marginwidth");
        public static final Attribute MAXLENGTH = new Attribute("maxlength");
        static final Attribute MEDIA = new Attribute("media");
        public static final Attribute METHOD = new Attribute("method");
        public static final Attribute MULTIPLE = new Attribute("multiple");
        public static final Attribute N = new Attribute("n");
        public static final Attribute NAME = new Attribute("name");
        public static final Attribute NOHREF = new Attribute("nohref");
        public static final Attribute NORESIZE = new Attribute("noresize");
        public static final Attribute NOSHADE = new Attribute("noshade");
        public static final Attribute NOWRAP = new Attribute("nowrap");
        public static final Attribute PROMPT = new Attribute("prompt");
        public static final Attribute REL = new Attribute("rel");
        public static final Attribute REV = new Attribute("rev");
        public static final Attribute ROWS = new Attribute("rows");
        public static final Attribute ROWSPAN = new Attribute("rowspan");
        public static final Attribute SCROLLING = new Attribute("scrolling");
        public static final Attribute SELECTED = new Attribute("selected");
        public static final Attribute SHAPE = new Attribute("shape");
        public static final Attribute SHAPES = new Attribute("shapes");
        public static final Attribute SIZE = new Attribute("size");
        public static final Attribute SRC = new Attribute("src");
        public static final Attribute STANDBY = new Attribute("standby");
        public static final Attribute START = new Attribute("start");
        public static final Attribute STYLE = new Attribute("style");
        public static final Attribute TARGET = new Attribute("target");
        public static final Attribute TEXT = new Attribute("text");
        public static final Attribute TITLE = new Attribute("title");
        public static final Attribute TYPE = new Attribute("type");
        public static final Attribute USEMAP = new Attribute("usemap");
        public static final Attribute VALIGN = new Attribute("valign");
        public static final Attribute VALUE = new Attribute("value");
        public static final Attribute VALUETYPE = new Attribute("valuetype");
        public static final Attribute VERSION = new Attribute("version");
        public static final Attribute VLINK = new Attribute("vlink");
        public static final Attribute VSPACE = new Attribute("vspace");
        public static final Attribute WIDTH = new Attribute("width");
        private final String name;

        Attribute(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        static Attribute[] getAllAttributes() {
            Field[] fieldArray = HTML.class$("javax.swing.text.html.HTML$Attribute").getFields();
            Attribute[] attributeArray = new Attribute[fieldArray.length];
            int n = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if ((field.getModifiers() & 8) == 0 || !field.getType().equals(HTML.class$("javax.swing.text.html.HTML$Attribute"))) continue;
                try {
                    Attribute attribute = (Attribute)field.get(null);
                    attributeArray[n++] = attribute;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    throw new Error("This should never happen, report a bug");
                }
            }
            return attributeArray;
        }
    }
}

