/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    int selectionStart;
    int selectionEnd;
    Font font;
    float maxLineLength;
    Element longestLine;
    protected FontMetrics metrics;
    private transient Segment lineBuffer;

    private /* synthetic */ void finit$() {
        this.maxLineLength = -1.0f;
        this.longestLine = null;
    }

    public PlainView(Element element) {
        super(element);
        this.finit$();
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.font = font;
            this.metrics = container.getFontMetrics(font);
        }
    }

    protected Rectangle lineToRect(Shape shape, int n) {
        this.updateMetrics();
        Rectangle rectangle = shape.getBounds();
        int n2 = this.metrics.getHeight();
        return new Rectangle(rectangle.x, rectangle.y + n * n2, rectangle.width, n2);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.updateMetrics();
        Document document = this.getDocument();
        int n2 = this.getElement().getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape, n2);
        Element element = this.getElement().getElement(n2);
        int n3 = element.getStartOffset();
        Segment segment = this.getLineBuffer();
        document.getText(n3, n - n3, segment);
        int n4 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, this, n3);
        rectangle.x += n4;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    protected void drawLine(int n, Graphics graphics, int n2, int n3) {
        try {
            Element element = this.getElement().getElement(n);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset() - 1;
            if (this.selectionStart <= n4) {
                if (this.selectionEnd <= n4) {
                    this.drawUnselectedText(graphics, n2, n3, n4, n5);
                } else if (this.selectionEnd <= n5) {
                    n2 = this.drawSelectedText(graphics, n2, n3, n4, this.selectionEnd);
                    this.drawUnselectedText(graphics, n2, n3, this.selectionEnd, n5);
                } else {
                    this.drawSelectedText(graphics, n2, n3, n4, n5);
                }
            } else if (this.selectionStart < n5) {
                if (this.selectionEnd < n5) {
                    n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.selectionStart);
                    n2 = this.drawSelectedText(graphics, n2, n3, this.selectionStart, this.selectionEnd);
                    this.drawUnselectedText(graphics, n2, n3, this.selectionEnd, n5);
                } else {
                    n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.selectionStart);
                    this.drawSelectedText(graphics, n2, n3, this.selectionStart, n5);
                }
            } else {
                this.drawUnselectedText(graphics, n2, n3, n4, n5);
            }
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, segment.offset);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (jTextComponent.isEnabled()) {
            graphics.setColor(this.unselectedColor);
        } else {
            graphics.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(n3, n4 - n3, segment);
        return Utilities.drawTabbedText(segment, n, n2, graphics, this, segment.offset);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.updateMetrics();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.selectedColor = jTextComponent.getSelectedTextColor();
        this.unselectedColor = jTextComponent.getForeground();
        this.disabledColor = jTextComponent.getDisabledTextColor();
        this.selectionStart = jTextComponent.getSelectionStart();
        this.selectionEnd = jTextComponent.getSelectionEnd();
        Rectangle rectangle = shape.getBounds();
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        int n = rectangle.y + this.metrics.getAscent();
        int n2 = this.metrics.getHeight();
        int n3 = element.getElementCount();
        for (int i = 0; i < n3; ++i) {
            this.drawLine(i, graphics, rectangle.x, n);
            n += n2;
        }
    }

    protected int getTabSize() {
        Object object = this.getDocument().getProperty("tabSize");
        if (object == null) {
            return 8;
        }
        return (Integer)object;
    }

    public float nextTabStop(float f, int n) {
        float f2 = this.getTabSize() * this.metrics.charWidth('m');
        return (float)(Math.floor(f / f2) + 1.0) * f2;
    }

    float determineMaxLineLength() {
        if (this.maxLineLength != -1.0f) {
            return this.maxLineLength;
        }
        Element element = this.getElement();
        Segment segment = this.getLineBuffer();
        float f = 0.0f;
        for (int i = 0; i < element.getElementCount(); ++i) {
            int n;
            Element element2 = element.getElement(i);
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset() - 1;
            try {
                element.getDocument().getText(n2, n3 - n2, segment);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (segment == null || segment.array == null || segment.count == 0 || !((float)(n = this.metrics.charsWidth(segment.array, segment.offset, segment.count)) > f)) continue;
            this.longestLine = element2;
            f = n;
        }
        this.maxLineLength = f;
        return this.maxLineLength;
    }

    public float getPreferredSpan(int n) {
        float f;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.updateMetrics();
        Element element = this.getElement();
        switch (n) {
            case 0: {
                f = this.determineMaxLineLength();
                break;
            }
            default: {
                f = this.metrics.getHeight() * element.getElementCount();
            }
        }
        return f;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        int n = Math.min(Math.max((int)(f2 - (float)rectangle.y) / this.metrics.getHeight(), 0), element.getElementCount() - 1);
        Element element2 = element.getElement(n);
        Segment segment = this.getLineBuffer();
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            document.getText(n2, n3 - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        int n4 = Utilities.getTabbedTextOffset(segment, this.metrics, rectangle.x, (int)f, this, n2);
        return Math.max(0, n4);
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.metrics == null) {
            this.updateMetrics();
            this.preferenceChanged(null, true, true);
            return;
        }
        Element element = this.getElement();
        if (this.longestLine == null) {
            this.findLongestLine(0, element.getElementCount() - 1);
        }
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
            boolean bl = true;
            if (elementChange == null) {
                bl = false;
            }
            int n = bl ? elementChange.getIndex() : element.getElementIndex(documentEvent.getOffset());
            int n2 = 0;
            if (bl) {
                n2 = elementChange.getChildrenAdded().length - 1;
            }
            int n3 = (int)this.maxLineLength;
            if (this.longestLine.getEndOffset() < documentEvent.getOffset() || this.longestLine.getStartOffset() > documentEvent.getOffset() + documentEvent.getLength()) {
                this.findLongestLine(n, n + n2);
            } else {
                this.findLongestLine(0, element.getElementCount() - 1);
            }
            this.preferenceChanged(null, this.maxLineLength != (float)n3, bl);
            int n4 = n;
            if (bl) {
                n4 = element.getElementCount() - 1;
            }
            this.damageLineRange(n, n4, shape, this.getContainer());
        } else {
            int n = (int)this.maxLineLength;
            if (elementChange != null) {
                this.findLongestLine(0, element.getElementCount() - 1);
                this.preferenceChanged(null, this.maxLineLength != (float)n, true);
            } else {
                int n5 = this.getElement().getElementIndex(documentEvent.getOffset());
                Element element2 = this.getElement().getElement(n5);
                if (this.longestLine == element2) {
                    this.findLongestLine(0, element.getElementCount() - 1);
                    this.preferenceChanged(null, this.maxLineLength != (float)n, false);
                }
                this.damageLineRange(n5, n5, shape, this.getContainer());
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape == null) {
            return;
        }
        Rectangle rectangle = this.lineToRect(shape, n);
        Rectangle rectangle2 = this.lineToRect(shape, n2);
        if (rectangle == null || rectangle2 == null) {
            component.repaint();
        } else {
            Rectangle rectangle3 = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    private void findLongestLine(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            int n3 = this.getLineLength(i);
            if (!((float)n3 > this.maxLineLength)) continue;
            this.maxLineLength = n3;
            this.longestLine = this.getElement().getElement(i);
        }
    }

    private int getLineLength(int n) {
        Element element = this.getElement().getElement(n);
        Segment segment = this.getLineBuffer();
        try {
            Document document = this.getDocument();
            document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset() - 1, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        return Utilities.getTabbedTextWidth(segment, this.metrics, 0, this, element.getStartOffset());
    }
}

