/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.plaf.basic.SharedUIDefaults;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.View;

public class BasicTextFieldUI
extends BasicTextUI {
    public View create(Element element) {
        return new FieldView(element);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTextFieldUI();
    }

    protected String getPropertyPrefix() {
        return "TextField";
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") && this.textComponent.getBackground() instanceof ColorUIResource) {
            Color color = null;
            Color color2 = this.textComponent.getBackground();
            String string = this.getPropertyPrefix();
            if (!this.textComponent.isEnabled()) {
                color = SharedUIDefaults.getColor(string + ".disabledBackground");
            }
            if (color == null && !this.textComponent.isEditable()) {
                color = SharedUIDefaults.getColor(string + ".inactiveBackground");
            }
            if (color == null) {
                color = SharedUIDefaults.getColor(string + ".background");
            }
            if (color != null && color != color2) {
                this.textComponent.setBackground(color);
            }
        }
    }
}

