/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final long serialVersionUID = 3876025080382781659L;
    final JTable this_table;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    protected Hashtable defaultEditorsByColumnClass;
    protected Hashtable defaultRenderersByColumnClass;
    protected int editingColumn;
    protected int editingRow;
    protected transient Component editorComp;
    protected boolean autoCreateColumnsFromModel;
    protected int autoResizeMode;
    protected int rowHeight;
    protected int rowMargin;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected TableCellEditor cellEditor;
    private boolean dragEnabled;
    protected Color gridColor;
    protected Dimension preferredViewportSize;
    protected Color selectionBackground;
    private static final String SELECTION_BACKGROUND_CHANGED_PROPERTY = "selectionBackground";
    protected Color selectionForeground;
    private static final String SELECTION_FOREGROUND_CHANGED_PROPERTY = "selectionForeground";
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected JTableHeader tableHeader;
    TableColumnPropertyChangeHandler tableColumnPropertyChangeHandler;
    private boolean surrendersFocusOnKeystroke;
    private Rectangle rectCache;
    private boolean clientRowHeightSet;
    private SizeSequence rowHeights;
    private transient TableCellEditor booleanInvertingEditor;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.this_table = this;
        this.defaultEditorsByColumnClass = new Hashtable();
        this.defaultRenderersByColumnClass = new Hashtable();
        this.tableColumnPropertyChangeHandler = new TableColumnPropertyChangeHandler(this);
        this.surrendersFocusOnKeystroke = false;
        this.rectCache = new Rectangle();
        this.clientRowHeightSet = false;
    }

    public JTable() {
        this(null, null, null);
    }

    public JTable(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public JTable(Object[][] objectArray, Object[] objectArray2) {
        this(new DefaultTableModel(objectArray, objectArray2));
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        TableColumnModel tableColumnModel2;
        this.finit$();
        boolean bl = false;
        if (tableColumnModel != null) {
            tableColumnModel2 = tableColumnModel;
        } else {
            tableColumnModel2 = this.createDefaultColumnModel();
            bl = true;
        }
        this.rowMargin = 1;
        tableColumnModel2.setColumnMargin(1);
        this.setColumnModel(tableColumnModel2);
        this.setSelectionModel(listSelectionModel == null ? this.createDefaultSelectionModel() : listSelectionModel);
        this.setModel(tableModel == null ? this.createDefaultDataModel() : tableModel);
        this.setAutoCreateColumnsFromModel(bl);
        this.initializeLocalVars();
        this.selectionModel.setAnchorSelectionIndex(0);
        this.selectionModel.setLeadSelectionIndex(0);
        tableColumnModel2.getSelectionModel().setAnchorSelectionIndex(0);
        tableColumnModel2.getSelectionModel().setLeadSelectionIndex(0);
        this.updateUI();
    }

    public JTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    protected void initializeLocalVars() {
        this.setTableHeader(this.createDefaultTableHeader());
        if (this.autoCreateColumnsFromModel) {
            this.createDefaultColumnsFromModel();
        }
        this.columnModel.addColumnModelListener(this);
        this.autoResizeMode = 2;
        this.setRowHeight(16);
        this.rowMargin = 1;
        this.rowSelectionAllowed = true;
        this.cellEditor = null;
        this.dragEnabled = true;
        this.preferredViewportSize = new Dimension(450, 400);
        this.showHorizontalLines = true;
        this.showVerticalLines = true;
        this.editingColumn = -1;
        this.editingRow = -1;
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getHeaderValue() == null) {
            String string = this.dataModel.getColumnName(tableColumn.getModelIndex());
            tableColumn.setHeaderValue(string);
        }
        this.columnModel.addColumn(tableColumn);
        tableColumn.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
    }

    protected void createDefaultEditors() {
        JCheckBox jCheckBox = new BooleanCellRenderer(this).getCheckBox();
        jCheckBox.setBorder(BorderFactory.createLineBorder(this.getGridColor(), 2));
        jCheckBox.setBorderPainted(true);
        this.booleanInvertingEditor = new DefaultCellEditor(jCheckBox);
        this.setDefaultEditor(JTable.class$("java.lang.Boolean"), this.booleanInvertingEditor);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void createDefaultRenderers() {
        this.setDefaultRenderer(JTable.class$("java.lang.Boolean"), new BooleanCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Number"), new NumberCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Double"), new DoubleCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.lang.Double"), new FloatCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("java.util.Date"), new DateCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("javax.swing.Icon"), new IconCellRenderer(this));
        this.setDefaultRenderer(JTable.class$("javax.swing.ImageIcon"), new IconCellRenderer(this));
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.editingCanceled(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.revalidate();
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        int n = Math.max(0, Math.min(this.getColumnCount() - 1, listSelectionEvent.getFirstIndex()));
        int n2 = Math.max(0, Math.min(this.getColumnCount() - 1, listSelectionEvent.getLastIndex()));
        int n3 = 0;
        int n4 = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            n3 = this.selectionModel.getMinSelectionIndex();
            n4 = this.selectionModel.getMaxSelectionIndex();
            int n5 = this.selectionModel.getLeadSelectionIndex();
            if (n3 == -1 && n4 == -1) {
                n3 = n5;
                n4 = n5;
            } else if (n5 != -1) {
                n3 = Math.min(n3, n5);
                n4 = Math.max(n4, n5);
            }
        }
        if (n3 != -1 && n4 != -1) {
            Rectangle rectangle = this.getCellRect(n3, n, false);
            Rectangle rectangle2 = this.getCellRect(n4, n2, false);
            Rectangle rectangle3 = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            this.repaint(rectangle3);
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        if (this.editorComp != null) {
            this.remove(this.editorComp);
            this.repaint(this.editorComp.getBounds());
            this.editorComp = null;
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        if (this.editorComp != null) {
            this.remove(this.editorComp);
            this.setValueAt(this.cellEditor.getCellEditorValue(), this.editingRow, this.editingColumn);
            this.repaint(this.editorComp.getBounds());
            this.editorComp = null;
        }
        this.requestFocusInWindow();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.handleCompleteChange(tableModelEvent);
        } else if (tableModelEvent.getType() == 1) {
            this.handleInsert(tableModelEvent);
        } else if (tableModelEvent.getType() == -1) {
            this.handleDelete(tableModelEvent);
        } else {
            this.handleUpdate(tableModelEvent);
        }
    }

    private void handleCompleteChange(TableModelEvent tableModelEvent) {
        this.clearSelection();
        this.checkSelection();
        this.rowHeights = null;
        if (this.getAutoCreateColumnsFromModel()) {
            this.createDefaultColumnsFromModel();
        } else {
            this.resizeAndRepaint();
        }
    }

    private void handleInsert(TableModelEvent tableModelEvent) {
        int n;
        int n2 = tableModelEvent.getFirstRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = tableModelEvent.getLastRow()) < 0) {
            n = this.getRowCount() - 1;
        }
        this.selectionModel.insertIndexInterval(n2, n - n2 + 1, true);
        this.checkSelection();
        if (this.rowHeights != null) {
            this.rowHeights.insertEntries(n2, n - n2 + 1, this.rowHeight);
            this.repaint();
        } else {
            int n3 = this.getRowHeight();
            Rectangle rectangle = new Rectangle(0, n2 * n3, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n2) * n3);
            this.repaint(rectangle);
        }
        this.revalidate();
    }

    private void handleDelete(TableModelEvent tableModelEvent) {
        int n;
        int n2 = tableModelEvent.getFirstRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = tableModelEvent.getLastRow()) < 0) {
            n = this.getRowCount() - 1;
        }
        this.selectionModel.removeIndexInterval(n2, n);
        this.checkSelection();
        if (this.dataModel.getRowCount() == 0) {
            this.clearSelection();
        }
        if (this.rowHeights != null) {
            this.rowHeights.removeEntries(n2, n - n2 + 1);
            this.repaint();
        } else {
            int n3 = this.getRowHeight();
            int n4 = this.getRowCount() + n - n2 + 1;
            Rectangle rectangle = new Rectangle(0, n2 * n3, this.getColumnModel().getTotalColumnWidth(), (n4 - n2) * n3);
            this.repaint(rectangle);
        }
        this.revalidate();
    }

    private void handleUpdate(TableModelEvent tableModelEvent) {
        if (this.rowHeights == null) {
            Rectangle rectangle;
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getLastRow();
            int n3 = tableModelEvent.getColumn();
            if (n3 == -1) {
                rectangle = new Rectangle(0, n * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
            } else {
                int n4 = this.convertColumnIndexToModel(n3);
                rectangle = this.getCellRect(n, n4, false);
            }
            rectangle.height = (n2 + 1) * this.getRowHeight();
            this.repaint(rectangle);
        } else {
            this.repaint();
        }
    }

    private void checkSelection() {
        TableModel tableModel = this.getModel();
        ListSelectionModel listSelectionModel = this.selectionModel;
        if (tableModel != null) {
            int n = listSelectionModel.getLeadSelectionIndex();
            int n2 = tableModel.getRowCount();
            if (n2 == 0 && n != -1) {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.setAnchorSelectionIndex(-1);
                listSelectionModel.setLeadSelectionIndex(-1);
                listSelectionModel.setValueIsAdjusting(false);
            } else if (n2 != 0 && n == -1) {
                if (listSelectionModel.isSelectedIndex(0)) {
                    listSelectionModel.addSelectionInterval(0, 0);
                } else {
                    listSelectionModel.removeSelectionInterval(0, 0);
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEditing()) {
            this.editingStopped(null);
        }
        int n = Math.max(0, Math.min(this.getRowCount() - 1, listSelectionEvent.getFirstIndex()));
        int n2 = Math.max(0, Math.min(this.getRowCount() - 1, listSelectionEvent.getLastIndex()));
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getCellRect(n2, this.getColumnCount() - 1, false);
        Rectangle rectangle3 = SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
        this.repaint(rectangle3);
    }

    public int columnAtPoint(Point point) {
        int n = this.getColumnCount();
        Dimension dimension = this.getIntercellSpacing();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = point.x;
        for (int i = 0; i < n; ++i) {
            int n3 = tableColumnModel.getColumn(i).getWidth() + (dimension == null ? 0 : dimension.width);
            if (n2 >= 0 && n2 < n3) {
                return i;
            }
            n2 -= n3;
        }
        return -1;
    }

    public int rowAtPoint(Point point) {
        if (point != null) {
            int n;
            int n2 = this.getRowCount();
            int n3 = point.y;
            if (this.rowHeights == null) {
                int n4 = this.getRowHeight();
                n = n3 / n4;
            } else {
                n = this.rowHeights.getIndex(n3);
            }
            if (n < 0 || n >= n2) {
                return -1;
            }
            return n;
        }
        return -1;
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (n >= this.getRowCount()) {
            rectangle.height = this.getHeight();
        } else if (n >= 0) {
            rectangle.height = this.getRowHeight(n);
            rectangle.y = this.rowHeights == null ? n * rectangle.height : this.rowHeights.getPosition(n);
            if (!bl) {
                int n3 = this.getRowMargin();
                rectangle.y += n3 / 2;
                rectangle.height -= n3;
            }
        }
        if (n2 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
        } else if (n2 >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
        } else {
            int n4;
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (n4 = 0; n4 < n2; ++n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            } else {
                for (n4 = tableColumnModel.getColumnCount() - 1; n4 > n2; --n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            }
            rectangle.width = tableColumnModel.getColumn(n2).getWidth();
            if (!bl) {
                n4 = tableColumnModel.getColumnMargin();
                rectangle.x += n4 / 2;
                rectangle.width -= n4;
            }
        }
        return rectangle;
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.getColumnModel().getSelectionModel().clearSelection();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height * n2;
        }
        return rectangle.width * n2;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = this.rowHeight + this.rowMargin;
        int n4 = n3 * n2;
        if (n == 1) {
            int n5 = (rectangle.y + n4 + n3 / 2) / n3 * n3;
            int n6 = rectangle.y + n4 - n5;
            n4 -= n6;
        }
        return n4;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = this.columnModel.getColumn(n2).getCellEditor();
        if (tableCellEditor == null) {
            int n3 = this.convertColumnIndexToModel(n2);
            tableCellEditor = this.getDefaultEditor(this.dataModel.getColumnClass(n3));
        }
        return tableCellEditor;
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (this.defaultEditorsByColumnClass.containsKey(clazz)) {
            return (TableCellEditor)this.defaultEditorsByColumnClass.get(clazz);
        }
        TableTextField tableTextField = new TableTextField(this);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(tableTextField);
        this.defaultEditorsByColumnClass.put(clazz, defaultCellEditor);
        return defaultCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.columnModel.getColumn(n2).getCellRenderer();
        if (tableCellRenderer == null) {
            int n3 = this.convertColumnIndexToModel(n2);
            tableCellRenderer = this.getDefaultRenderer(this.dataModel.getColumnClass(n3));
        }
        return tableCellRenderer;
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (this.defaultRenderersByColumnClass.containsKey(clazz)) {
            return (TableCellRenderer)this.defaultRenderersByColumnClass.get(clazz);
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        this.defaultRenderersByColumnClass.put(clazz, defaultTableCellRenderer);
        return defaultTableCellRenderer;
    }

    public int convertColumnIndexToModel(int n) {
        if (n < 0) {
            return n;
        }
        return this.columnModel.getColumn(n).getModelIndex();
    }

    public int convertColumnIndexToView(int n) {
        if (n < 0) {
            return n;
        }
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (this.columnModel.getColumn(i).getModelIndex() != n) continue;
            return i;
        }
        return -1;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        boolean bl = this.getRowSelectionAllowed();
        boolean bl2 = this.getColumnSelectionAllowed();
        boolean bl3 = false;
        bl3 = bl && bl2 || !bl && !bl2 ? this.isCellSelected(n, n2) : this.isRowSelected(n) && this.getRowSelectionAllowed() || this.isColumnSelected(n2) && this.getColumnSelectionAllowed();
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        boolean bl4 = this.hasFocus() && this.isEnabled() && listSelectionModel.getLeadSelectionIndex() == n && listSelectionModel2.getLeadSelectionIndex() == n2;
        return tableCellRenderer.getTableCellRendererComponent(this, this.dataModel.getValueAt(n, this.convertColumnIndexToModel(n2)), bl3, bl4, n, n2);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowHeight(int n) {
        int n2 = this.rowHeight;
        if (this.rowHeights != null) {
            n2 = this.rowHeights.getSize(n);
        }
        return n2;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getCellSelectionEnabled() {
        return this.getColumnSelectionAllowed() && this.getRowSelectionAllowed();
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    private static int countSelections(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = n2 - n + 1;
                    break;
                }
                case 2: {
                    for (int i = n; i <= n2; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        ++n3;
                    }
                    break;
                }
            }
        }
        return n3;
    }

    private static int[] getSelections(ListSelectionModel listSelectionModel) {
        int n = JTable.countSelections(listSelectionModel);
        int[] nArray = new int[n];
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        if (n2 != -1 && n3 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    nArray[0] = n2;
                    break;
                }
                case 1: {
                    int n5 = n2;
                    while (n5 <= n3) {
                        nArray[n4++] = n5++;
                    }
                    break;
                }
                case 2: {
                    for (int i = n2; i <= n3; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        nArray[n4++] = i;
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    public int getSelectedColumnCount() {
        return JTable.countSelections(this.columnModel.getSelectionModel());
    }

    public int[] getSelectedColumns() {
        return JTable.getSelections(this.columnModel.getSelectionModel());
    }

    public boolean getColumnSelectionAllowed() {
        return this.getColumnModel().getColumnSelectionAllowed();
    }

    public int getSelectedRowCount() {
        return JTable.countSelections(this.selectionModel);
    }

    public int[] getSelectedRows() {
        return JTable.getSelections(this.selectionModel);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJTable accessibleJTable = new AccessibleJTable(this);
            this.addPropertyChangeListener(accessibleJTable);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.addColumnModelListener(accessibleJTable);
            tableColumnModel.getSelectionModel().addListSelectionListener(accessibleJTable);
            this.getSelectionModel().addListSelectionListener(accessibleJTable);
            this.accessibleContext = accessibleJTable;
        }
        return this.accessibleContext;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.columnModel.getColumnMargin(), this.rowMargin);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removeColumn(TableColumn tableColumn) {
        this.columnModel.removeColumn(tableColumn);
    }

    public void moveColumn(int n, int n2) {
        this.columnModel.moveColumn(n, n2);
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        if (this.autoCreateColumnsFromModel != bl) {
            this.autoCreateColumnsFromModel = bl;
            if (bl) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public void setAutoResizeMode(int n) {
        this.autoResizeMode = n;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.clientRowHeightSet = true;
        this.rowHeight = n;
        this.rowHeights = null;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n, int n2) {
        if (this.rowHeights == null) {
            this.rowHeights = new SizeSequence(this.getRowCount(), this.rowHeight);
        }
        this.rowHeights.setSize(n, n2);
    }

    public void setRowMargin(int n) {
        this.rowMargin = n;
        this.revalidate();
        this.repaint();
    }

    public void setRowSelectionAllowed(boolean bl) {
        if (this.rowSelectionAllowed != bl) {
            this.rowSelectionAllowed = bl;
            this.firePropertyChange("rowSelectionAllowed", bl ^ true, bl);
            this.repaint();
        }
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.setColumnSelectionAllowed(bl);
        this.setRowSelectionAllowed(bl);
        this.cellSelectionEnabled = true;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataModel == tableModel) {
            return;
        }
        TableModel tableModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        if (tableModel != null) {
            this.dataModel = tableModel;
            this.dataModel.addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.dataModel, -1));
            if (this.autoCreateColumnsFromModel) {
                this.createDefaultColumnsFromModel();
            }
        }
        this.firePropertyChange("model", tableModel2, this.dataModel);
        this.revalidate();
        this.repaint();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException();
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel2 != null) {
            tableColumnModel2.removeColumnModelListener(this);
        }
        if (tableColumnModel != null) {
            tableColumnModel.addColumnModelListener(this);
        }
        this.columnModel = tableColumnModel;
        if (this.dataModel != null && this.columnModel != null) {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = this.columnModel.getColumn(i);
                if (tableColumn.getHeaderValue() != null) continue;
                tableColumn.setHeaderValue(this.dataModel.getColumnName(i));
            }
        }
        if (this.tableHeader != null) {
            this.tableHeader.setColumnModel(tableColumnModel);
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSelectionAllowed(boolean bl) {
        if (this.columnModel.getColumnSelectionAllowed() != bl) {
            this.columnModel.setColumnSelectionAllowed(bl);
            this.firePropertyChange("columnSelectionAllowed", bl ^ true, bl);
            this.repaint();
        }
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this);
        }
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this);
        }
        this.selectionModel = listSelectionModel;
        this.checkSelection();
    }

    public void setSelectionMode(int n) {
        this.selectionModel.setSelectionMode(n);
        this.columnModel.getSelectionModel().setSelectionMode(n);
        this.repaint();
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        if (tableCellEditor2 != null) {
            tableCellEditor2.removeCellEditorListener(this);
        }
        if (tableCellEditor != null) {
            tableCellEditor.addCellEditorListener(this);
        }
        this.cellEditor = tableCellEditor;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.repaint();
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.rowMargin = dimension.height;
        this.columnModel.setColumnMargin(dimension.width);
        this.repaint();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
        this.revalidate();
        this.repaint();
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        if (color2 == null && color != null || color == null && color2 != null || color2 != null && color != null && !color2.equals(color)) {
            this.firePropertyChange(SELECTION_BACKGROUND_CHANGED_PROPERTY, color2, color);
        }
        this.repaint();
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        if (color2 == null && color != null || color == null && color2 != null || color2 != null && color != null && !color2.equals(color)) {
            this.firePropertyChange(SELECTION_FOREGROUND_CHANGED_PROPERTY, color2, color);
        }
        this.repaint();
    }

    public void setShowGrid(boolean bl) {
        this.setShowVerticalLines(bl);
        this.setShowHorizontalLines(bl);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.showHorizontalLines = bl;
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl) {
        this.showVerticalLines = bl;
        this.repaint();
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.setTable(null);
        }
        this.tableHeader = jTableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.setTable(this);
        }
        this.revalidate();
        this.repaint();
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jScrollPane != null && this.tableHeader != null) {
            jScrollPane.setColumnHeaderView(this.tableHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jScrollPane != null) {
            jScrollPane.setColumnHeaderView(null);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void removeNotify() {
        super.addNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private void distributeSpill(TableColumn[] tableColumnArray, int n) {
        int n2 = n / tableColumnArray.length;
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null) continue;
            tableColumnArray[i].setWidth(tableColumnArray[i].getPreferredWidth() + n2);
        }
    }

    private void distributeSpillResizing(TableColumn[] tableColumnArray, int n, TableColumn tableColumn) {
        int n2 = 0;
        if (tableColumnArray.length != 1) {
            n2 = n / (tableColumnArray.length - 1);
        }
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null || tableColumnArray[i].equals(tableColumn)) continue;
            tableColumnArray[i].setWidth(tableColumnArray[i].getPreferredWidth() + n2);
        }
        tableColumn.setWidth(tableColumn.getPreferredWidth());
    }

    public void doLayout() {
        int n;
        TableColumn[] tableColumnArray;
        int n2;
        TableColumn tableColumn = null;
        int n3 = this.getColumnCount();
        if (n3 < 1) {
            return;
        }
        int n4 = 0;
        int n5 = -1;
        if (this.tableHeader != null) {
            tableColumn = this.tableHeader.getResizingColumn();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            tableColumnArray = this.columnModel.getColumn(n2);
            n = tableColumnArray.getPreferredWidth();
            n4 += n;
            if (tableColumn != tableColumnArray) continue;
            n5 = n2;
        }
        n2 = this.getWidth() - n4;
        if (tableColumn != null) {
            switch (this.getAutoResizeMode()) {
                case 3: {
                    TableColumn tableColumn2 = this.columnModel.getColumn(n3 - 1);
                    tableColumn2.setWidth(tableColumn2.getPreferredWidth() + n2);
                    break;
                }
                case 1: {
                    TableColumn tableColumn3 = this.columnModel.getColumn(n3 - 1);
                    tableColumn3.setWidth(tableColumn3.getPreferredWidth() + n2);
                    break;
                }
                case 4: {
                    tableColumnArray = new TableColumn[n3];
                    for (int i = 0; i < n3; ++i) {
                        tableColumnArray[i] = this.columnModel.getColumn(i);
                    }
                    this.distributeSpillResizing(tableColumnArray, n2, tableColumn);
                    break;
                }
                case 2: {
                    TableColumn tableColumn4;
                    int n6;
                    int n7 = 0;
                    int n8 = 0;
                    for (n6 = 0; n6 < n5; ++n6) {
                        tableColumn4 = this.columnModel.getColumn(n6);
                        n7 += tableColumn4.getWidth();
                        n8 += tableColumn4.getPreferredWidth();
                    }
                    n6 = n3 - n5 - 1;
                    if (n6 > 0) {
                        n2 = this.getWidth() - n7 - (n4 - n8);
                        int n9 = n2 / n6;
                        for (int i = n5 + 1; i < n3; ++i) {
                            tableColumn4 = this.columnModel.getColumn(i);
                            tableColumn4.setWidth(tableColumn4.getPreferredWidth() + n9);
                        }
                    }
                    tableColumn.setWidth(tableColumn.getPreferredWidth());
                    break;
                }
                default: {
                    int n10 = tableColumn.getPreferredWidth();
                    tableColumn.setWidth(n10);
                    break;
                }
            }
        } else {
            tableColumnArray = new TableColumn[n3];
            for (n = 0; n < n3; ++n) {
                tableColumnArray[n] = this.columnModel.getColumn(n);
            }
            this.distributeSpill(tableColumnArray, n2);
        }
        if (this.editorComp != null) {
            this.moveToCellBeingEdited(this.editorComp);
        }
        int n11 = this.getLeftResizingBoundary();
        int n12 = this.getWidth() - n11;
        this.repaint(n11, 0, n12, this.getHeight());
        if (this.tableHeader != null) {
            this.tableHeader.repaint(n11, 0, n12, this.tableHeader.getHeight());
        }
    }

    int getLeftResizingBoundary() {
        if (this.tableHeader == null || this.getAutoResizeMode() == 4) {
            return 0;
        }
        TableColumn tableColumn = this.tableHeader.getResizingColumn();
        if (tableColumn == null) {
            return 0;
        }
        int n = this.convertColumnIndexToView(tableColumn.getModelIndex());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.columnModel.getColumn(i).getWidth();
        }
        return n2;
    }

    public void sizeColumnsToFit(boolean bl) {
        this.doLayout();
    }

    public void sizeColumnsToFit(int n) {
        this.doLayout();
    }

    public String getUIClassID() {
        return "TableUI";
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
        this.createDefaultEditors();
        this.createDefaultRenderers();
    }

    public void updateUI() {
        this.setUI((TableUI)UIManager.getUI(this));
    }

    public Class getColumnClass(int n) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n));
    }

    public String getColumnName(int n) {
        int n2 = this.columnModel.getColumn(n).getModelIndex();
        return this.dataModel.getColumnName(n2);
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public void setDefaultEditor(Class clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public void addColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().addSelectionInterval(n, n2);
    }

    public void addRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void setColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().setSelectionInterval(n, n2);
    }

    public void setRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void removeColumnSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getColumnCount() - 1 || n2 < 0 || n2 > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range.");
        }
        this.getColumnModel().getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void removeRowSelectionInterval(int n, int n2) {
        if (n < 0 || n > this.getRowCount() - 1 || n2 < 0 || n2 > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range.");
        }
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public boolean isColumnSelected(int n) {
        return this.getColumnModel().getSelectionModel().isSelectedIndex(n);
    }

    public boolean isRowSelected(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        return this.isRowSelected(n) && this.isColumnSelected(n2);
    }

    public void selectAll() {
        if (this.getRowCount() == 0 || this.getColumnCount() == 0) {
            return;
        }
        int n = this.selectionModel.getLeadSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.setRowSelectionInterval(0, this.getRowCount() - 1);
        this.addColumnSelectionInterval(n2, n2);
        this.addRowSelectionInterval(n, n);
    }

    public Object getValueAt(int n, int n2) {
        return this.dataModel.getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.dataModel.setValueAt(object, n, this.convertColumnIndexToModel(n2));
        this.repaint(this.getCellRect(n, n2, true));
    }

    public TableColumn getColumn(Object object) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(object));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.dataModel.isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    public void createDefaultColumnsFromModel() {
        if (!$assertionsDisabled && this.columnModel == null) {
            throw new AssertionError((Object)"The columnModel must not be null.");
        }
        for (int i = this.columnModel.getColumnCount() - 1; i >= 0; --i) {
            this.columnModel.removeColumn(this.columnModel.getColumn(i));
        }
        int n = this.dataModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(this.dataModel.getColumnName(i));
            tableColumn.setHeaderValue(this.dataModel.getColumnName(i));
            this.columnModel.addColumn(tableColumn);
            tableColumn.addPropertyChangeListener(this.tableColumnPropertyChangeHandler);
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.selectionModel.setAnchorSelectionIndex(n);
            this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
        } else if (bl) {
            if (this.isCellSelected(n, n2)) {
                this.selectionModel.removeSelectionInterval(n, n);
                this.getColumnModel().getSelectionModel().removeSelectionInterval(n2, n2);
            } else {
                this.selectionModel.addSelectionInterval(n, n);
                this.getColumnModel().getSelectionModel().addSelectionInterval(n2, n2);
            }
        } else if (bl2) {
            this.selectionModel.setLeadSelectionIndex(n);
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
        } else {
            this.selectionModel.clearSelection();
            this.selectionModel.setSelectionInterval(n, n);
            this.getColumnModel().getSelectionModel().clearSelection();
            this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    public boolean editCellAt(int n, int n2) {
        TableCellEditor tableCellEditor;
        if (this.isEditing()) {
            this.editingStopped(new ChangeEvent("editingStopped"));
        }
        if ((tableCellEditor = this.getCellEditor(n, n2)) == this.booleanInvertingEditor && this.isCellEditable(n, n2)) {
            if (Boolean.TRUE.equals(this.getValueAt(n, n2))) {
                this.setValueAt(Boolean.FALSE, n, n2);
            } else {
                this.setValueAt(Boolean.TRUE, n, n2);
            }
            return false;
        }
        this.editingRow = n;
        this.editingColumn = n2;
        this.setCellEditor(tableCellEditor);
        this.editorComp = this.prepareEditor(this.cellEditor, n, n2);
        this.removeAll();
        this.add(this.editorComp);
        this.moveToCellBeingEdited(this.editorComp);
        this.scrollRectToVisible(this.editorComp.getBounds());
        this.editorComp.requestFocusInWindow();
        return tableCellEditor.shouldSelectCell(null);
    }

    private void moveToCellBeingEdited(Component component) {
        Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, true);
        --rectangle.x;
        --rectangle.y;
        ++rectangle.width;
        ++rectangle.height;
        component.setBounds(rectangle);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        return this.editCellAt(n, n2);
    }

    public void removeEditor() {
        this.editingStopped(new ChangeEvent(this));
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        return tableCellEditor.getTableCellEditorComponent(this, this.getValueAt(n, n2), this.isCellSelected(n, n2), n, n2);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setSurrendersFocusOnKeystroke(boolean bl) {
        this.surrendersFocusOnKeystroke = bl;
    }

    public boolean getSurrendersFocusOnKeystroke() {
        return this.surrendersFocusOnKeystroke;
    }

    void setUIProperty(String string, Object object) {
        if (string.equals("rowHeight")) {
            if (!this.clientRowHeightSet) {
                this.setRowHeight((Integer)object);
                this.clientRowHeightSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    static {
        SELECTION_BACKGROUND_CHANGED_PROPERTY = SELECTION_BACKGROUND_CHANGED_PROPERTY;
        SELECTION_FOREGROUND_CHANGED_PROPERTY = SELECTION_FOREGROUND_CHANGED_PROPERTY;
        $assertionsDisabled = JTable.class$("javax.swing.JTable").desiredAssertionStatus() ^ true;
    }

    private class TableTextField
    extends JTextField {
        private /* synthetic */ JTable this$0;

        TableTextField(JTable jTable) {
            this.this$0 = jTable;
            this.setBorder(BorderFactory.createLineBorder(jTable.getGridColor(), 2));
        }
    }

    private class IconCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        IconCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Icon) {
                Icon icon = (Icon)object;
                this.setIcon(icon);
            } else {
                this.setIcon(null);
            }
            this.setText("");
            return this;
        }
    }

    private class NumberCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public NumberCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }
    }

    private class FloatCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public FloatCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Float) {
                Float f = (Float)object;
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setText(numberFormat.format(f.floatValue()));
            }
            return this;
        }
    }

    private class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public DoubleCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Double) {
                Double d = (Double)object;
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setText(numberFormat.format(d));
            }
            return this;
        }
    }

    private class DateCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                Date date = (Date)object;
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                this.setText(dateFormat.format(date));
            }
            return this;
        }

        DateCellRenderer(JTable jTable) {
            this.this$0 = jTable;
        }
    }

    private class BooleanCellRenderer
    extends DefaultTableCellRenderer {
        private /* synthetic */ JTable this$0;
        private final JCheckBox checkBox = new JCheckBox();

        BooleanCellRenderer(JTable jTable) {
            this.this$0 = jTable;
            this.checkBox.setHorizontalAlignment(0);
        }

        JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.checkBox.setBackground(jTable.getSelectionBackground());
                this.checkBox.setForeground(jTable.getSelectionForeground());
            } else {
                this.checkBox.setBackground(jTable.getBackground());
                this.checkBox.setForeground(jTable.getForeground());
            }
            if (bl2) {
                this.checkBox.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (jTable.isCellEditable(n, n2)) {
                    this.checkBox.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    this.checkBox.setForeground(UIManager.getColor("Table.focusCellForeground"));
                }
            } else {
                this.checkBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            if (object == null) {
                this.checkBox.setSelected(false);
            } else {
                Boolean bl3 = (Boolean)object;
                this.checkBox.setSelected(bl3);
            }
            return this.checkBox;
        }
    }

    class TableColumnPropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ JTable this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTableHeader jTableHeader;
            if (propertyChangeEvent.getPropertyName().equals("preferredWidth") && (jTableHeader = this.this$0.getTableHeader()) != null && jTableHeader.getResizingColumn() == null) {
                TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
                jTableHeader.setResizingColumn(tableColumn);
                this.this$0.doLayout();
                jTableHeader.setResizingColumn(null);
            }
        }

        TableColumnPropertyChangeHandler(JTable jTable) {
            this.this$0 = jTable;
        }
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        private /* synthetic */ JTable this$0;
        private int lastSelectedRow;
        private int lastSelectedColumn;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescriptions;
        private Accessible[] columnDescriptions;

        static /* synthetic */ JTable access$2(AccessibleJTable accessibleJTable, JTable jTable) {
            accessibleJTable.this$0 = jTable;
            return accessibleJTable.this$0;
        }

        static JTable access$0(AccessibleJTable accessibleJTable) {
            return accessibleJTable.this$0;
        }

        protected AccessibleJTable(JTable jTable) {
            this.this$0 = jTable;
            super(jTable);
            jTable.getModel().addTableModelListener(this);
            jTable.getSelectionModel().addListSelectionListener(this);
            jTable.getColumnModel().addColumnModelListener(this);
            this.lastSelectedRow = jTable.getSelectedRow();
            this.lastSelectedColumn = jTable.getSelectedColumn();
            TableCellEditor tableCellEditor = jTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.addCellEditorListener(this);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectedColumnCount();
        }

        public Accessible getAccessibleSelection(int n) {
            Accessible accessible = null;
            int[] nArray = this.this$0.getSelectedRows();
            int[] nArray2 = this.this$0.getSelectedColumns();
            int n2 = this.this$0.getColumnCount();
            int n3 = this.this$0.getRowCount();
            if (this.this$0.getRowSelectionAllowed() && this.this$0.getColumnSelectionAllowed()) {
                int n4;
                int n5;
                int n6 = n5 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n < nArray.length) {
                    n4 = nArray[n8];
                    int n9 = -1;
                    int n10 = -1;
                    for (n9 = n7 + 1; n9 < n4 && n5 < n; ++n9) {
                        for (n10 = 0; n10 < nArray2.length && n5 < n; ++n5, ++n10) {
                        }
                    }
                    if (n5 == n) {
                        accessible = this.getAccessibleChild(n9 * n2 + nArray2[n10]);
                        break;
                    }
                    if (n5 < n && n5 + n2 >= n) {
                        accessible = this.getAccessibleChild(n9 * n2 + (n - n5));
                        break;
                    }
                    n5 += n2;
                    ++n;
                }
                if (accessible == null) {
                    n8 = 0;
                    n4 = 0;
                    for (n8 = n7 + 1; n8 < n3 && n5 < n; ++n8) {
                        for (n4 = 0; n4 < nArray2.length && n5 < n; ++n5, ++n4) {
                        }
                    }
                    if (n5 == n) {
                        accessible = this.getAccessibleChild(n8 * n2 + nArray2[n4]);
                    }
                }
            } else if (this.this$0.getRowSelectionAllowed()) {
                int n11 = n % n2;
                int n12 = nArray[n / n2];
                accessible = this.getAccessibleChild(n12 * n2 + n11);
            } else if (this.this$0.getRowSelectionAllowed()) {
                int n13 = nArray2.length;
                int n14 = nArray2[n % n13];
                int n15 = n / n13;
                accessible = this.getAccessibleChild(n15 * n2 + n14);
            }
            return accessible;
        }

        public boolean isAccessibleChildSelected(int n) {
            int n2 = this.getAccessibleRowAtIndex(n);
            int n3 = this.getAccessibleColumnAtIndex(n);
            return this.this$0.isCellSelected(n2, n3);
        }

        public void addAccessibleSelection(int n) {
            int n2 = this.getAccessibleRowAtIndex(n);
            int n3 = this.getAccessibleColumnAtIndex(n);
            this.this$0.changeSelection(n2, n3, true, false);
        }

        public void removeAccessibleSelection(int n) {
            if (!this.this$0.getRowSelectionAllowed() && !this.this$0.getColumnSelectionAllowed()) {
                int n2 = this.getAccessibleRowAtIndex(n);
                int n3 = this.getAccessibleColumnAtIndex(n);
                this.this$0.removeRowSelectionInterval(n2, n2);
                this.this$0.removeColumnSelectionInterval(n3, n3);
            }
        }

        public void clearAccessibleSelection() {
            this.this$0.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            this.this$0.selectAll();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
            int n = this.this$0.getSelectedRow();
            int n2 = this.this$0.getSelectedColumn();
            if (n != this.lastSelectedRow || n2 != this.lastSelectedColumn) {
                Accessible accessible = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedColumn);
                Accessible accessible2 = this.getAccessibleAt(n, n2);
                this.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
                this.lastSelectedRow = n;
                this.lastSelectedColumn = n2;
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent);
                    break;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent);
                }
            }
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
            this.handleRowChange(tableModelEvent);
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
            this.handleRowChange(tableModelEvent);
        }

        private void handleRowChange(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getColumn();
            if (n == -1) {
                n = 0;
                n2 = this.this$0.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n, n2);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(1, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(-1, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            this.handleColumnChange(-1, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getFromIndex());
            this.handleColumnChange(1, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
        }

        private void handleColumnChange(int n, int n2, int n3) {
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(this, n, 0, 0, n2, n3);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tableModel")) {
                TableModel tableModel = (TableModel)propertyChangeEvent.getOldValue();
                tableModel.removeTableModelListener(this);
                TableModel tableModel2 = (TableModel)propertyChangeEvent.getNewValue();
                tableModel2.addTableModelListener(this);
            } else if (string.equals("columnModel")) {
                TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getOldValue();
                tableColumnModel.removeColumnModelListener(this);
                TableColumnModel tableColumnModel2 = (TableColumnModel)propertyChangeEvent.getNewValue();
                tableColumnModel2.addColumnModelListener(this);
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(this);
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                listSelectionModel2.addListSelectionListener(this);
            } else if (string.equals("cellEditor")) {
                CellEditor cellEditor = (CellEditor)propertyChangeEvent.getOldValue();
                cellEditor.removeCellEditorListener(this);
                CellEditor cellEditor2 = (CellEditor)propertyChangeEvent.getNewValue();
                cellEditor2.addCellEditorListener(this);
            }
        }

        public int getAccessibleRow(int n) {
            return this.getAccessibleRowAtIndex(n);
        }

        public int getAccessibleColumn(int n) {
            return this.getAccessibleColumnAtIndex(n);
        }

        public int getAccessibleIndex(int n, int n2) {
            return this.getAccessibleIndexAt(n, n2);
        }

        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        public void setAccessibleCaption(Accessible accessible) {
            this.caption = accessible;
        }

        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        public void setAccessibleSummary(Accessible accessible) {
            this.summary = accessible;
        }

        public int getAccessibleRowCount() {
            return this.this$0.getRowCount();
        }

        public int getAccessibleColumnCount() {
            return this.this$0.getColumnCount();
        }

        public Accessible getAccessibleChild(int n) {
            int n2 = this.getAccessibleRow(n);
            int n3 = this.getAccessibleColumn(n);
            return this.getAccessibleAt(n2, n3);
        }

        public Accessible getAccessibleAt(int n, int n2) {
            TableCellRenderer tableCellRenderer = this.this$0.getCellRenderer(n, n2);
            Component component = tableCellRenderer.getTableCellRendererComponent(this.this$0, this.this$0.getValueAt(n, n2), this.this$0.isCellSelected(n, n2), false, n, n2);
            if (component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        public int getAccessibleRowExtentAt(int n, int n2) {
            return 1;
        }

        public int getAccessibleColumnExtentAt(int n, int n2) {
            return 1;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader jTableHeader = this.this$0.getTableHeader();
            AccessibleTableHeader accessibleTableHeader = null;
            if (jTableHeader != null) {
                accessibleTableHeader = new AccessibleTableHeader(this, jTableHeader);
            }
            return accessibleTableHeader;
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public Accessible getAccessibleRowDescription(int n) {
            Accessible accessible = null;
            if (this.rowDescriptions != null) {
                accessible = this.rowDescriptions[n];
            }
            return accessible;
        }

        public void setAccessibleRowDescription(int n, Accessible accessible) {
            if (this.rowDescriptions == null) {
                this.rowDescriptions = new Accessible[this.getAccessibleRowCount()];
            }
            this.rowDescriptions[n] = accessible;
        }

        public Accessible getAccessibleColumnDescription(int n) {
            Accessible accessible = null;
            if (this.columnDescriptions != null) {
                accessible = this.columnDescriptions[n];
            }
            return accessible;
        }

        public void setAccessibleColumnDescription(int n, Accessible accessible) {
            if (this.columnDescriptions == null) {
                this.columnDescriptions = new Accessible[this.getAccessibleRowCount()];
            }
            this.columnDescriptions[n] = accessible;
        }

        public boolean isAccessibleSelected(int n, int n2) {
            return this.this$0.isCellSelected(n, n2);
        }

        public boolean isAccessibleRowSelected(int n) {
            return this.this$0.isRowSelected(n);
        }

        public boolean isAccessibleColumnSelected(int n) {
            return this.this$0.isColumnSelected(n);
        }

        public int[] getSelectedAccessibleRows() {
            return this.this$0.getSelectedRows();
        }

        public int[] getSelectedAccessibleColumns() {
            return this.this$0.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int n) {
            return n / this.this$0.getColumnCount();
        }

        public int getAccessibleColumnAtIndex(int n) {
            return n % this.this$0.getColumnCount();
        }

        public int getAccessibleIndexAt(int n, int n2) {
            return n * this.this$0.getColumnCount() + n2;
        }

        private class AccessibleJTableHeaderCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private /* synthetic */ AccessibleJTable this$1;
            JTableHeader header;
            int columnIndex;

            AccessibleJTableHeaderCell(AccessibleJTable accessibleJTable, JTableHeader jTableHeader, Component component, int n, int n2) {
                this.this$1 = accessibleJTable;
                this.header = jTableHeader;
                this.columnIndex = n2;
            }

            Component getColumnHeaderRenderer() {
                TableColumn tableColumn = this.header.getColumnModel().getColumn(this.columnIndex);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.header.getDefaultRenderer();
                }
                return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, this.columnIndex);
            }

            public AccessibleRole getAccessibleRole() {
                Component component = this.getColumnHeaderRenderer();
                if (component instanceof Accessible) {
                    Accessible accessible = (Accessible)((Object)component);
                    return accessible.getAccessibleContext().getAccessibleRole();
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return null;
            }

            public int getAccessibleIndexInParent() {
                return 0;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return null;
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return null;
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return null;
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return null;
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return null;
            }

            public boolean isEnabled() {
                return false;
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isVisible() {
                return false;
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return false;
            }

            public boolean contains(Point point) {
                return false;
            }

            public Point getLocationOnScreen() {
                return null;
            }

            public Point getLocation() {
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return null;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return null;
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return false;
            }

            public void requestFocus() {
            }

            public void addFocusListener(FocusListener focusListener) {
            }

            public void removeFocusListener(FocusListener focusListener) {
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private /* synthetic */ AccessibleJTable this$1;
            private JTableHeader header;

            AccessibleTableHeader(AccessibleJTable accessibleJTable, JTableHeader jTableHeader) {
                this.this$1 = accessibleJTable;
                this.header = jTableHeader;
            }

            public Accessible getAccessibleCaption() {
                return null;
            }

            public void setAccessibleCaption(Accessible accessible) {
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public void setAccessibleSummary(Accessible accessible) {
            }

            public int getAccessibleRowCount() {
                return 1;
            }

            public int getAccessibleColumnCount() {
                return this.header.getColumnModel().getColumnCount();
            }

            public Accessible getAccessibleAt(int n, int n2) {
                TableColumn tableColumn = this.header.getColumnModel().getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.header.getDefaultRenderer();
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
                return new AccessibleJTableHeaderCell(this.this$1, this.header, component, n, n2);
            }

            public int getAccessibleRowExtentAt(int n, int n2) {
                return 0;
            }

            public int getAccessibleColumnExtentAt(int n, int n2) {
                return 0;
            }

            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            public Accessible getAccessibleRowDescription(int n) {
                return null;
            }

            public void setAccessibleRowDescription(int n, Accessible accessible) {
            }

            public Accessible getAccessibleColumnDescription(int n) {
                return null;
            }

            public void setAccessibleColumnDescription(int n, Accessible accessible) {
            }

            public boolean isAccessibleSelected(int n, int n2) {
                return false;
            }

            public boolean isAccessibleRowSelected(int n) {
                return false;
            }

            public boolean isAccessibleColumnSelected(int n) {
                return false;
            }

            public int[] getSelectedAccessibleRows() {
                return null;
            }

            public int[] getSelectedAccessibleColumns() {
                return null;
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            private /* synthetic */ AccessibleJTable this$1;
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(AccessibleJTable accessibleJTable, int n, int n2, int n3, int n4, int n5) {
                this.this$1 = accessibleJTable;
                this.type = n;
                this.firstRow = n2;
                this.lastRow = n3;
                this.firstColumn = n4;
                this.lastColumn = n5;
            }

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private /* synthetic */ AccessibleJTable this$1;
            private JTable table;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(AccessibleJTable accessibleJTable, JTable jTable, int n, int n2, int n3) {
                this.this$1 = accessibleJTable;
                this.table = jTable;
                this.row = n;
                this.column = n2;
                this.index = n3;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                Rectangle rectangle2 = this.this$1.this$0.getVisibleRect();
                if (rectangle2.intersects(rectangle = this.this$1.this$0.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
                if (this.this$1.this$0.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.row == this.this$1.this$0.getSelectedRow() && this.column == this.this$1.this$0.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                return null;
            }

            public Locale getLocale() {
                return Locale.ENGLISH;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.table.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.table.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.table.getCursor();
            }

            public void setCursor(Cursor cursor) {
            }

            public Font getFont() {
                return this.table.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.table.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.table.isEnabled();
            }

            public void setEnabled(boolean bl) {
            }

            public boolean isVisible() {
                return this.table.isVisible();
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return this.table.isShowing();
            }

            public boolean contains(Point point) {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                rectangle.x = 0;
                rectangle.y = 0;
                return rectangle.contains(point);
            }

            public Point getLocationOnScreen() {
                Point point = this.table.getLocationOnScreen();
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                point.x += rectangle.x;
                point.y += rectangle.y;
                return point;
            }

            public Point getLocation() {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                return new Point(rectangle.x, rectangle.y);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.table.getCellRect(this.row, this.column, true);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle rectangle = this.table.getCellRect(this.row, this.column, true);
                return new Dimension(rectangle.width, rectangle.height);
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return this.table.isFocusable();
            }

            public void requestFocus() {
                this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(this.column);
                this.table.getSelectionModel().setLeadSelectionIndex(this.row);
                this.table.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                this.table.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.table.removeFocusListener(focusListener);
            }
        }
    }
}

