/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private static final long serialVersionUID = 532615968316031794L;
    protected static final Component component = new Component(null){
        private /* synthetic */ ImageIcon this$0;
        {
            this.this$0 = imageIcon;
        }
    };
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static int id;
    Image image;
    String description;
    ImageObserver observer;
    private int loadStatus;
    private AccessibleContext accessibleContext;

    public ImageIcon() {
    }

    public ImageIcon(String string) {
        this(string, string);
    }

    public ImageIcon(String string, String string2) {
        this(Toolkit.getDefaultToolkit().getImage(string), string2);
    }

    public ImageIcon(byte[] byArray) {
        this(byArray, null);
    }

    public ImageIcon(byte[] byArray, String string) {
        this(Toolkit.getDefaultToolkit().createImage(byArray), string);
    }

    public ImageIcon(URL uRL) {
        this(uRL, uRL.toString());
    }

    public ImageIcon(URL uRL, String string) {
        this(Toolkit.getDefaultToolkit().getImage(uRL), string);
    }

    public ImageIcon(Image image) {
        this(image, null);
    }

    public ImageIcon(Image image, String string) {
        this.setImage(image);
        this.setDescription(string);
    }

    public ImageObserver getImageObserver() {
        return this.observer;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.observer = imageObserver;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.loadImage(image);
        this.image = image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getIconHeight() {
        if (this.image == null) {
            return -1;
        }
        return this.image.getHeight(this.observer);
    }

    public int getIconWidth() {
        if (this.image == null) {
            return -1;
        }
        return this.image.getWidth(this.observer);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, this.observer != null ? this.observer : component);
    }

    protected void loadImage(Image image) {
        try {
            try {
                tracker.addImage(image, id);
                tracker.waitForID(++id - 1);
            }
            catch (InterruptedException interruptedException) {
            }
            Object var2_3 = null;
            this.loadStatus = tracker.statusID(id - 1, false);
            tracker.removeImage(image, id - 1);
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.loadStatus = tracker.statusID(id - 1, false);
            tracker.removeImage(image, id - 1);
            throw throwable;
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageIcon(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleImageIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private /* synthetic */ ImageIcon this$0;
        private static final long serialVersionUID = 2113430526551336564L;

        protected AccessibleImageIcon(ImageIcon imageIcon) {
            this.this$0 = imageIcon;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return this.this$0.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            this.this$0.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return this.this$0.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return this.this$0.getIconWidth();
        }
    }
}

