/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultButtonModel
implements ButtonModel,
Serializable {
    private static final long serialVersionUID = -5342609566534980231L;
    public static final int ARMED = 1;
    public static final int ENABLED = 8;
    public static final int PRESSED = 4;
    public static final int ROLLOVER = 16;
    public static final int SELECTED = 2;
    protected int stateMask;
    protected EventListenerList listenerList;
    protected ChangeEvent changeEvent;
    protected ButtonGroup group;
    protected int mnemonic;
    protected String actionCommand;

    private /* synthetic */ void finit$() {
        this.stateMask = 8;
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
        this.mnemonic = 0;
    }

    public DefaultButtonModel() {
        this.finit$();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(DefaultButtonModel.class$("java.awt.event.ActionListener"), actionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(DefaultButtonModel.class$("java.awt.event.ActionListener"), actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(DefaultButtonModel.class$("java.awt.event.ActionListener"));
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(DefaultButtonModel.class$("java.awt.event.ItemListener"), itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(DefaultButtonModel.class$("java.awt.event.ItemListener"), itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(DefaultButtonModel.class$("java.awt.event.ItemListener"));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(DefaultButtonModel.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(DefaultButtonModel.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(DefaultButtonModel.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        ItemListener[] itemListenerArray = this.getItemListeners();
        for (int i = 0; i < itemListenerArray.length; ++i) {
            itemListenerArray[i].itemStateChanged(itemEvent);
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    public void setArmed(boolean bl) {
        if (bl && this.isArmed() || !bl && !this.isArmed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    public boolean isEnabled() {
        return (this.stateMask & 8) != 0;
    }

    public void setEnabled(boolean bl) {
        if (bl && this.isEnabled() || !bl && !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 8) : this.stateMask & 0xFFFFFFF7 & 0xFFFFFFFE & 0xFFFFFFFB;
        this.fireStateChanged();
    }

    public void setPressed(boolean bl) {
        if (bl && this.isPressed() || !bl && !this.isPressed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!bl && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
        this.fireStateChanged();
    }

    public boolean isPressed() {
        return (this.stateMask & 4) != 0;
    }

    public void setRollover(boolean bl) {
        if (bl && this.isRollover() || !bl && !this.isRollover()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    public void setSelected(boolean bl) {
        if (bl && this.isSelected() || !bl && !this.isSelected()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        if (bl) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            if (this.group != null) {
                this.group.setSelected(this, true);
            }
        } else {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 2));
            if (this.group != null) {
                this.group.setSelected(this, false);
            }
        }
    }

    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    public boolean isRollover() {
        return (this.stateMask & 0x10) != 0;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int n) {
        if (this.mnemonic != n) {
            this.mnemonic = n;
            this.fireStateChanged();
        }
    }

    public void setActionCommand(String string) {
        if (this.actionCommand != string) {
            this.actionCommand = string;
            this.fireStateChanged();
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }
}

