/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintRequestAttribute;

public final class MediaPrintableArea
implements DocAttribute,
PrintJobAttribute,
PrintRequestAttribute {
    private static final long serialVersionUID = -1597171464050795793L;
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private int x;
    private int y;
    private int w;
    private int h;

    public MediaPrintableArea(float f, float f2, float f3, float f4, int n) {
        if (f < 0.0f || f2 < 0.0f || f3 <= 0.0f || f4 <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.x = (int)(f * (float)n + 0.5f);
        this.y = (int)(f2 * (float)n + 0.5f);
        this.w = (int)(f3 * (float)n + 0.5f);
        this.h = (int)(f4 * (float)n + 0.5f);
    }

    public MediaPrintableArea(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n2 < 0 || n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException();
        }
        this.x = n * n5;
        this.y = n2 * n5;
        this.w = n3 * n5;
        this.h = n4 * n5;
    }

    public Class getCategory() {
        return MediaPrintableArea.class$("javax.print.attribute.standard.MediaPrintableArea");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getName() {
        return "media-printable-area";
    }

    public float getHeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.h / (float)n;
    }

    public float getWidth(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.w / (float)n;
    }

    public float getX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.x / (float)n;
    }

    public float getY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        return (float)this.y / (float)n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MediaPrintableArea)) {
            return false;
        }
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)object;
        return (float)this.x == mediaPrintableArea.getX(1) && (float)this.y == mediaPrintableArea.getY(1) && (float)this.w == mediaPrintableArea.getWidth(1) && (float)this.h == mediaPrintableArea.getHeight(1);
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public int hashCode() {
        return this.x ^ this.y + this.w ^ this.h;
    }

    public String toString(int n, String string) {
        if (n < 1) {
            throw new IllegalArgumentException("units may not be less than 1");
        }
        String string2 = "(" + this.getX(n) + "," + this.getY(n) + ")->(" + this.getWidth(n) + "," + this.getHeight(n) + ")";
        if (string == null) {
            return string2;
        }
        return string2 + string;
    }

    public float[] getPrintableArea(int n) {
        return new float[]{this.getX(n), this.getY(n), this.getWidth(n), this.getHeight(n)};
    }
}

