/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class ArrayType
extends OpenType {
    private static final long serialVersionUID = 720504429830309770L;
    private int dimension;
    private OpenType elementType;
    private transient Integer hashCode;
    private transient String string;

    private static String getArrayClassName(String string, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, '[');
        return String.valueOf(cArray) + "L" + string;
    }

    public ArrayType(int n, OpenType openType) throws OpenDataException {
        super(ArrayType.getArrayClassName(openType.getClassName(), n), ArrayType.getArrayClassName(openType.getClassName(), n), n + "-dimension array of " + openType.getClassName());
        if (n < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than or equal to 1.");
        }
        if (!(openType instanceof SimpleType || openType instanceof CompositeType || openType instanceof TabularType)) {
            throw new OpenDataException("The element type must be a simple type, a composite type or a tabular type.");
        }
        this.dimension = n;
        this.elementType = openType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return arrayType.getDimension() == this.dimension && arrayType.getElementOpenType().equals(this.elementType);
    }

    public int getDimension() {
        return this.dimension;
    }

    public OpenType getElementOpenType() {
        return this.elementType;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.dimension + this.elementType.hashCode();
        }
        return this.hashCode;
    }

    public boolean isValue(Object object) {
        if (object == null) {
            return false;
        }
        Class clazz = object.getClass();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleType) {
            return this.getClassName().equals(clazz.getName());
        }
        Class clazz2 = null;
        try {
            clazz2 = Class.forName(this.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("The array type's element class could not be found.", classNotFoundException);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null || this.elementType.isValue(object2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.getClass().getName() + "[name=" + this.getTypeName() + ", dimension=" + this.dimension + ", elementType=" + this.elementType + "]";
        }
        return this.string;
    }
}

