/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

import javax.imageio.ImageReadParam;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;

public class JPEGImageReadParam
extends ImageReadParam {
    private JPEGQTable[] qTables;
    private JPEGHuffmanTable[] DCHuffmanTables;
    private JPEGHuffmanTable[] ACHuffmanTables;

    public boolean areTablesSet() {
        return this.qTables != null;
    }

    public void setDecodeTables(JPEGQTable[] jPEGQTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray2) {
        if (jPEGQTableArray == null || jPEGHuffmanTableArray == null || jPEGHuffmanTableArray2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (jPEGQTableArray.length > 4 || jPEGHuffmanTableArray.length > 4 || jPEGHuffmanTableArray2.length > 4) {
            throw new IllegalArgumentException("argument has too many elements");
        }
        if (jPEGHuffmanTableArray.length != jPEGHuffmanTableArray2.length) {
            throw new IllegalArgumentException("Huffman table arrays differ in length");
        }
        this.qTables = (JPEGQTable[])jPEGQTableArray.clone();
        this.DCHuffmanTables = (JPEGHuffmanTable[])jPEGHuffmanTableArray.clone();
        this.ACHuffmanTables = (JPEGHuffmanTable[])jPEGHuffmanTableArray2.clone();
    }

    public void unsetDecodeTables() {
        this.qTables = null;
        this.DCHuffmanTables = null;
        this.ACHuffmanTables = null;
    }

    public JPEGQTable[] getQTables() {
        if (this.qTables == null) {
            return this.qTables;
        }
        return (JPEGQTable[])this.qTables.clone();
    }

    public JPEGHuffmanTable[] getDCHuffmanTables() {
        if (this.DCHuffmanTables == null) {
            return this.DCHuffmanTables;
        }
        return (JPEGHuffmanTable[])this.DCHuffmanTables.clone();
    }

    public JPEGHuffmanTable[] getACHuffmanTables() {
        if (this.ACHuffmanTables == null) {
            return this.ACHuffmanTables;
        }
        return (JPEGHuffmanTable[])this.ACHuffmanTables.clone();
    }
}

