/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.classpath.debug.SystemLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private static final Logger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private final boolean isStream;
    private boolean eof;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.isStream = cipher.getBlockSize() == 1;
        this.eof = false;
    }

    protected CipherInputStream(InputStream inputStream) {
        this(inputStream, new NullCipher());
    }

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            this.nextBlock();
        }
        return this.outBuffer.length - this.outOffset;
    }

    public synchronized void close() throws IOException {
        super.close();
    }

    public synchronized int read() throws IOException {
        if (this.isStream) {
            byte[] byArray = new byte[1];
            int n = super.read();
            if (n == -1) {
                return -1;
            }
            byArray[0] = (byte)n;
            try {
                this.cipher.update(byArray, 0, 1, byArray, 0);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException(shortBufferException.getMessage());
            }
            return byArray[0] & 0xFF;
        }
        if (this.outBuffer == null || this.outOffset == this.outBuffer.length) {
            if (this.eof) {
                return -1;
            }
            this.nextBlock();
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return (int)this.skip(n2);
        }
        if (this.isStream) {
            if ((n2 = super.read(byArray, n, n2)) > 0) {
                try {
                    this.cipher.update(byArray, n, n2, byArray, n);
                }
                catch (ShortBufferException shortBufferException) {
                    IOException iOException = new IOException("Short buffer for stream cipher -- this should not happen");
                    iOException.initCause(shortBufferException);
                    throw iOException;
                }
            }
            return n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
                if (this.eof) {
                    if (n3 != 0) break;
                    n3 = -1;
                    break;
                }
                this.nextBlock();
            }
            int n4 = Math.min(this.outBuffer.length - this.outOffset, n2 - n3);
            System.arraycopy(this.outBuffer, this.outOffset, byArray, n3 + n, n4);
            n3 += n4;
            this.outOffset += n4;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        if (this.isStream) {
            return super.skip(l);
        }
        long l2 = 0L;
        if (l > 0L && this.outBuffer != null && this.outOffset >= this.outBuffer.length) {
            l2 = this.outBuffer.length - this.outOffset;
            this.outOffset = this.outBuffer.length;
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    /*
     * Exception decompiling
     */
    private void nextBlock() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

