/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractMap;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry root;
    final boolean accessOrder;

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    public void clear() {
        super.clear();
        this.root = null;
    }

    public boolean containsValue(Object object) {
        LinkedHashEntry linkedHashEntry = this.root;
        while (linkedHashEntry != null) {
            if (AbstractMap.equals(object, linkedHashEntry.value)) {
                return true;
            }
            linkedHashEntry = linkedHashEntry.succ;
        }
        return false;
    }

    public Object get(Object object) {
        int n = this.hash(object);
        HashMap.HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                hashEntry.access();
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        return false;
    }

    void addEntry(Object object, Object object2, int n, boolean bl) {
        LinkedHashEntry linkedHashEntry = new LinkedHashEntry(this, object, object2);
        linkedHashEntry.next = this.buckets[n];
        this.buckets[n] = linkedHashEntry;
        if (bl && this.removeEldestEntry(this.root)) {
            this.remove(this.root.key);
        }
    }

    void putAllInternal(Map map) {
        this.root = null;
        super.putAllInternal(map);
    }

    Iterator iterator(int n) {
        return new Iterator(this, n){
            private /* synthetic */ LinkedHashMap this$0;
            private /* synthetic */ int val$type;
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;
            {
                this.this$0 = linkedHashMap;
                this.finit$(n);
            }

            private /* synthetic */ void finit$(int n) {
                this.val$type = n;
                this.current = this.this$0.root;
                this.knownMod = this.this$0.modCount;
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                if (this.val$type == 1) {
                    return this.last.value;
                }
                if (this.val$type == 0) {
                    return this.last.key;
                }
                return this.last;
            }

            public void remove() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }
        };
    }

    class LinkedHashEntry
    extends HashMap.HashEntry {
        private /* synthetic */ LinkedHashMap this$0;
        LinkedHashEntry pred;
        LinkedHashEntry succ;

        LinkedHashEntry(LinkedHashMap linkedHashMap, Object object, Object object2) {
            this.this$0 = linkedHashMap;
            super(object, object2);
            if (linkedHashMap.root == null) {
                linkedHashMap.root = this;
                this.pred = this;
            } else {
                this.pred = linkedHashMap.root.pred;
                this.pred.succ = this;
                linkedHashMap.root.pred = this;
            }
        }

        void access() {
            if (this.this$0.accessOrder && this.succ != null) {
                ++this.this$0.modCount;
                if (this == this.this$0.root) {
                    this.this$0.root = this.succ;
                    this.pred.succ = this;
                    this.succ = null;
                } else {
                    this.pred.succ = this.succ;
                    this.succ.pred = this.pred;
                    this.succ = null;
                    this.pred = this.this$0.root.pred;
                    this.pred.succ = this;
                    this.this$0.root.pred = this;
                }
            }
        }

        Object cleanup() {
            if (this == this.this$0.root) {
                this.this$0.root = this.succ;
                if (this.succ != null) {
                    this.succ.pred = this.pred;
                }
            } else if (this.succ == null) {
                this.pred.succ = null;
                this.this$0.root.pred = this.pred;
            } else {
                this.pred.succ = this.succ;
                this.succ.pred = this.pred;
            }
            return this.value;
        }
    }
}

