/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public AttributedString(String string) {
        this.sci = new StringCharacterIterator(string);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String string, Map map) {
        this(string);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(this, map, 0, string.length());
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (n < 0 || n2 < n || n2 > attributedCharacterIterator.getEndIndex()) {
            throw new IllegalArgumentException("Bad index values");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Set set = attributedCharacterIterator.getAllAttributeKeys();
        if (attributeArray != null) {
            set.retainAll(Arrays.asList(attributeArray));
        }
        char c = attributedCharacterIterator.setIndex(n);
        ArrayList arrayList = new ArrayList();
        do {
            stringBuffer.append(c);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributedCharacterIterator.Attribute attribute;
                int n3;
                Object object = iterator.next();
                if (!(object instanceof AttributedCharacterIterator.Attribute) || (n3 = attributedCharacterIterator.getRunLimit(attribute = (AttributedCharacterIterator.Attribute)object)) == -1) continue;
                if (n3 > n2) {
                    n3 = n2;
                }
                n3 -= n;
                int n4 = attributedCharacterIterator.getRunStart(attribute);
                if (n4 < attributedCharacterIterator.getIndex() && attributedCharacterIterator.getIndex() != n) continue;
                Object object2 = attributedCharacterIterator.getAttribute(attribute);
                if ((n4 -= n) < 0) {
                    if (object2 instanceof Annotation) continue;
                    n4 = 0;
                }
                Hashtable hashtable = new Hashtable();
                hashtable.put(attribute, object2);
                arrayList.add(new AttributeRange(this, hashtable, n4, n3));
            }
            c = attributedCharacterIterator.next();
        } while (attributedCharacterIterator.getIndex() < n2);
        this.attribs = new AttributeRange[arrayList.size()];
        this.attribs = (AttributeRange[])arrayList.toArray(this.attribs);
        this.sci = new StringCharacterIterator(stringBuffer.toString());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        this.addAttribute(attribute, object, 0, this.sci.getEndIndex());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (attribute == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("Requires end > begin");
        }
        HashMap hashMap = new HashMap();
        hashMap.put(attribute, object);
        this.addAttributes(hashMap, n, n2);
    }

    public void addAttributes(Map map, int n, int n2) {
        if (map == null) {
            throw new NullPointerException("null attribute");
        }
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 <= n) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] attributeRangeArray = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, attributeRangeArray, 0, this.attribs.length);
        this.attribs = attributeRangeArray;
        this.attribs[this.attribs.length - 1] = new AttributeRange(this, map, n, n2);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex(), null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.sci.getEndIndex());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 < n) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, n, n2, attributeArray);
    }

    final class AttributeRange {
        private /* synthetic */ AttributedString this$0;
        Map attribs;
        int begin_index;
        int end_index;

        AttributeRange(AttributedString attributedString, Map map, int n, int n2) {
            this.this$0 = attributedString;
            this.attribs = map;
            this.begin_index = n;
            this.end_index = n2;
        }
    }
}

