/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.ResolverCache;
import java.net.UnknownHostException;
import java.net.VMInetAddress;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    static InetAddress LOCALHOST;
    static InetAddress ANY_IF;
    private int address;
    transient byte[] addr;
    String hostName;
    private int family;
    static InetAddress loopbackAddress;

    InetAddress(byte[] byArray, String string, int n) {
        this.addr = byArray == null ? null : (byte[])byArray.clone();
        this.hostName = string;
        this.family = n;
    }

    public boolean isMulticastAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMulticastAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isAnyLocalAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isAnyLocalAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isLoopbackAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isLoopbackAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isLinkLocalAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isLinkLocalAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isSiteLocalAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isSiteLocalAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isMCGlobal() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMCGlobal();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isMCNodeLocal() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMCNodeLocal();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isMCLinkLocal() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMCLinkLocal();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isMCSiteLocal() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMCSiteLocal();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public boolean isMCOrgLocal() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).isMCOrgLocal();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.getCanonicalHostName();
        }
        return this.hostName;
    }

    String internalGetCanonicalHostName() {
        try {
            return ResolverCache.getHostByAddr(this.addr);
        }
        catch (UnknownHostException unknownHostException) {
            return this.getHostAddress();
        }
    }

    public String getCanonicalHostName() {
        String string = this.internalGetCanonicalHostName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(string, -1);
            }
            catch (SecurityException securityException) {
                return this.getHostAddress();
            }
        }
        return string;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        try {
            return InetAddress.getByAddress(this.hostName, this.addr).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = this.addr.length;
        int n4 = n = n3 > 4 ? n3 - 4 : 0;
        while (n < n3) {
            n2 = n2 << 8 | this.addr[n] & 0xFF;
            ++n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InetAddress)) {
            return false;
        }
        byte[] byArray = ((InetAddress)object).addr;
        if (this.addr.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.addr.length; ++i) {
            if (this.addr[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = this.getHostAddress();
        String string2 = this.hostName != null ? this.hostName : "";
        return string2 + "/" + string;
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (byArray.length == 4) {
            return new Inet4Address(byArray, string);
        }
        if (byArray.length == 16) {
            for (int i = 0; i < 12; ++i) {
                if (byArray[i] == (i < 10 ? (byte)0 : -1)) continue;
                return new Inet6Address(byArray, string);
            }
            byte[] byArray2 = new byte[]{byArray[12], byArray[13], byArray[14], byArray[15]};
            return new Inet4Address(byArray2, string);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    static InetAddress getByLiteral(String string) {
        byte[] byArray = VMInetAddress.aton(string);
        if (byArray == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        return inetAddressArray[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        byte[][] byArray;
        if (string == null || string.length() == 0) {
            return new InetAddress[]{LOCALHOST};
        }
        InetAddress inetAddress = InetAddress.getByLiteral(string);
        if (inetAddress != null) {
            return new InetAddress[]{inetAddress};
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((byArray = ResolverCache.getHostByName(string)).length == 0) {
            throw new UnknownHostException(string);
        }
        InetAddress[] inetAddressArray = new InetAddress[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            inetAddressArray[i] = InetAddress.getByAddress(string, byArray[i]);
        }
        return inetAddressArray;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String string = VMInetAddress.getLocalHostname();
        try {
            return InetAddress.getByName(string);
        }
        catch (SecurityException securityException) {
            return LOCALHOST;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.addr, this.hostName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        for (int i = 2; i >= 0; --i) {
            this.addr[i] = (byte)(this.address >>= 8);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.addr.length;
        for (int i = n - 4; i < n; ++i) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
        }
        objectOutputStream.defaultWriteObject();
    }

    static native byte[] aton(String var0);

    static native InetAddress[] lookup(String var0, InetAddress var1, boolean var2);

    static native int getFamily(byte[] var0);

    static native String getLocalHostname();

    InetAddress(byte[] byArray, String string) {
        this.addr = byArray == null ? null : (byte[])byArray.clone();
        this.hostName = string;
        if (byArray != null) {
            this.family = InetAddress.getFamily(byArray);
        }
    }

    private static InetAddress[] allocArray(int n) {
        return new InetAddress[n];
    }

    private static SecurityException checkConnect(String string) {
        return null;
    }

    static {
        byte[] byArray;
        try {
            loopbackAddress = LOCALHOST = InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
        try {
            byArray = VMInetAddress.lookupInaddrAny();
        }
        catch (UnknownHostException unknownHostException) {
            byArray = new byte[]{0, 0, 0, 0};
        }
        try {
            ANY_IF = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("should never happen", unknownHostException);
        }
        InetAddress.ANY_IF.hostName = ANY_IF.getHostName();
    }
}

