/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3665804199014368530L;
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('Z');
    private final boolean value;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this.value = "true".equalsIgnoreCase(string);
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean bl) {
        if (bl) {
            return TRUE;
        }
        return FALSE;
    }

    public static Boolean valueOf(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return TRUE;
        }
        return FALSE;
    }

    public static String toString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public String toString() {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.value) {
            return 1231;
        }
        return 1237;
    }

    public boolean equals(Object object) {
        return object instanceof Boolean && this.value == ((Boolean)object).value;
    }

    public static boolean getBoolean(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return "true".equalsIgnoreCase(System.getProperty(string));
    }

    public int compareTo(Boolean bl) {
        if (this.value == bl.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Boolean)object);
    }

    public static boolean parseBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }
}

