/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n < 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        this.buf = new char[n];
        this.pos = n;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.buf = null;
                super.close();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void mark(int n) throws IOException {
        throw new IOException("mark not supported in this class");
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported in this class");
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.buf.length - this.pos > 0 || super.ready()) {
                    boolean bl2 = true;
                    Object var3_4 = null;
                    return bl2;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (l <= 0L) {
                    return 0L;
                }
                if ((long)(this.buf.length - this.pos) >= l) {
                    this.pos += (int)l;
                    return l;
                }
                int n = this.buf.length - this.pos;
                this.pos = this.buf.length;
                long l2 = this.in.skip(l - (long)n);
                return (long)n + l2;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos == this.buf.length) {
                    int n2 = super.read();
                    Object var3_4 = null;
                    return n2;
                }
                ++this.pos;
                n = this.buf[this.pos - 1] & 0xFFFF;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return n;
        }
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int n4 = Math.min(this.buf.length - this.pos, n2);
                if (n4 > 0) {
                    System.arraycopy(this.buf, this.pos, cArray, n, n4);
                    this.pos += n4;
                    int n5 = n4;
                    Object var7_8 = null;
                    return n5;
                }
                n3 = super.read(cArray, n, n2);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
            Object var7_9 = null;
            return n3;
        }
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos == 0) {
                    throw new IOException("Pushback buffer is full");
                }
                --this.pos;
                this.buf[this.pos] = (char)n;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public synchronized void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    public synchronized void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos < n2) {
                    throw new IOException("Pushback buffer is full");
                }
                System.arraycopy(cArray, n, this.buf, this.pos - n2, n2);
                this.pos -= n2;
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }
}

